/**
 * @file Singleton.h
 * Defines the Singleton class template
 * @author Alexandre Berge
 * @version 1.0
 * @date 16/07/2009
 */
#ifndef SINGLETON_H
#define SINGLETON_H
template <class T> 
/**
 * Template class for singleton objects.
 */
class Singleton
{
 public:
 /**
  * The methods returns the singleton instance of this class.
  * @return Class instance
  */
  static T& Instance() {
    static T m_instance;
    return m_instance;
  }
 
 protected:
  Singleton() {};
  virtual ~Singleton() {}; 

 private:
  Singleton(Singleton const&);  
  Singleton& operator=(Singleton const&); 
};

#endif
