#include "PortFilter.h"

PortFilter::PortFilter() :
	m_nPort(0)
{
}

PortFilter::PortFilter(const PortFilter & src) :
	Filter(src),
	m_nPort(src.m_nPort)
{
}

PortFilter::~PortFilter()
{
}

Filter * PortFilter::Clone() const
{
	return new PortFilter(*this);
}

bool PortFilter::Match(const ProtocolInfoElement * pProtocolInfo)
{
	if (pProtocolInfo->GetId() != EProtocolType_Udp &&
		pProtocolInfo->GetId() != EProtocolType_Tcp)
		return false;
	if (AreAllPacketsAccepted())
		return true;
	const TransportLayerInfo * pTransInfo = dynamic_cast<const TransportLayerInfo *>(pProtocolInfo);

	std::cout << "PortFilter::Match() "
		  << m_nPort << " "
		  << pTransInfo->GetDestinationPort() << " "
		  << pTransInfo->GetSourcePort() << " "
		  << std::endl;

	return m_nPort == pTransInfo->GetDestinationPort() || 
		m_nPort == pTransInfo->GetSourcePort();
}

void PortFilter::SetPortNumber(unsigned short nPort)
{
	m_nPort = nPort;
}



