#ifndef DISPATCH_INFO_H
#define DISPATCH_INFO_H

#include "ProtocolInfo.h"
#include <list>
#include <vector>

#ifdef _MSC_VER
typedef int ssize_t;
#endif

class DispatchInfo {
  
 public:
  DispatchInfo();
  ~DispatchInfo();
  const unsigned char * GetData() const;
  const ssize_t GetDataSize() const;
  void SetData(const unsigned char * pData, const ssize_t nDataSize); 
  void AddProtocolInfo(ProtocolInfoElement * info);
  ProtocolInfo * DetachProtocolInfo();
  ProtocolInfo * GetProtocolInfo() const;

private:
  unsigned char * m_pData;
  ssize_t m_nDataSize;
  ProtocolInfo * m_pProtocolInfo;
};

#endif
