/**
 * @file TcpipDefs.h
 * The file contains definitions needed for socket communication allowing to compile
 * the code with VisualStudio (using Winsock2 library) and with g++ (using POSIX sockets).
 * @author Tomas Urban
 * @version 0.1
 * @date 16/07/2009
 */
#ifndef TCPIP_DEFS_H
#define TCPIP_DEFS_H

#ifdef WIN32
#include <Winsock2.h>
#include <Ws2tcpip.h>
#define SOCKET_TYPE SOCKET /**< Defines compiler-specific socket handle type */
#define SOCKET_CALL_ERROR INVALID_SOCKET /**< Defines compiler-specific error value of some socket functions */
#define CLOSE_SOCKET closesocket /**< Defines compiler-specific function for closing sockets */
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#define SOCKET_TYPE int /**< Defines compiler-specific socket handle type */
#define SOCKET_CALL_ERROR -1 /**< Defines compiler-specific error value of some socket functions */
#define CLOSE_SOCKET close /**< Defines compiler-specific function for closing sockets */
#endif

#endif
