#ifndef MM_TRI_SA
#define MM_TRI_SA

#include "TriStructs.h"

TriStatus triSAReset();

TriStatus triExecuteTestCase (const TriTestCaseId*     testCaseId,
				const TriPortIdList*     tsiPortList);

TriStatus triMap (const TriPortId*         compPortId,
		  const TriPortId*         tsiPortId);

TriStatus triUnmap (const TriPortId* compPortId, const TriPortId* tsiPortId);

TriStatus triSend (const TriComponentId*      componentId,
				   const TriPortId*           tsiPortId,
				   const TriAddress*          sutAddress,
				   const TriMessage*          sendMessage);

TriStatus triCall (const TriComponentId*      componentId,
 				   const TriPortId*           tsiPortId, 
 				   const TriAddress*          sutAddress, 
 				   const TriSignatureId*      signatureId, 
 				   const TriParameterList*    parameterList);

TriStatus triReply (const TriComponentId*     componentId,
  					const TriPortId*          tsiPortId,
  					const TriAddress*         sutAddress,
  					const TriSignatureId*     signatureId,
  					const TriParameterList*   parameterList,
  					const TriParameter*       returnValue);

TriStatus triRaise (const TriComponentId*     componentId,
  					const TriPortId*          tsiPortId,
  					const TriAddress*         sutAddress,
  					const TriSignatureId*     signatureId,
  					const TriException*       exception);

TriStatus triSUTActionInformal (const char* description);

TriStatus triSendMC (const TriComponentId    *componentId,
					 const TriPortId         *tsiPortId,
					 const TriAddressList    *sutAddresses,
					 const TriMessage        *sendMessage);

TriStatus triSendBC (const TriComponentId    *componentId,
					 const TriPortId         *tsiPortId,
					 const TriMessage        *sendMessage);

TriStatus triCallMC (const TriComponentId    *componentId,
					 const TriPortId         *tsiPortId,
					 const TriAddressList    *sutAddresses,
					 const TriSignatureId    *signatureId,
					 const TriParameterList  *parameterList);

TriStatus triCallBC (const TriComponentId    *componentId,
					 const TriPortId         *tsiPortId,
					 const TriSignatureId    *signatureId,
					 const TriParameterList  *parameterList);

TriStatus triReplyMC (const TriComponentId   *componentId,
					  const TriPortId        *tsiPortId,
					  const TriAddressList   *sutAddresses,
					  const TriSignatureId   *signatureId,
					  const TriParameterList *parameterList,
					  const TriParameter     *returnValue);

TriStatus triReplyBC (const TriComponentId   *componentId,
					  const TriPortId        *tsiPortId, 
					  const TriSignatureId   *signatureId, 
					  const TriParameterList *parameterList, 
					  const TriParameter     *returnValue);

TriStatus triRaiseMC (const TriComponentId   *componentId, 
					  const TriPortId        *tsiPortId, 
					  const TriAddressList   *sutAddresses, 
					  const TriSignatureId   *signatureId, 
					  const TriException     *exception);

TriStatus triRaiseBC (const TriComponentId   *componentId, 
					  const TriPortId        *tsiPortId, 
					  const TriSignatureId   *signatureId, 
					  const TriException     *exception);

TriStatus triEndTestcase(void);

#endif
