<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml" version="2.0">
<xsl:output method="xhtml" indent="yes" name="html" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>

<xsl:param name="folder"/>
<xsl:param name="includeconstructbodies"/>
<xsl:param name="hideconstructbodies"/>
<xsl:param name="showOriginalT3DocTags"/>
<!-- //TODO: add further parameters such as file names for scripts and such -->




<xsl:template match="/">
 <xsl:for-each select="//module">
  <xsl:variable name="filename" select="concat('file:///', $folder, '/html/import_', @name, '.html')"/>
  <xsl:value-of select="$filename"/>
   <xsl:result-document href="{$filename}" format="html">   
    <xsl:call-template name="import_module">
     <xsl:with-param name="module" select="."/>
    </xsl:call-template>
  </xsl:result-document>
 </xsl:for-each>
</xsl:template>

<xsl:template name="import_module">
<xsl:param name="module"/>
<xsl:param name="modulename" select="$module/@name"/>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <xsl:call-template name="html_head">
  <xsl:with-param name="title" select="concat($modulename, ' - Import  View')"/>
 </xsl:call-template>
 <body>
  <div id="div_views">
	<p id="p_views">
	 <a href="{concat($module/@name, '.html')}">Main View</a> <br/>
	 <a href="{concat('mp_', $module/@name, '.html')}">Module Parameter/Testcase View</a> <br/>
	 <a href="{concat('import_', $module/@name, '.html')}">Import  View</a> <br/>
	 <br/>
	 <a href="#" onclick="toggleImportDetails()">toggle import details</a>		
	</p>
  </div>
  <p id="p_t3dversion">T3D <xsl:value-of select="/imports/@t3dversion"/><br/>Generated <xsl:value-of select="concat(substring-before(string(current-date()), '+'), ' - ', substring-before(string(current-time()), '.'))"/></p>
  <div id="div_modules">
   <p class="index_headline"><a href="import_index.html">Module Index</a>
     <xsl:for-each select="//module">
      <xsl:sort select="@name"/>
      <br/><a class="padding_left_10px" href="{concat('import_', @name)}.html"><xsl:value-of select="@name"/></a>  
     </xsl:for-each>
   </p>
  </div>
  <xsl:call-template name="legend"/>
  <p id="p_header"><a href="import_index.html">Index</a><xsl:value-of select="' / '"/><xsl:value-of select="$modulename"/> - Import  View</p> 
  <div id="div_content">
   <div id="div_import">
   <table id="table_import">
    <tr>
     <th><span class="imports">imports</span></th><th>Modules</th><th><span class="importedby">imported by</span></th>
    </tr>
    <tr>
     <td>
      <xsl:for-each select="$module/import[not(@name = preceding-sibling::import/@name)]/@name">
       <xsl:sort select="."/>
       <xsl:call-template name="import">
        <xsl:with-param name="module" select="$module"/>
        <xsl:with-param name="importname" select="."/>
       </xsl:call-template>
      </xsl:for-each>      
     <xsl:variable name="indirectimports" select="$module/import//import[not(@name = $module/import/@name) and not(@name = $module/@name)]"/>
     <xsl:if test="$indirectimports">
     <br/>Indirect dependencies:
     </xsl:if>
     <xsl:for-each select="$indirectimports[not(@name = preceding-sibling::*/@name)]/@name">
      <xsl:sort select="."/>
      <xsl:variable name="name" select="."/>
      <br/>       
      <xsl:choose>
       <xsl:when test="//module[@name eq $name]">
        <a class="padding_left_10px" href="{concat('import_', $name, '.html')}"><xsl:value-of select="$name"/></a>
       </xsl:when>
       <xsl:otherwise>
        <span class="padding_left_10px"><xsl:value-of select="$name"/></span>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
     </td>
     <td  id="table_import_modules">
      <xsl:for-each select="//module">
       <xsl:sort select="@name"/>
       <p>
        <xsl:call-template name="show_imports">
         <xsl:with-param name="currentmodule" select="$module"/>   
         <xsl:with-param name="module" select="."/>
        </xsl:call-template>
       </p>
      </xsl:for-each>
     </td>
     <td>
     <xsl:for-each select="//module">
      <xsl:sort select="@name"/>
      <xsl:if test="import[@name eq $module/@name]">
       <a href="{concat('import_', @name, '.html')}"><xsl:value-of select="@name"/></a>
        <xsl:call-template name="importby">
         <xsl:with-param name="imports" select="./import[@name eq $module/@name]"/>
        </xsl:call-template>
      </xsl:if>
     </xsl:for-each>
     <xsl:variable name="indirectdependencies" select="//module[import//import[@name = $module/@name and not(@name = ancestor::module/import/@name)] and not(@name = $module/@name)]"/>
     <xsl:if test="$indirectdependencies">
     <br/>Indirect dependencies:
     </xsl:if>
     <xsl:for-each select="$indirectdependencies[not(@name = preceding-sibling::*/@name)]/@name">
      <xsl:sort select="."/>
      <xsl:variable name="name" select="."/>
      <br/>       
      <xsl:choose>
       <xsl:when test="//module[@name eq $name]">
        <a class="padding_left_10px" href="{concat('import_', $name, '.html')}"><xsl:value-of select="$name"/></a>
       </xsl:when>
       <xsl:otherwise>
        <span class="padding_left_10px"><xsl:value-of select="$name"/></span>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
     </td>
    </tr>
   </table>
  </div>
  </div>
 </body>
</html>
</xsl:template>

<xsl:template name="import">
 <xsl:param name="module"/>
 <xsl:param name="importname"/> 
 <xsl:if test="$module/import[@name eq $importname]">
  <xsl:choose>
   <xsl:when test="//module[@name = $importname]">
    <a href="{concat('import_', ., '.html')}"><xsl:value-of select="concat(., @name)"/></a>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="concat(., @name)"/>
   </xsl:otherwise>
  </xsl:choose>
  <table class="padding_left_10px">
   <xsl:for-each select="$module/import[@name eq $importname]">
     <tr>
     <td>
      <span class="span_importdetail">
       <xsl:apply-templates select="import_behaviour"/><br/>
      </span>
     </td>
    </tr>
   </xsl:for-each>
  </table>
 </xsl:if>
</xsl:template>

<xsl:template name="importby">
 <xsl:param name="imports"/>
 <xsl:if test="$imports">
  <table class="padding_left_10px">
   <xsl:for-each select="$imports">
     <tr>
     <td><span class="span_importdetail"><xsl:apply-templates select="import_behaviour"/></span></td>
    </tr>
   </xsl:for-each>
  </table>
 </xsl:if>
</xsl:template>


<xsl:template name="show_imports">
 <xsl:param name="module"/>
 <xsl:param name="currentmodule"/> 
 <xsl:choose>
  <xsl:when test="$currentmodule/@name eq $module/@name">
   <xsl:call-template name="colored_module"> 
    <xsl:with-param name="module" select="$module"/>
    <xsl:with-param name="color" select="'selected'"/>
   </xsl:call-template>
  </xsl:when>  
  <xsl:when test="$currentmodule/import[@name eq $module/@name]">
   <xsl:call-template name="colored_module"> 
    <xsl:with-param name="module" select="$module"/>
    <xsl:with-param name="color" select="'imports'"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:when test="$currentmodule//import[@name eq $module/@name]">
   <xsl:call-template name="colored_module"> 
    <xsl:with-param name="module" select="$module"/>
    <xsl:with-param name="color" select="'imports_ind'"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:when test="$module/import[@name eq $currentmodule/@name]">
   <xsl:call-template name="colored_module"> 
    <xsl:with-param name="module" select="$module"/>
    <xsl:with-param name="color" select="'importedby'"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:when test="$module//import[@name eq $currentmodule/@name]">
   <xsl:call-template name="colored_module"> 
    <xsl:with-param name="module" select="$module"/>
    <xsl:with-param name="color" select="'importedby_ind'"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:otherwise>
   <xsl:call-template name="colored_module"> 
    <xsl:with-param name="module" select="$module"/>
    <xsl:with-param name="color" select="'normal'"/>
   </xsl:call-template>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>
<xsl:template name="colored_module">
 <xsl:param name="module"/> 
 <xsl:param name="color"/> 
 <a href="{concat('import_', $module/@name, '.html')}" class="{$color}"><xsl:value-of select="$module/@name"/></a>
</xsl:template>

<xsl:template match="import_behaviour">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template name="html_head">
<xsl:param name="title"/>
 <head>
  <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
  <link rel="stylesheet" type="text/css" href="css/doc.css"/>
   <xsl:choose>
    <xsl:when test="$showOriginalT3DocTags eq 'true'">
     <style type="text/css">
       .span_tagtype{
       	display:none;
      }
     </style>   
    </xsl:when>
    <xsl:otherwise>
     <style type="text/css">
      .span_tagtypeOrig{
       	display:none;
      }
     </style>   
    </xsl:otherwise>
   </xsl:choose>
  <script type="text/javascript" src="js/doc.js"></script>
  <script type="text/javascript" src="js/index.js"></script>
  <title><xsl:value-of select="$title"/></title>
 </head>
</xsl:template>

<xsl:template match="link">
 <xsl:variable name="loc" select="@loc" />
 <a href="{@loc}"><xsl:value-of select="replace(replace(text(), ' ', '&#160;'), '\t', '&#x9;')"/></a> 
</xsl:template>

<xsl:template name="legend">
  <div id="div_index">
   <p>Legend:</p>
    <p class="padding_left_10px">
     <span class="imports">Selected module imports this module</span>
     <br/>
     <br/>
     <span class="imports_ind">Selected module indirectly depends on this module</span>
     <br/>
     <br/>
     <span class="importedby">Selected module is imported by this module</span>
     <br/>
     <br/>
     <span class="importedby_ind">This module indirectly depends on the selected module</span>
     <br/>
     <br/>
     <span class="selected">Selected module</span>    
    </p>
  </div>
</xsl:template>

</xsl:stylesheet>