package org.etsi.common.configuration;

import org.etsi.common.logging.LoggingConfiguration;

public abstract class ConfigurationProfile {

	protected String profileName;
	protected String profileVersion;
	protected String resourceExtensionsRegExp = "ttcn|ttcn3|3mp";
	protected String projectExtension = "t3p";
	protected boolean settingRecursiveProcessing = true;
	protected boolean settingAbortOnError = true;
	protected LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
	protected boolean statShowSummary = true;
	protected boolean statShowLOC = true;

	public ConfigurationProfile() {
		super();
	}

	public String getProfileName() {
		return profileName;
	}

	public void setProfileName(String profileName) {
		this.profileName = profileName;
	}

	public void setSettingRecursiveProcessing(boolean settingRecursiveProcessing) {
		this.settingRecursiveProcessing = settingRecursiveProcessing;
	}

	public boolean isSettingRecursiveProcessing() {
		return settingRecursiveProcessing;
	}

	public void setStatShowLOC(boolean statShowLOC) {
		this.statShowLOC = statShowLOC;
	}

	public boolean isStatShowLOC() {
		return statShowLOC;
	}

	public void setSettingAbortOnError(boolean settingAbortOnError) {
		this.settingAbortOnError = settingAbortOnError;
	}

	public boolean isSettingAbortOnError() {
		return settingAbortOnError;
	}

	public void setProfileVersion(String profileVersion) {
		this.profileVersion = profileVersion;
	}

	public String getProfileVersion() {
		return profileVersion;
	}

	public void setLoggingConfiguration(LoggingConfiguration loggingConfiguration) {
		this.loggingConfiguration = loggingConfiguration;
	}

	public LoggingConfiguration getLoggingConfiguration() {
		return loggingConfiguration;
	}

	public void setStatShowSummary(boolean statShowSummary) {
		this.statShowSummary = statShowSummary;
	}

	public boolean isStatShowSummary() {
		return statShowSummary;
	}

	public void setResourceExtensionsRegExp(String resourceExtensionsRegExp) {
		this.resourceExtensionsRegExp = resourceExtensionsRegExp;
	}

	public String getResourceExtensionsRegExp() {
		return resourceExtensionsRegExp;
	}

	public void setProjectExtension(String projectExtension) {
		this.projectExtension = projectExtension;
	}

	public String getProjectExtension() {
		return projectExtension;
	}

}