/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public final class CharSlice
implements CharSequence,
Serializable {
    private char[] array;
    private int offset;
    private int count;

    public CharSlice(char[] array) {
        this.array = array;
        this.offset = 0;
        this.count = array.length;
    }

    public CharSlice(char[] array, int start, int length) {
        this.array = array;
        this.offset = start;
        this.count = length;
        if (start + length > array.length) {
            throw new IndexOutOfBoundsException("start(" + start + ") + length(" + length + ") > size(" + array.length + ')');
        }
    }

    public int length() {
        return this.count;
    }

    public void setLength(int length) {
        this.count = length;
    }

    public char charAt(int index) {
        return this.array[this.offset + index];
    }

    public CharSequence subSequence(int start, int end) {
        return new CharSlice(this.array, this.offset + start, end - start);
    }

    public String toString() {
        return new String(this.array, this.offset, this.count);
    }

    public boolean equals(Object other) {
        return this.toString().equals(other);
    }

    public int hashCode() {
        int end = this.offset + this.count;
        int h = 0;
        for (int i = this.offset; i < end; ++i) {
            h = 31 * h + this.array[i];
        }
        return h;
    }

    public int indexOf(char c) {
        int end = this.offset + this.count;
        for (int i = this.offset; i < end; ++i) {
            if (this.array[i] != c) continue;
            return i - this.offset;
        }
        return -1;
    }

    public String substring(int start, int end) {
        return new String(this.array, this.offset + start, end - start);
    }

    public void copyTo(char[] destination, int destOffset) {
        System.arraycopy(this.array, this.offset, destination, destOffset, this.count);
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.array, this.offset, this.count);
    }
}

