<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
 <xsl:param name="modulenames" select="//element[not(@module = preceding-sibling::*/@module)]/@module"/>
  <html>
  <head>
  </head>
  <body>

   <xsl:for-each select="$modulenames">
    <xsl:call-template name="module">
     <xsl:with-param name="modulename" select="."/>
    </xsl:call-template>
   </xsl:for-each>

  </body>
  </html>
</xsl:template>


<xsl:template name="module">
 <xsl:param name="modulename"/>
 <p><xsl:value-of select="."/></p>
 <xsl:apply-templates select="//element[@module = $modulename]"/>
</xsl:template>

<xsl:template match="element">
 <p><a name="{@id}"><xsl:value-of select="@name"/></a></p>
 <xsl:apply-templates select="reflist"/>
</xsl:template>


<xsl:template match="reflist">
 <xsl:apply-templates select="ref"/>
</xsl:template>

<xsl:template match="ref">
 <xsl:param name="id" select="@id"/>
 <xsl:param name="ref" select="//element[@id = $id]"/>

 <p><xsl:value-of select="'->'"/><a href="{concat('#', $id)}"><xsl:value-of select="$ref/@name"/></a></p>
 

</xsl:template>


</xsl:stylesheet>