package org.etsi.common;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WildcardFilter implements FileFilter {

	private String wildcardRegExp = "";
	
	public WildcardFilter(File wildcardFile){
		String wildcardRegExp = wildcardFile.getName();
		wildcardRegExp = wildcardRegExp.replaceAll("\\.", "\\\\.");
		wildcardRegExp = wildcardRegExp.replaceAll("\\?", ".");
		wildcardRegExp = wildcardRegExp.replaceAll("\\*", ".*");
		this.wildcardRegExp = wildcardRegExp;
	}
	
	@Override
	public boolean accept(File file) {
		if (file.isFile() || file.isDirectory()){
			Pattern wildcardPattern = Pattern.compile(this.wildcardRegExp);
			Matcher wildcardMatcher = wildcardPattern.matcher(file.getName());
			if (wildcardMatcher.matches()) {
				return true;
			}
		}
		return false;
	}

}
