package org.etsi.common;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtensionFilter implements FileFilter {

	private String extRegExp = "";

	public ExtensionFilter(String extRegExp) {
		this.extRegExp = extRegExp;
	}

	public static String getFileExtension(String filename) {
		String ext = "";
		new File(filename);
		int i = filename.lastIndexOf('.');
		if (i > 0 && i < filename.length() - 1) {
			ext = filename.substring(i + 1).toLowerCase();
		}
		return ext;
	}

	public static boolean checkFileExtension(File file, String regExp){
		Pattern extPattern = Pattern.compile(regExp);
		Matcher extMatcher = extPattern.matcher(getFileExtension(file.getName()));
			if (extMatcher.matches()) {
				return true;
			}

		return false;
	}
	
	public boolean accept(File filename) {
		if (filename.isFile()) {
			if (checkFileExtension(filename, this.extRegExp)) {
				return true;
			}
		}
		return false;
	}

}
