/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;

public class DocumentBuilder {
    private Configuration config;
    private SchemaValidator schemaValidator;
    private boolean retainPSVI = true;
    private boolean dtdValidation;
    private boolean lineNumbering;
    private WhitespaceStrippingPolicy whitespacePolicy;
    private URI baseURI;

    protected DocumentBuilder(Configuration config) {
        this.config = config;
    }

    public void setLineNumbering(boolean option) {
        this.lineNumbering = option;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setSchemaValidator(SchemaValidator validator) {
        this.schemaValidator = validator;
    }

    public SchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    public void setRetainPSVI(boolean retainPSVI) {
        this.retainPSVI = retainPSVI;
    }

    public boolean isRetainPSVI() {
        return this.retainPSVI;
    }

    public void setDTDValidation(boolean option) {
        this.dtdValidation = option;
    }

    public boolean isDTDValidation() {
        return this.dtdValidation;
    }

    public void setWhitespaceStrippingPolicy(WhitespaceStrippingPolicy policy) {
        this.whitespacePolicy = policy;
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return this.whitespacePolicy;
    }

    public void setBaseURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.baseURI = uri;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public XdmNode build(Source source) throws SaxonApiException {
        AugmentedSource as = AugmentedSource.makeAugmentedSource((Source)source);
        as.setDTDValidationMode(this.dtdValidation ? 1 : 4);
        if (this.schemaValidator != null) {
            as.setSchemaValidationMode(this.schemaValidator.isLax() ? 2 : 1);
            if (this.schemaValidator.getDocumentElementName() != null) {
                as.setTopLevelElement(this.schemaValidator.getDocumentElementName().getStructuredQName());
            }
            if (this.schemaValidator.getDocumentElementType() != null) {
                as.setTopLevelType(this.schemaValidator.getDocumentElementType());
            }
        }
        if (this.whitespacePolicy != null) {
            as.setStripSpace(this.whitespacePolicy.ordinal());
        }
        as.setLineNumbering(this.lineNumbering);
        if (source.getSystemId() == null && this.baseURI != null) {
            source.setSystemId(this.baseURI.toString());
        }
        try {
            DocumentInfo doc = this.config.buildDocument((Source)as);
            return new XdmNode((NodeInfo)doc);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmNode build(File file) throws SaxonApiException {
        return this.build(new StreamSource(file));
    }

    public XdmNode wrap(Object node) throws IllegalArgumentException {
        try {
            JPConverter converter = JPConverter.allocate(node.getClass(), (Configuration)this.config);
            NodeInfo nodeInfo = (NodeInfo)converter.convert(node, (XPathContext)new EarlyEvaluationContext(this.config, null));
            return (XdmNode)XdmItem.wrapItem((Item)nodeInfo);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

