/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.common;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import org.etsi.common.ExtensionFilter;
import org.etsi.common.WildcardFilter;

public class InputInterface {
    private String projectExt = "ecp";
    private String extRegExp = "ttcn|ttcn3";
    private boolean recursive = true;

    public InputInterface(String resourceExtRegExp, boolean recursive) {
        this.extRegExp = resourceExtRegExp;
        this.recursive = recursive;
    }

    public InputInterface(String resourceExtRegExp, String projectExt, boolean recursive) {
        this.extRegExp = resourceExtRegExp;
        this.projectExt = projectExt;
        this.recursive = recursive;
    }

    public void setExtRegExp(String extRegExp) {
        this.extRegExp = extRegExp;
    }

    public String getExtRegExp() {
        return this.extRegExp;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public List<String> inputFromFile(String filename) {
        LinkedList<String> files = new LinkedList<String>();
        File file = new File(filename);
        if (file.isFile() && ExtensionFilter.checkFileExtension(file, this.extRegExp)) {
            files.add(file.getPath());
        }
        return files;
    }

    public List<String> inputFromDirectory(String directory) {
        LinkedList<String> files = new LinkedList<String>();
        File inputDir = new File(directory);
        File[] fileList = inputDir.listFiles(new ExtensionFilter(this.getExtRegExp()));
        int i = 0;
        while (i < fileList.length) {
            files.add(fileList[i].getPath());
            ++i;
        }
        File[] dirList = inputDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (this.isRecursive()) {
            int i2 = 0;
            while (i2 < dirList.length) {
                files.addAll(this.inputFromDirectory(dirList[i2].getPath()));
                ++i2;
            }
        }
        return files;
    }

    public List<String> inputFromWildcard(String wildcard) {
        LinkedList<String> files = new LinkedList<String>();
        File wildcardFile = new File(wildcard);
        File wildcardParentFile = wildcardFile.getParentFile();
        System.out.println(wildcardParentFile);
        if (wildcardParentFile.isDirectory()) {
            File[] fileList = wildcardParentFile.listFiles(new WildcardFilter(wildcardFile));
            int i = 0;
            while (i < fileList.length) {
                files.add(fileList[i].getPath());
                ++i;
            }
        }
        return files;
    }

    public List<String> inputFromProject(String projectFilename) {
        LinkedList<String> files = new LinkedList<String>();
        return files;
    }

    public void addToProject(List<String> files, String projectFilename) {
    }

    public List<String> getInputFromParameter(String inputParameter) {
        List<String> inputFiles = new LinkedList<String>();
        File inputParameterFile = new File(inputParameter);
        if (inputParameterFile.isDirectory()) {
            if (this.isRecursive()) {
                System.out.println("Collecting ttcn3 files recursively in \"" + inputParameter + "\" ...");
            } else {
                System.out.println("Collecting ttcn3 files non-recursively in \"" + inputParameter + "\" ...");
            }
            inputFiles = this.inputFromDirectory(inputParameter);
        } else if (inputParameterFile.isFile()) {
            inputFiles = inputParameterFile.getName().endsWith("." + this.projectExt) ? this.inputFromProject(inputParameter) : this.inputFromFile(inputParameter);
        }
        return inputFiles;
    }
}

