/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.function;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.util.function.Exceptions;

@FunctionalInterface
@ConsumerType
public interface Predicate<T> {
    public boolean test(T var1) throws Exception;

    default public Predicate<T> negate() {
        return t2 -> !this.test(t2);
    }

    default public Predicate<T> and(Predicate<? super T> and) {
        Objects.requireNonNull(and);
        return t2 -> this.test(t2) && and.test(t2);
    }

    default public Predicate<T> or(Predicate<? super T> or) {
        Objects.requireNonNull(or);
        return t2 -> this.test(t2) || or.test(t2);
    }

    public static <T> java.util.function.Predicate<T> asJavaPredicate(Predicate<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return t2 -> {
            try {
                return wrapped.test(t2);
            }
            catch (Exception e) {
                throw Exceptions.throwUnchecked(e);
            }
        };
    }

    public static <T> java.util.function.Predicate<T> asJavaPredicateOrElse(Predicate<T> wrapped, boolean orElse) {
        Objects.requireNonNull(wrapped);
        return t2 -> {
            try {
                return wrapped.test(t2);
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    public static <T> java.util.function.Predicate<T> asJavaPredicateOrElseGet(Predicate<T> wrapped, BooleanSupplier orElseGet) {
        Objects.requireNonNull(wrapped);
        return t2 -> {
            try {
                return wrapped.test(t2);
            }
            catch (Exception e) {
                return orElseGet.getAsBoolean();
            }
        };
    }

    public static <T> Predicate<T> asPredicate(java.util.function.Predicate<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return wrapped::test;
    }
}

