/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.AbstractValidationDiagnostic;
import org.eclipse.xtext.validation.CheckType;

public class RangeBasedDiagnostic
extends AbstractValidationDiagnostic {
    private final int offset;
    private final int length;

    protected RangeBasedDiagnostic(int severity, String message, EObject source, int offset, int length, CheckType checkType, String issueCode, String[] issueData) {
        super(severity, message, source, checkType, issueCode, issueData);
        this.offset = offset;
        this.length = length;
    }

    @Override
    public List<?> getData() {
        if (this.getIssueData() == null) {
            return ImmutableList.of(this.getSourceEObject(), Integer.valueOf(this.offset), Integer.valueOf(this.length));
        }
        return ImmutableList.of(this.getSourceEObject(), Integer.valueOf(this.offset), Integer.valueOf(this.length), this.getIssueData());
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String getSource() {
        return super.getSource() + "@[" + this.offset + ":" + this.length + "]";
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append("@[").append(this.offset).append(":").append(this.length).append("]");
        return result.toString();
    }
}

