/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;

@Beta
public class LocalUniqueNameContext
implements INamesAreUniqueValidationHelper.Context,
ISelectable {
    private final List<IEObjectDescription> objectsToValidate;
    private final Map<String, Object> index;
    private final CancelIndicator ci;

    public LocalUniqueNameContext(EObject container, Function<EObject, String> nameFunction, CancelIndicator ci) {
        this(container, false, nameFunction, ci);
    }

    public LocalUniqueNameContext(EObject container, CancelIndicator ci) {
        this(container, LocalUniqueNameContext::tryGetName, ci);
    }

    public LocalUniqueNameContext(EObject container, boolean deep, CancelIndicator ci) {
        this(container, deep, LocalUniqueNameContext::tryGetName, ci);
    }

    public LocalUniqueNameContext(EObject container, boolean deep, Function<EObject, String> nameFunction, CancelIndicator ci) {
        this(deep ? () -> container.eAllContents() : container.eContents(), nameFunction, ci);
    }

    public <T extends EObject> LocalUniqueNameContext(Iterable<T> objects, Function<T, String> nameFunction, CancelIndicator ci) {
        HashMap<String, Object> index = new HashMap<String, Object>();
        ArrayList<IEObjectDescription> objectsToValidate = new ArrayList<IEObjectDescription>();
        for (EObject t2 : objects) {
            String name = nameFunction.apply(t2);
            if (name == null) continue;
            IEObjectDescription description = EObjectDescription.create(name, t2);
            objectsToValidate.add(description);
            index.merge(name, description, (p, n) -> {
                if (p instanceof List) {
                    List list = (List)p;
                    list.add(n);
                    return list;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(p);
                list.add(n);
                return list;
            });
        }
        this.objectsToValidate = objectsToValidate;
        this.index = index;
        this.ci = ci;
    }

    public LocalUniqueNameContext(List<? extends EObject> objects, CancelIndicator ci) {
        this(objects, LocalUniqueNameContext::tryGetName, ci);
    }

    @Override
    public boolean isUnique() {
        return this.objectsToValidate.size() == this.index.size();
    }

    @Override
    public final boolean isCaseSensitive(EObject candidate, EClass clusterType) {
        return true;
    }

    @Override
    public ISelectable getValidationScope(IEObjectDescription description, EClass clusterType) {
        return this;
    }

    public List<IEObjectDescription> getObjectsToValidate() {
        return this.objectsToValidate;
    }

    @Override
    public CancelIndicator cancelIndicator() {
        return this.ci;
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        return this.getObjectsToValidate();
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        Preconditions.checkArgument(!ignoreCase);
        Object result = this.index.get(name.getFirstSegment());
        if (result == null) {
            return Collections.emptyList();
        }
        if (result instanceof IEObjectDescription) {
            if (EcoreUtil2.isAssignableFrom(type, ((IEObjectDescription)result).getEClass())) {
                return Collections.singletonList((IEObjectDescription)result);
            }
            return Collections.emptyList();
        }
        List casted = (List)result;
        if (type == EcorePackage.Literals.EOBJECT) {
            return casted;
        }
        return FluentIterable.from(casted).filter(it -> EcoreUtil2.isAssignableFrom(type, it.getEClass()));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        return FluentIterable.from(this.objectsToValidate).filter(it -> object == it.getEObjectOrProxy());
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        return FluentIterable.from(this.objectsToValidate).filter(it -> EcoreUtil2.isAssignableFrom(type, it.getEClass()));
    }

    private static String tryGetName(EObject obj) {
        if (obj == null) {
            return null;
        }
        EStructuralFeature name = obj.eClass().getEStructuralFeature("name");
        if (name != null && name.getEType() == EcorePackage.Literals.ESTRING) {
            return (String)obj.eGet(name);
        }
        return null;
    }
}

