/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class TransientValueUtil {
    @Inject
    protected ITransientValueService transientValues;

    public List<EObject> getAllNonTransientValues(EObject container, EReference feature) {
        switch (this.transientValues.isListTransient(container, feature)) {
            case SOME: {
                ArrayList<EObject> result = Lists.newArrayList();
                List values = (List)container.eGet(feature);
                int i = 0;
                while (i < values.size()) {
                    if (!this.transientValues.isValueInListTransient(container, i, feature)) {
                        result.add((EObject)values.get(i));
                    }
                    ++i;
                }
                return result;
            }
            case NO: {
                return (List)container.eGet(feature);
            }
            case YES: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public List<Object> getAllNonTransientValues(EObject container, EStructuralFeature feature) {
        switch (this.transientValues.isListTransient(container, feature)) {
            case SOME: {
                ArrayList<Object> result = Lists.newArrayList();
                List values = (List)container.eGet(feature);
                int i = 0;
                while (i < values.size()) {
                    if (!this.transientValues.isValueInListTransient(container, i, feature)) {
                        result.add(values.get(i));
                    }
                    ++i;
                }
                return result;
            }
            case NO: {
                return (List)container.eGet(feature);
            }
            case YES: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public int countNonTransientListValues(EObject container, EStructuralFeature feature) {
        switch (this.transientValues.isListTransient(container, feature)) {
            case SOME: {
                int result = 0;
                List values = (List)container.eGet(feature);
                int i = 0;
                while (i < values.size()) {
                    if (!this.transientValues.isValueInListTransient(container, i, feature)) {
                        ++result;
                    }
                    ++i;
                }
                return result;
            }
            case NO: {
                return ((List)container.eGet(feature)).size();
            }
            case YES: {
                return 0;
            }
        }
        return 0;
    }

    public ITransientValueService.ValueTransient isTransient(EObject obj, EStructuralFeature feature) {
        if (feature.isMany()) {
            switch (this.transientValues.isListTransient(obj, feature)) {
                case NO: {
                    return ITransientValueService.ValueTransient.NO;
                }
                case YES: {
                    return ITransientValueService.ValueTransient.YES;
                }
                case SOME: {
                    List values = (List)obj.eGet(feature);
                    int i = 0;
                    while (i < values.size()) {
                        if (!this.transientValues.isValueInListTransient(obj, i, feature)) {
                            return ITransientValueService.ValueTransient.NO;
                        }
                        ++i;
                    }
                    break;
                }
            }
            return ITransientValueService.ValueTransient.YES;
        }
        return this.transientValues.isValueTransient(obj, feature);
    }
}

