/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;

public class SemanticNodeProvider
implements ISemanticNodeProvider {
    protected NodesForEObjectProvider createNodesForEObjectProvider(EObject semanticObject, ICompositeNode node) {
        return new NodesForEObjectProvider(semanticObject, node);
    }

    @Override
    public ISemanticNodeProvider.INodesForEObjectProvider getNodesForSemanticObject(EObject semanticObject, ICompositeNode suggestedComposite) {
        if (suggestedComposite != null) {
            return this.createNodesForEObjectProvider(semanticObject, suggestedComposite);
        }
        ICompositeNode actualComposite = NodeModelUtils.findActualNodeFor(semanticObject);
        if (actualComposite != null) {
            return this.createNodesForEObjectProvider(semanticObject, actualComposite);
        }
        return ISemanticNodeProvider.NULL_NODES_PROVIDER;
    }

    public static class NodesForEObjectProvider
    implements ISemanticNodeProvider.INodesForEObjectProvider {
        protected final Object[] childrenByFeatureIDAndIndex;
        protected Map<EObject, SemanticNode> childrenBySemanticChild = null;
        protected SemanticNode first = null;
        protected final ICompositeNode node;
        protected final EObject semanticObject;

        public NodesForEObjectProvider(EObject semanticObject, ICompositeNode node) {
            this.semanticObject = semanticObject;
            this.node = node;
            this.childrenByFeatureIDAndIndex = new Object[semanticObject.eClass().getFeatureCount()];
            this.collectNodesForFeatures();
        }

        protected SemanticNode add(String featureName, INode child, SemanticNode last) {
            EObject semanitcChild;
            EReference reference;
            if (featureName == null) {
                return last;
            }
            EClass eClass = this.semanticObject.eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
            if (feature == null) {
                return last;
            }
            SemanticNode sem = new SemanticNode(child);
            if (last != null) {
                last.follower = sem;
            }
            if (this.first == null) {
                this.first = sem;
            }
            int id = eClass.getFeatureID(feature);
            if (feature.isMany()) {
                ArrayList<SemanticNode> nodes = (ArrayList<SemanticNode>)this.childrenByFeatureIDAndIndex[id];
                if (nodes == null) {
                    this.childrenByFeatureIDAndIndex[id] = nodes = Lists.newArrayList();
                }
                nodes.add(sem);
            } else {
                this.childrenByFeatureIDAndIndex[id] = sem;
            }
            if (feature instanceof EReference && (reference = (EReference)feature).isContainment() && (semanitcChild = this.getSemanticChild(child)) != null) {
                if (this.childrenBySemanticChild == null) {
                    this.childrenBySemanticChild = Maps.newHashMap();
                }
                this.childrenBySemanticChild.put(semanitcChild, sem);
            }
            return sem;
        }

        protected void collectNodesForFeatures() {
            SemanticNode last = null;
            Iterator iterator = this.node.getAsTreeIterable().iterator();
            while (iterator.hasNext()) {
                Assignment assignment;
                INode child = (INode)iterator.next();
                EObject grammarElement = child.getGrammarElement();
                if (grammarElement == null) continue;
                if (grammarElement instanceof Action) {
                    Action action = (Action)grammarElement;
                    if (child.getSemanticElement() == this.semanticObject) {
                        child = (INode)iterator.next();
                        last = this.add(action.getFeature(), child, last);
                    } else {
                        INode firstChild = ((ICompositeNode)child).getFirstChild();
                        while (firstChild.getGrammarElement() instanceof Action) {
                            firstChild = ((ICompositeNode)firstChild).getFirstChild();
                        }
                        EObject firstChildGrammarElement = firstChild.getGrammarElement();
                        Assignment assignment2 = GrammarUtil.containingAssignment(firstChildGrammarElement);
                        if (assignment2 != null) {
                            last = this.add(assignment2.getFeature(), child, last);
                        }
                    }
                    iterator.prune();
                    continue;
                }
                if (child == this.node || (assignment = GrammarUtil.containingAssignment(grammarElement)) == null) continue;
                last = this.add(assignment.getFeature(), child, last);
                iterator.prune();
            }
        }

        @Override
        public SemanticNode getSemanticNodeForMultiValue(EStructuralFeature feat, int indexInFeat, int indexInNonTransient, Object val) {
            SemanticNode candiadate;
            if (this.childrenBySemanticChild != null && feat instanceof EReference && ((EReference)feat).isContainment() && (candiadate = this.childrenBySemanticChild.get(val)) != null) {
                return candiadate;
            }
            Object object = this.childrenByFeatureIDAndIndex[this.semanticObject.eClass().getFeatureID(feat)];
            if (feat.isMany() && object instanceof List) {
                List nodes = (List)object;
                if (indexInNonTransient >= 0 && indexInNonTransient < nodes.size()) {
                    return (SemanticNode)nodes.get(indexInNonTransient);
                }
            } else if (object instanceof SemanticNode) {
                return (SemanticNode)object;
            }
            return null;
        }

        @Override
        public SemanticNode getSemanticNodeForSingelValue(EStructuralFeature feature, Object value) {
            return this.getSemanticNodeForMultiValue(feature, 0, 0, value);
        }

        protected EObject getSemanticChild(INode node) {
            EObject root = node.getSemanticElement();
            if (root != null && root != this.semanticObject) {
                return root;
            }
            Iterator iterator = node.getAsTreeIterable().iterator();
            while (iterator.hasNext()) {
                EObject candidate = ((INode)iterator.next()).getSemanticElement();
                if (candidate == null || candidate == this.semanticObject) continue;
                return candidate;
            }
            return null;
        }

        @Override
        public INode getNodeForMultiValue(EStructuralFeature feature, int indexInFeature, int indexInNonTransient, Object value) {
            SemanticNode semantic = this.getSemanticNodeForMultiValue(feature, indexInFeature, indexInNonTransient, value);
            if (semantic == null) {
                return null;
            }
            return semantic.getNode();
        }

        @Override
        public INode getNodeForSingelValue(EStructuralFeature feature, Object value) {
            SemanticNode semantic = this.getSemanticNodeForSingelValue(feature, value);
            if (semantic == null) {
                return null;
            }
            return semantic.getNode();
        }

        @Override
        public ISemanticNodeProvider.ISemanticNode getFirstSemanticNode() {
            return this.first;
        }
    }

    public static class SemanticNode
    implements ISemanticNodeProvider.ISemanticNode {
        private final INode node;
        private final AbstractElement grammarElement;
        private SemanticNode follower = null;

        public SemanticNode(INode node) {
            this.node = node;
            EObject ge = node.getGrammarElement();
            this.grammarElement = ge instanceof CrossReference ? ((CrossReference)ge).getTerminal() : (ge instanceof AbstractElement ? (AbstractElement)ge : null);
        }

        @Override
        public INode getNode() {
            return this.node;
        }

        @Override
        public ISemanticNodeProvider.ISemanticNode getFollower() {
            return this.follower;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.grammarElement;
        }
    }
}

