/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.nodemodel.impl.SerializableNodeModel;
import org.eclipse.xtext.nodemodel.serialization.SerializationConversionContext;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;

public class ResourceStorageWritable {
    private final OutputStream out;
    private final boolean storeNodeModel;

    public ResourceStorageWritable(OutputStream out, boolean storeNodeModel) {
        this.out = out;
        this.storeNodeModel = storeNodeModel;
    }

    public void writeResource(StorageAwareResource resource) throws IOException {
        if (resource.isLoadedFromStorage()) {
            throw new IllegalStateException("cannot write resources loaded from storage. URI was " + String.valueOf(resource.getURI()));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zipOut = new ZipOutputStream(this.out);){
            this.writeEntries(resource, zipOut);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeEntries(StorageAwareResource resource, ZipOutputStream zipOut) throws IOException {
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(zipOut);
        zipOut.putNextEntry(new ZipEntry("emf-contents"));
        try {
            this.writeContents(resource, bufferedOutput);
        }
        finally {
            bufferedOutput.flush();
            zipOut.closeEntry();
        }
        zipOut.putNextEntry(new ZipEntry("resource-description"));
        try {
            this.writeResourceDescription(resource, bufferedOutput);
        }
        finally {
            bufferedOutput.flush();
            zipOut.closeEntry();
        }
        if (this.storeNodeModel) {
            zipOut.putNextEntry(new ZipEntry("node-model"));
            try {
                this.writeNodeModel(resource, bufferedOutput);
            }
            finally {
                bufferedOutput.flush();
                zipOut.closeEntry();
            }
        }
    }

    protected void writeContents(final StorageAwareResource storageAwareResource, OutputStream outputStream) throws IOException {
        BinaryResourceImpl.EObjectOutputStream out = new BinaryResourceImpl.EObjectOutputStream(outputStream, Collections.emptyMap()){

            @Override
            public void writeURI(URI uri, String fragment) throws IOException {
                URI fullURI = uri.appendFragment(fragment);
                URI portableURI = storageAwareResource.getPortableURIs().toPortableURI(storageAwareResource, fullURI);
                URI uriToWrite = portableURI == null ? fullURI : portableURI;
                super.writeURI(uriToWrite.trimFragment(), uriToWrite.fragment());
            }

            @Override
            public void saveEObject(InternalEObject internalEObject, BinaryResourceImpl.EObjectOutputStream.Check check) throws IOException {
                ResourceStorageWritable.this.beforeSaveEObject(internalEObject, this);
                super.saveEObject(internalEObject, check);
                ResourceStorageWritable.this.handleSaveEObject(internalEObject, this);
            }
        };
        try {
            out.saveResource(storageAwareResource);
        }
        finally {
            out.flush();
        }
    }

    protected void beforeSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream writable) throws IOException {
    }

    protected void handleSaveEObject(InternalEObject object, BinaryResourceImpl.EObjectOutputStream out) throws IOException {
    }

    protected void writeResourceDescription(StorageAwareResource resource, OutputStream outputStream) throws IOException {
        IResourceDescription description = resource.getResourceServiceProvider().getResourceDescriptionManager().getResourceDescription(resource);
        SerializableResourceDescription serializableDescription = SerializableResourceDescription.createCopy(description);
        this.convertExternalURIsToPortableURIs(serializableDescription, resource);
        ObjectOutputStream out = new ObjectOutputStream(outputStream);
        try {
            out.writeObject(serializableDescription);
        }
        finally {
            out.flush();
        }
    }

    protected void convertExternalURIsToPortableURIs(SerializableResourceDescription description, StorageAwareResource resource) {
        for (IReferenceDescription ref : description.getReferenceDescriptions()) {
            if (ref.getTargetEObjectUri().trimFragment().equals(resource.getURI())) continue;
            URI portableURI = resource.getPortableURIs().toPortableURI(resource, ref.getTargetEObjectUri());
            ((SerializableReferenceDescription)ref).setTargetEObjectUri(portableURI != null ? portableURI : ref.getTargetEObjectUri());
        }
    }

    protected void writeNodeModel(StorageAwareResource resource, OutputStream outputStream) throws IOException {
        if (!resource.customWriteNodeModel(outputStream)) {
            DataOutputStream out = new DataOutputStream(outputStream);
            new SerializableNodeModel(resource).writeObjectData(out, new SerializationConversionContext(resource));
            out.flush();
        }
    }
}

