/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;

public class PortableURIs {
    public static final String PORTABLE_SCHEME = "portable";
    @Inject
    private IGlobalScopeProvider globalScopeProvider;
    @Inject
    private EPackage.Registry packageRegistry;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public boolean isPortableURIFragment(String uriFragment) {
        return uriFragment.startsWith(PORTABLE_SCHEME);
    }

    public EObject resolve(StorageAwareResource resource, String portableFragment) {
        PortableFragmentDescription desc = this.fromFragmentString(portableFragment);
        EReference mock = EcoreFactory.eINSTANCE.createEReference();
        mock.setEType(desc.descriptionEClass);
        IScope scope = this.globalScopeProvider.getScope(resource, mock, Predicates.alwaysTrue());
        Optional<IEObjectDescription> description = Streams.stream(scope.getElements(desc.descriptionQualifiedName)).findFirst();
        return description.map(d -> {
            EObject container = EcoreUtil.resolve(d.getEObjectOrProxy(), resource);
            return this.getEObject(container, portableFragmentDescription.descriptionRelativeFragment);
        }).orElse(null);
    }

    public URI toPortableURI(StorageAwareResource sourceResource, URI targetURI) {
        EObject object = sourceResource.getResourceSet().getEObject(targetURI, false);
        if (object == null || object.eResource().getResourceSet() != null) {
            return this.toPortableURI(sourceResource, object);
        }
        return null;
    }

    public URI toPortableURI(StorageAwareResource sourceResource, EObject targetObject) {
        if (targetObject == null || targetObject.eIsProxy()) {
            return sourceResource.getURI().appendFragment("UNRESOLVABLE");
        }
        String portableFragment = this.getPortableURIFragment(targetObject);
        if (portableFragment != null) {
            return sourceResource.getURI().appendFragment(portableFragment);
        }
        return null;
    }

    protected String getPortableURIFragment(EObject obj) {
        IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(obj.eResource());
        IResourceDescription desc = descriptions.getResourceDescription(obj.eResource().getURI());
        if (desc == null) {
            return null;
        }
        return Streams.stream(desc.getExportedObjects()).filter(description -> {
            EObject possibleContainer = EcoreUtil.resolve(description.getEObjectOrProxy(), obj.eResource());
            return EcoreUtil.isAncestor(obj, possibleContainer);
        }).map(containerDesc -> {
            PortableFragmentDescription fragmentDescription = this.createPortableFragmentDescription((IEObjectDescription)containerDesc, obj);
            return this.toFragmentString(fragmentDescription);
        }).findFirst().orElse(null);
    }

    protected PortableFragmentDescription createPortableFragmentDescription(IEObjectDescription desc, EObject target) {
        EObject possibleContainer = EcoreUtil.resolve(desc.getEObjectOrProxy(), target);
        String fragmentToTarget = this.getFragment(target, possibleContainer);
        return new PortableFragmentDescription(desc.getEClass(), desc.getQualifiedName(), fragmentToTarget);
    }

    protected String toFragmentString(PortableFragmentDescription desc) {
        String eclassUriAsString = URI.encodeFragment(EcoreUtil.getURI(desc.descriptionEClass).toString(), false);
        List<String> segments = desc.descriptionQualifiedName.getSegments();
        String uriFragment = "portable#" + eclassUriAsString + "#" + URI.encodeFragment(Joiner.on(':').join(segments), false);
        if (desc.descriptionRelativeFragment != null) {
            uriFragment = uriFragment + "#" + URI.encodeFragment(desc.descriptionRelativeFragment, false);
        }
        return uriFragment;
    }

    protected PortableFragmentDescription fromFragmentString(String fragmentString) {
        Resource resource;
        Iterator<String> segments = Splitter.on("#").split(fragmentString).iterator();
        segments.next();
        URI eClassURI = URI.createURI(URI.decode(segments.next()));
        EPackage ePackage = this.packageRegistry.getEPackage(eClassURI.trimFragment().toString());
        EClass eClass = EcorePackage.Literals.EOBJECT;
        if (ePackage != null && (resource = ePackage.eResource()) != null) {
            eClass = (EClass)resource.getEObject(eClassURI.fragment());
        }
        QualifiedName qname = QualifiedName.create(Splitter.on(":").splitToList(URI.decode(segments.next())));
        String fragment = segments.hasNext() ? URI.decode(segments.next()) : null;
        return new PortableFragmentDescription(eClass, qname, fragment);
    }

    public String getFragment(EObject fromContainer, EObject toChild) throws IllegalArgumentException {
        return Strings.emptyToNull(EcoreUtil.getRelativeURIFragmentPath(fromContainer, toChild));
    }

    public EObject getEObject(EObject from, String toFragment) {
        if (toFragment == null) {
            return from;
        }
        return EcoreUtil.getEObject(from, toFragment);
    }

    public static class PortableFragmentDescription {
        private final EClass descriptionEClass;
        private final QualifiedName descriptionQualifiedName;
        private final String descriptionRelativeFragment;

        public PortableFragmentDescription(EClass descriptionEClass, QualifiedName descriptionQualifiedName, String descriptionRelativeFragment) {
            this.descriptionEClass = descriptionEClass;
            this.descriptionQualifiedName = descriptionQualifiedName;
            this.descriptionRelativeFragment = descriptionRelativeFragment;
        }

        public EClass getDescriptionEClass() {
            return this.descriptionEClass;
        }

        public QualifiedName getDescriptionQualifiedName() {
            return this.descriptionQualifiedName;
        }

        public String getDescriptionRelativeFragment() {
            return this.descriptionRelativeFragment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.descriptionEClass == null ? 0 : this.descriptionEClass.hashCode());
            result = 31 * result + (this.descriptionQualifiedName == null ? 0 : this.descriptionQualifiedName.hashCode());
            result = 31 * result + (this.descriptionRelativeFragment == null ? 0 : this.descriptionRelativeFragment.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortableFragmentDescription other = (PortableFragmentDescription)obj;
            if (this.descriptionEClass == null ? other.descriptionEClass != null : !this.descriptionEClass.equals(other.descriptionEClass)) {
                return false;
            }
            if (this.descriptionQualifiedName == null ? other.descriptionQualifiedName != null : !this.descriptionQualifiedName.equals(other.descriptionQualifiedName)) {
                return false;
            }
            return !(this.descriptionRelativeFragment == null ? other.descriptionRelativeFragment != null : !this.descriptionRelativeFragment.equals(other.descriptionRelativeFragment));
        }

        public String toString() {
            return "PortableFragmentDescription [descriptionEClass=" + String.valueOf(this.descriptionEClass) + ", descriptionQualifiedName=" + String.valueOf(this.descriptionQualifiedName) + ", descriptionRelativeFragment=" + this.descriptionRelativeFragment + "]";
        }
    }
}

