/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.generic;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.Strings;

public class XMLEncodingProvider
implements IEncodingProvider {
    private static final int BUFFER_SIZE = 512;
    private static final Logger LOG = Logger.getLogger(XMLEncodingProvider.class);

    @Override
    public String getEncoding(URI uri) {
        try {
            if (uri == null || !URIConverter.INSTANCE.exists(uri, Maps.newHashMap())) {
                return Charset.defaultCharset().name();
            }
            byte[] buffer = null;
            try (InputStream inputStream = URIConverter.INSTANCE.createInputStream(uri);){
                if (inputStream.available() == 0) {
                    buffer = new byte[]{};
                } else {
                    int bytesRead;
                    buffer = new byte[512];
                    int totalBytesRead = bytesRead = inputStream.read(buffer, 0, 512);
                    while (bytesRead != -1 && totalBytesRead < 512) {
                        bytesRead = inputStream.read(buffer, totalBytesRead, 512 - totalBytesRead);
                        if (bytesRead == -1) continue;
                        totalBytesRead += bytesRead;
                    }
                    if (totalBytesRead < 0) {
                        buffer = new byte[]{};
                    } else if (totalBytesRead < 512) {
                        byte[] smallerBuffer = new byte[totalBytesRead];
                        System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
                        buffer = smallerBuffer;
                    }
                }
            }
            String result = XMLHandler.getXMLEncoding(buffer);
            if (result == null) {
                return Charset.defaultCharset().name();
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("Error detecting encoding for " + Strings.notNull(uri), e);
            return Charset.defaultCharset().name();
        }
    }
}

