/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser;

import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.parser.IEncodingProvider;

@Singleton
public class EclipseProjectPropertiesEncodingProvider
extends IEncodingProvider.Runtime {
    private static final String PROPERTIES_DIRNAME = ".settings";
    private static final String PREFS_FILE_EXTENSION = "prefs";
    private static final String PROJECT_PROPERTIES = "<project>";
    private static final String ENCODING_PREFIX = "encoding/";

    @Override
    public String getEncoding(URI uri) {
        String result = this.getDefaultEncoding();
        if (result != null) {
            return result;
        }
        if (uri != null) {
            try {
                result = this.getFromProperties(uri);
                if (result != null) {
                    return result;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getEncoding(uri);
    }

    protected String getFromProperties(URI uri) throws IOException {
        if (!uri.isHierarchical()) {
            return null;
        }
        URI projectURI = uri;
        boolean projectFound = false;
        do {
            if (new File((projectURI = projectURI.trimSegments(1)).path(), ".project").exists()) {
                projectFound = true;
            }
            if (projectFound || projectURI.segmentCount() != 0) continue;
            return null;
        } while (!projectFound);
        Properties properties = this.loadProperties(projectURI);
        URI resourceUri = URI.createHierarchicalURI(Arrays.copyOfRange(uri.segments(), projectURI.segmentCount(), uri.segmentCount()), null, null);
        return this.getValue(properties, resourceUri, ENCODING_PREFIX);
    }

    protected Properties loadProperties(URI projectURI) throws IOException {
        Properties result;
        block12: {
            URI propertiesUri = projectURI.appendSegment(PROPERTIES_DIRNAME).appendSegment("org.eclipse.core.resources").appendFileExtension(PREFS_FILE_EXTENSION);
            FileInputStream input = null;
            result = new Properties();
            try {
                try {
                    input = new FileInputStream(propertiesUri.path());
                    result.load(input);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (input == null) break block12;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    protected String getValue(Properties properties, URI resourceUri, String prefix) {
        String value;
        URI path = resourceUri;
        do {
            if ((value = properties.getProperty(prefix + path.path())) == null) continue;
            return value;
        } while ((path = path.trimSegments(1)).segmentCount() > 0);
        value = properties.getProperty(prefix + PROJECT_PROPERTIES);
        if (value != null) {
            return value;
        }
        return null;
    }
}

