/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

public abstract class AbstractStatefulTraceRegion
extends AbstractTraceRegion {
    private final ITextRegionWithLineInformation myRegion;
    private final List<ILocationData> associatedLocations;
    private final boolean useForDebugging;

    protected AbstractStatefulTraceRegion(ITextRegionWithLineInformation myRegion, boolean useForDebugging, ILocationData associatedLocation, AbstractTraceRegion parent) {
        this(myRegion, useForDebugging, Lists.newArrayList(associatedLocation), parent);
    }

    protected AbstractStatefulTraceRegion(ITextRegionWithLineInformation myRegion, boolean useForDebugging, List<ILocationData> associatedLocations, AbstractTraceRegion parent) {
        super(parent);
        this.myRegion = myRegion;
        this.useForDebugging = useForDebugging;
        this.associatedLocations = associatedLocations;
        if (!this.isConsistentWithParent()) {
            throw new IllegalArgumentException("Produced region is inconsistent with parent, this: " + String.valueOf(this) + ", parent: " + String.valueOf(parent));
        }
    }

    @Override
    public int getMyLength() {
        return this.myRegion.getLength();
    }

    @Override
    public int getMyOffset() {
        return this.myRegion.getOffset();
    }

    @Override
    public int getMyEndLineNumber() {
        return this.myRegion.getEndLineNumber();
    }

    @Override
    public int getMyLineNumber() {
        return this.myRegion.getLineNumber();
    }

    @Override
    public ITextRegionWithLineInformation getMyRegion() {
        return this.myRegion;
    }

    @Override
    public boolean isUseForDebugging() {
        return this.useForDebugging;
    }

    @Override
    public List<ILocationData> getAssociatedLocations() {
        return Collections.unmodifiableList(this.associatedLocations);
    }

    protected List<ILocationData> getWritableAssociatedLocations() {
        return this.associatedLocations;
    }
}

