/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.formatting.INodeModelStreamer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.ITokenStreamExtension;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegion;

public class NodeModelStreamer
implements INodeModelStreamer {
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;
    @Inject
    protected TokenUtil tokenUtil;
    @Inject
    protected IValueConverterService valueConverter;

    @Override
    public ITextRegion feedTokenStream(ITokenStream out, ICompositeNode in, int offset, int length) throws IOException {
        List<INode> nodes = this.getLeafs(in, offset, offset + length);
        if (nodes.isEmpty()) {
            return new TextRegion(in.getOffset(), 0);
        }
        if (out instanceof ITokenStreamExtension) {
            ((ITokenStreamExtension)out).init(this.findRootRuleForRegion(nodes.get(0)));
        }
        boolean lastIsTokenOrComment = false;
        for (INode node : nodes) {
            boolean currentIsTokenOrComment;
            boolean bl = currentIsTokenOrComment = this.tokenUtil.isCommentNode(node) || this.tokenUtil.isToken(node);
            if (lastIsTokenOrComment && currentIsTokenOrComment) {
                this.writeHiddenEmpty(out);
            }
            lastIsTokenOrComment = currentIsTokenOrComment;
            if (node instanceof ILeafNode) {
                ILeafNode leaf = (ILeafNode)node;
                if (leaf.isHidden()) {
                    this.writeHidden(out, leaf);
                    continue;
                }
                this.writeSemantic(out, leaf);
                continue;
            }
            if (!(node instanceof ICompositeNode)) continue;
            this.writeSemantic(out, (ICompositeNode)node);
        }
        out.flush();
        int rStart = nodes.get(0).getOffset();
        int rLength = nodes.get(nodes.size() - 1).getEndOffset() - rStart;
        return new TextRegion(rStart, rLength);
    }

    protected ParserRule findRootRuleForRegion(INode node) {
        if (GrammarUtil.isEObjectRule(node.getGrammarElement())) {
            return (ParserRule)node.getGrammarElement();
        }
        if (node.hasDirectSemanticElement()) {
            return GrammarUtil.containingParserRule(node.getGrammarElement());
        }
        if (node.getParent() != null) {
            return this.findRootRuleForRegion(node.getParent());
        }
        return null;
    }

    protected List<INode> getLeafs(ICompositeNode root, int fromOffset, int toOffset) {
        INode node;
        ArrayList<INode> result = new ArrayList<INode>();
        Iterator iterator = root.getAsTreeIterable().iterator();
        if (fromOffset > 0) {
            while (iterator.hasNext()) {
                node = (INode)iterator.next();
                if (!this.tokenUtil.isToken(node) && !this.tokenUtil.isCommentNode(node)) continue;
                iterator.prune();
                if (node.getEndOffset() < fromOffset) continue;
                result.add(node);
                break;
            }
        }
        while (iterator.hasNext()) {
            node = (INode)iterator.next();
            if (!(node instanceof ILeafNode) && !this.tokenUtil.isToken(node)) continue;
            if (node.getOffset() > toOffset) break;
            if (node instanceof ILeafNode) {
                result.add(node);
                continue;
            }
            iterator.prune();
            Pair<List<ILeafNode>, List<ILeafNode>> surround = this.tokenUtil.getLeadingAndTrailingHiddenTokens(node);
            result.addAll((Collection<INode>)surround.getFirst());
            result.add(node);
            result.addAll((Collection<INode>)surround.getSecond());
        }
        int i = result.size() - 1;
        while (i >= 0) {
            if (!this.tokenUtil.isWhitespaceNode((INode)result.get(i))) break;
            result.remove(i);
            --i;
        }
        return result;
    }

    protected void writeHidden(ITokenStream out, ILeafNode node) throws IOException {
        out.writeHidden(node.getGrammarElement(), node.getText());
    }

    protected void writeHiddenEmpty(ITokenStream out) throws IOException {
        out.writeHidden(this.hiddenTokenHelper.getWhitespaceRuleFor(null, ""), "");
    }

    protected void writeSemantic(ITokenStream out, ICompositeNode node) throws IOException {
        AbstractRule rule = this.tokenUtil.getTokenRule(node);
        String text = this.tokenUtil.serializeNode(node);
        try {
            text = this.getFormattedDatatypeValue(node, rule, text);
        }
        catch (ValueConverterException valueConverterException) {
            // empty catch block
        }
        out.writeSemantic(node.getGrammarElement(), text);
    }

    protected String getFormattedDatatypeValue(ICompositeNode node, AbstractRule rule, String text) throws ValueConverterException {
        Object value = this.valueConverter.toValue(text, rule.getName(), node);
        text = this.valueConverter.toString(value, rule.getName());
        return text;
    }

    protected void writeSemantic(ITokenStream out, ILeafNode node) throws IOException {
        out.writeSemantic(node.getGrammarElement(), node.getText());
    }
}

