/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.impl.AbstractFormattingConfig;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;

public class FormattingConfig
extends AbstractFormattingConfig {
    protected int charsPerLine = 80;
    protected IIndentationInformation indentInfo;
    protected int wrappedLineIndentation = 0;
    @Deprecated
    protected TerminalRule whitespaceRule = null;

    public int getWrappedLineIndentation() {
        return this.wrappedLineIndentation;
    }

    public void setWrappedLineIndentation(int wrapIndent) {
        this.wrappedLineIndentation = wrapIndent;
    }

    @Deprecated
    public TerminalRule getWhitespaceRule() {
        return this.whitespaceRule;
    }

    @Deprecated
    public void setWhitespaceRule(TerminalRule rule) {
        this.whitespaceRule = rule;
    }

    @Deprecated
    public FormattingConfig(IGrammarAccess grammarAccess, IHiddenTokenHelper hiddenTokenHelper, IIndentationInformation indentInfo) {
        super(grammarAccess, hiddenTokenHelper);
        this.indentInfo = indentInfo;
    }

    public int getCharsPerLine() {
        return this.charsPerLine;
    }

    public String getIndentationSpace() {
        return this.indentInfo.getIndentString();
    }

    public void setAutoLinewrap(int charsPerLine) {
        this.charsPerLine = charsPerLine;
    }

    public void setIndentation(AbstractElement beginElement, AbstractElement endElement) {
        new IndentationLocatorStart(beginElement);
        new IndentationLocatorEnd(endElement);
    }

    public IndentationLocatorStart setIndentationIncrement() {
        return new IndentationLocatorStart();
    }

    public IndentationLocatorEnd setIndentationDecrement() {
        return new IndentationLocatorEnd();
    }

    public LinewrapLocator setLinewrap() {
        return new LinewrapLocator(1);
    }

    public LinewrapLocator setLinewrap(int lines) {
        return new LinewrapLocator(lines);
    }

    public LinewrapLocator setLinewrap(int minWraps, int defaultWraps, int maxWraps) {
        return new LinewrapLocator(minWraps, defaultWraps, maxWraps);
    }

    public NoLinewrapLocator setNoLinewrap() {
        return new NoLinewrapLocator(0);
    }

    public NoSpaceLocator setNoSpace() {
        return new NoSpaceLocator();
    }

    public SpaceLocator setSpace(String space) {
        return new SpaceLocator(space);
    }

    public class IndentationLocatorEnd
    extends AbstractFormattingConfig.ElementLocator {
        public IndentationLocatorEnd() {
        }

        public IndentationLocatorEnd(AbstractElement ele) {
            this.before(ele);
        }

        @Override
        public String toString() {
            return "<<";
        }
    }

    public class IndentationLocatorStart
    extends AbstractFormattingConfig.ElementLocator {
        public IndentationLocatorStart() {
        }

        public IndentationLocatorStart(AbstractElement ele) {
            this.after(ele);
        }

        @Override
        public String toString() {
            return ">>";
        }
    }

    public class LinewrapLocator
    extends AbstractFormattingConfig.ElementLocator {
        protected final int defaultWrap;
        protected final int maxWrap;
        protected final int minWrap;

        public LinewrapLocator(int wrap) {
            this.minWrap = wrap;
            this.defaultWrap = wrap;
            this.maxWrap = wrap;
        }

        public LinewrapLocator(int min2, int def, int max) {
            this.minWrap = min2;
            this.defaultWrap = def;
            this.maxWrap = max;
        }

        public int getDefaultWrap() {
            return this.defaultWrap;
        }

        public int getMaxWrap() {
            return this.maxWrap;
        }

        public int getMinWrap() {
            return this.minWrap;
        }

        @Override
        public String toString() {
            if (this.maxWrap == 0) {
                return "!\\n";
            }
            if (this.minWrap == this.defaultWrap && this.defaultWrap == this.maxWrap) {
                StringBuilder b = new StringBuilder();
                int i = 0;
                while (i < this.defaultWrap) {
                    b.append("\\n");
                    ++i;
                }
                return b.toString();
            }
            return "\\n[" + this.minWrap + "," + this.defaultWrap + "," + this.maxWrap + "]";
        }
    }

    public class NoLinewrapLocator
    extends LinewrapLocator {
        public NoLinewrapLocator(int wrap) {
            super(wrap);
        }
    }

    public class NoSpaceLocator
    extends SpaceLocator {
    }

    public class SpaceLocator
    extends AbstractFormattingConfig.ElementLocator {
        protected String space;

        public SpaceLocator() {
            this.space = "";
        }

        public SpaceLocator(String space) {
            this.space = space;
        }

        public String getSpace() {
            return this.space;
        }

        @Override
        public String toString() {
            if (this.space.length() == 0) {
                return "-";
            }
            return "'" + this.space + "'";
        }
    }
}

