/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.AltstepDef;
import de.ugoe.cs.swe.tTCN3.ControlStatement;
import de.ugoe.cs.swe.tTCN3.ControlStatementOrDefList;
import de.ugoe.cs.swe.tTCN3.ExtFunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionDefOrStatementList;
import de.ugoe.cs.swe.tTCN3.FunctionInstance;
import de.ugoe.cs.swe.tTCN3.FunctionRef;
import de.ugoe.cs.swe.tTCN3.FunctionStatement;
import de.ugoe.cs.swe.tTCN3.LogStatement;
import de.ugoe.cs.swe.tTCN3.PredefinedValue;
import de.ugoe.cs.swe.tTCN3.SetLocalVerdict;
import de.ugoe.cs.swe.tTCN3.SingleExpression;
import de.ugoe.cs.swe.tTCN3.TTCN3Reference;
import de.ugoe.cs.swe.tTCN3.TestcaseDef;
import de.ugoe.cs.swe.tTCN3.Value;
import de.ugoe.cs.swe.tTCN3.VerdictTypeValue;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class LogValidator
extends AbstractDeclarativeValidator {
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();

    @Check
    public void checkLogStatementFormat(FunctionDefOrStatementList functionStmList) {
        boolean _not;
        boolean _isCheckLogStatementFormat = this.activeProfile.isCheckLogStatementFormat();
        boolean bl = _not = !_isCheckLogStatementFormat;
        if (_not) {
            return;
        }
        TestcaseDef parentTC = TTCN3ScopeHelper.findDesiredParent(functionStmList, TestcaseDef.class);
        FunctionDef parentFunc = TTCN3ScopeHelper.findDesiredParent(functionStmList, FunctionDef.class);
        AltstepDef parentAlt = TTCN3ScopeHelper.findDesiredParent(functionStmList, AltstepDef.class);
        TTCN3Reference parent = null;
        if (parentTC != null) {
            parent = parentTC;
        } else if (parentFunc != null) {
            parent = parentFunc;
        } else if (parentAlt != null) {
            parent = parentAlt;
        }
        this.checkStatementList(functionStmList.eContents(), parent);
    }

    @Check
    public void checkLogStatementFormat(ControlStatementOrDefList ctrlStmList) {
        boolean _not;
        boolean _isCheckLogStatementFormat = this.activeProfile.isCheckLogStatementFormat();
        boolean bl = _not = !_isCheckLogStatementFormat;
        if (_not) {
            return;
        }
        this.checkStatementList(ctrlStmList.eContents(), null);
    }

    private void checkStatementList(EList<EObject> statements, TTCN3Reference parent) {
        boolean _notEquals;
        ICompositeNode node = null;
        Object statementToCheck = null;
        boolean other = false;
        LogStatement log = null;
        for (EObject s2 : statements) {
            boolean _notEquals2;
            if (s2 instanceof FunctionStatement) {
                log = this.findLogStatement((FunctionStatement)s2);
            } else if (s2 instanceof ControlStatement) {
                log = this.findLogStatement((ControlStatement)s2);
            }
            boolean bl = _notEquals2 = !Objects.equals(log, null);
            if (_notEquals2) {
                boolean _not;
                if (other) {
                    boolean _notEquals_1;
                    boolean bl2 = _notEquals_1 = !Objects.equals(statementToCheck, null);
                    if (_notEquals_1) {
                        this.checkLogStatementFormat((String)statementToCheck, node, parent);
                    }
                    other = false;
                    statementToCheck = null;
                }
                node = NodeModelUtils.getNode(log);
                boolean _equals = Objects.equals(statementToCheck, null);
                if (_equals) {
                    statementToCheck = "";
                }
                String _statementToCheck = statementToCheck;
                String _concatLogItems = this.concatLogItems(log);
                statementToCheck = _statementToCheck + _concatLogItems;
                boolean _isProcessSubsequentLogStatementsAsOne = this.activeProfile.isProcessSubsequentLogStatementsAsOne();
                boolean bl3 = _not = !_isProcessSubsequentLogStatementsAsOne;
                if (!_not) continue;
                this.checkLogStatementFormat((String)statementToCheck, node, parent);
                statementToCheck = null;
                continue;
            }
            other = true;
        }
        boolean bl = _notEquals = !Objects.equals(statementToCheck, null);
        if (_notEquals) {
            this.checkLogStatementFormat((String)statementToCheck, node, parent);
        }
    }

    private LogStatement findLogStatement(ControlStatement control) {
        if (!Objects.equals(control.getBasic(), null) && !Objects.equals(control.getBasic().getLog(), null)) {
            return control.getBasic().getLog();
        }
        return null;
    }

    private LogStatement findLogStatement(FunctionStatement stm) {
        if (!Objects.equals(stm.getBasic(), null) && !Objects.equals(stm.getBasic().getLog(), null)) {
            return stm.getBasic().getLog();
        }
        return null;
    }

    private String concatLogItems(LogStatement log) {
        Object logString = "";
        List<PredefinedValue> items = EcoreUtil2.getAllContentsOfType(log, PredefinedValue.class);
        for (PredefinedValue i : items) {
            boolean _notEquals;
            String _charString = i.getCharString();
            boolean bl = _notEquals = !Objects.equals(_charString, null);
            if (!_notEquals) continue;
            String _string = i.getCharString().toString();
            int _length = i.getCharString().toString().length();
            int _minus = _length - 1;
            CharSequence _subSequence = _string.subSequence(1, _minus);
            String subString = (String)_subSequence;
            String _logString = logString;
            String _replaceAll = subString.replaceAll("\"\"", "\"");
            logString = _logString + _replaceAll;
        }
        return logString;
    }

    private void checkLogStatementFormat(String log, INode node, TTCN3Reference parent) {
        boolean _not;
        boolean problemOccured = false;
        Object warning = "";
        Pattern logPattern = Pattern.compile(this.activeProfile.getLogFormatRegExp(), 32);
        Matcher logMatcher = logPattern.matcher(log);
        boolean _matches = logMatcher.matches();
        boolean bl = _not = !_matches;
        if (_not) {
            problemOccured = true;
            warning = "Invalid log format (\"" + log + "\")!";
        } else if (!logMatcher.group(1).equals("") && !Objects.equals(parent, null)) {
            boolean _not_1;
            String logItemContainerIdentifier = logMatcher.group(1);
            boolean _equals = parent.getName().equals(logItemContainerIdentifier);
            boolean bl2 = _not_1 = !_equals;
            if (_not_1) {
                problemOccured = true;
                String _name = parent.getName();
                String _plus = "Log statement contains invalid container identifier (\"" + logItemContainerIdentifier + "\", should be \"" + _name;
                String _plus_1 = _plus + "\")!";
                warning = _plus_1;
            }
        }
        if (problemOccured) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            this.warning((String)warning, null, LoggingInterface.MessageClass.LOGGING.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "5.1, checkLogFormat");
        }
    }

    @Check
    public void checkExternalFunctionInvocationPrecededByLogStatement(FunctionInstance function) {
        FunctionRef _ref;
        boolean _not;
        boolean _isCheckExternalFunctionInvocationPrecededByLogStatement = this.activeProfile.isCheckExternalFunctionInvocationPrecededByLogStatement();
        boolean bl = _not = !_isCheckExternalFunctionInvocationPrecededByLogStatement;
        if (_not) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode(function);
        boolean problemsOccured = false;
        String _name = function.getRef().getName();
        boolean _equals = Objects.equals(_name, null);
        if (_equals) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            ICompositeNode functionNode = NodeModelUtils.getNode(function);
            String _trim = functionNode.getText().trim();
            String _plus = "Function definition for \"" + _trim;
            String message = _plus + "\" cannot be resolved! It cannot be determined if it is an external function call!";
            String _string = LoggingInterface.MessageClass.LOGGING.toString();
            String _string_1 = Integer.valueOf(functionNode.getStartLine()).toString();
            String _string_2 = Integer.valueOf(functionNode.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_1 = "5.3, " + _methodName;
            this.info(message, null, _string, _string_1, _string_2, _plus_1, LoggingInterface.LogLevel.INFORMATION.toString());
        }
        if ((_ref = function.getRef()) instanceof ExtFunctionDef) {
            FunctionStatement parent = TTCN3ScopeHelper.findDesiredParent(function, FunctionStatement.class);
            FunctionDefOrStatementList parentList = TTCN3ScopeHelper.findDesiredParent(function, FunctionDefOrStatementList.class);
            boolean _equals_1 = Objects.equals(parent, null);
            if (_equals_1) {
                TTCN3StatisticsProvider.getInstance().incrementCountLog();
                String _name_1 = function.getRef().getName();
                String _plus_2 = "Call to external function \"" + _name_1;
                String message_1 = _plus_2 + "\" within a definition on the module level. It cannot be preceded by a log statement!";
                String _string_3 = LoggingInterface.MessageClass.LOGGING.toString();
                String _string_4 = Integer.valueOf(node.getStartLine()).toString();
                String _string_5 = Integer.valueOf(node.getEndLine()).toString();
                String _methodName_1 = MiscTools.getMethodName();
                String _plus_3 = "5.3, " + _methodName_1;
                this.info(message_1, null, _string_3, _string_4, _string_5, _plus_3, LoggingInterface.LogLevel.INFORMATION.toString());
            } else {
                EList<EObject> items = parentList.eContents();
                int idx = items.indexOf(parent);
                if (idx > 0 && idx < items.size()) {
                    EObject _get = (EObject)items.get(idx - 1);
                    LogStatement log = this.findLogStatement((FunctionStatement)_get);
                    boolean _equals_2 = Objects.equals(log, null);
                    if (_equals_2) {
                        problemsOccured = true;
                    }
                } else {
                    problemsOccured = true;
                }
            }
        }
        if (problemsOccured) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            String _name_2 = function.getRef().getName();
            String _plus_4 = "Call to external function \"" + _name_2;
            String message_2 = _plus_4 + "\" not preceded by a log statement!";
            String _string_6 = LoggingInterface.MessageClass.LOGGING.toString();
            String _string_7 = Integer.valueOf(node.getStartLine()).toString();
            String _string_8 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName_2 = MiscTools.getMethodName();
            String _plus_5 = "5.3, " + _methodName_2;
            this.warning(message_2, null, _string_6, _string_7, _string_8, _plus_5);
        }
    }

    @Check
    public void checkInconcOrFailSetverdictPrecededByLog(SetLocalVerdict verdict) {
        boolean _not;
        boolean _isCheckInconcOrFailSetVerdictPrecededByLog = this.activeProfile.isCheckInconcOrFailSetVerdictPrecededByLog();
        boolean bl = _not = !_isCheckInconcOrFailSetVerdictPrecededByLog;
        if (_not) {
            return;
        }
        FunctionStatement parent = TTCN3ScopeHelper.findDesiredParent(verdict, FunctionStatement.class);
        FunctionDefOrStatementList parentList = TTCN3ScopeHelper.findDesiredParent(verdict, FunctionDefOrStatementList.class);
        ICompositeNode node = NodeModelUtils.getNode(verdict);
        boolean problemsOccured = false;
        SingleExpression exp = verdict.getExpression();
        boolean isInconcOrFail = false;
        if (exp instanceof Value && !Objects.equals(((Value)exp).getPredef(), null) && !Objects.equals(((Value)exp).getPredef().getVerdictType(), null) && (Objects.equals(((Value)exp).getPredef().getVerdictType(), VerdictTypeValue.INCONC) || Objects.equals(((Value)exp).getPredef().getVerdictType(), VerdictTypeValue.FAIL))) {
            isInconcOrFail = true;
        }
        if (!isInconcOrFail) {
            return;
        }
        EList<EObject> items = parentList.eContents();
        int idx = items.indexOf(parent);
        if (idx > 0 && idx < items.size()) {
            EObject _get = (EObject)items.get(idx - 1);
            LogStatement log = this.findLogStatement((FunctionStatement)_get);
            boolean _equals = Objects.equals(log, null);
            if (_equals) {
                problemsOccured = true;
            }
        } else {
            problemsOccured = true;
        }
        if (problemsOccured) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            String _string = LoggingInterface.MessageClass.LOGGING.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "5.4, " + _methodName;
            this.warning("No log statement precedes a fail or inconc setverdict statement!!", null, _string, _string_1, _string_2, _plus);
        }
    }

    @Override
    public void register(EValidatorRegistrar registrar) {
    }
}

