/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import com.google.inject.Inject;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.ActionText;
import de.ugoe.cs.swe.tTCN3.ActualPar;
import de.ugoe.cs.swe.tTCN3.ActualParList;
import de.ugoe.cs.swe.tTCN3.AltConstruct;
import de.ugoe.cs.swe.tTCN3.AltstepDef;
import de.ugoe.cs.swe.tTCN3.AltstepInstance;
import de.ugoe.cs.swe.tTCN3.AltstepLocalDef;
import de.ugoe.cs.swe.tTCN3.Assignment;
import de.ugoe.cs.swe.tTCN3.BasicStatements;
import de.ugoe.cs.swe.tTCN3.BehaviourStatements;
import de.ugoe.cs.swe.tTCN3.BooleanExpression;
import de.ugoe.cs.swe.tTCN3.CallBodyStatement;
import de.ugoe.cs.swe.tTCN3.CallStatement;
import de.ugoe.cs.swe.tTCN3.CommunicationStatements;
import de.ugoe.cs.swe.tTCN3.ComponentDef;
import de.ugoe.cs.swe.tTCN3.ComponentElementDef;
import de.ugoe.cs.swe.tTCN3.ConditionalConstruct;
import de.ugoe.cs.swe.tTCN3.ConfigurationStatements;
import de.ugoe.cs.swe.tTCN3.ConstDef;
import de.ugoe.cs.swe.tTCN3.ControlStatement;
import de.ugoe.cs.swe.tTCN3.DoWhileStatement;
import de.ugoe.cs.swe.tTCN3.ElseClause;
import de.ugoe.cs.swe.tTCN3.ElseIfClause;
import de.ugoe.cs.swe.tTCN3.ElseStatement;
import de.ugoe.cs.swe.tTCN3.EnumDefNamed;
import de.ugoe.cs.swe.tTCN3.Enumeration;
import de.ugoe.cs.swe.tTCN3.Expression;
import de.ugoe.cs.swe.tTCN3.ExtFunctionDef;
import de.ugoe.cs.swe.tTCN3.ExtraMatchingAttributes;
import de.ugoe.cs.swe.tTCN3.Fdecvalue;
import de.ugoe.cs.swe.tTCN3.FdecvalueUnichar;
import de.ugoe.cs.swe.tTCN3.Fint2enum;
import de.ugoe.cs.swe.tTCN3.ForStatement;
import de.ugoe.cs.swe.tTCN3.FormalTemplatePar;
import de.ugoe.cs.swe.tTCN3.FormalValuePar;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionDefOrStatementList;
import de.ugoe.cs.swe.tTCN3.FunctionFormalPar;
import de.ugoe.cs.swe.tTCN3.FunctionFormalParList;
import de.ugoe.cs.swe.tTCN3.FunctionInstance;
import de.ugoe.cs.swe.tTCN3.FunctionLocalDef;
import de.ugoe.cs.swe.tTCN3.FunctionLocalInst;
import de.ugoe.cs.swe.tTCN3.FunctionRef;
import de.ugoe.cs.swe.tTCN3.FunctionStatement;
import de.ugoe.cs.swe.tTCN3.GotoStatement;
import de.ugoe.cs.swe.tTCN3.GuardOp;
import de.ugoe.cs.swe.tTCN3.GuardStatement;
import de.ugoe.cs.swe.tTCN3.InterleavedConstruct;
import de.ugoe.cs.swe.tTCN3.InterleavedGuardElement;
import de.ugoe.cs.swe.tTCN3.InterleavedGuardList;
import de.ugoe.cs.swe.tTCN3.LabelStatement;
import de.ugoe.cs.swe.tTCN3.LogItem;
import de.ugoe.cs.swe.tTCN3.LogStatement;
import de.ugoe.cs.swe.tTCN3.LoopConstruct;
import de.ugoe.cs.swe.tTCN3.ModuleControlBody;
import de.ugoe.cs.swe.tTCN3.ObjectReference;
import de.ugoe.cs.swe.tTCN3.OpCall;
import de.ugoe.cs.swe.tTCN3.PortCallBody;
import de.ugoe.cs.swe.tTCN3.PreDefFunction;
import de.ugoe.cs.swe.tTCN3.RecordDefNamed;
import de.ugoe.cs.swe.tTCN3.RecordOfDefNamed;
import de.ugoe.cs.swe.tTCN3.RefValueHead;
import de.ugoe.cs.swe.tTCN3.ReferencedType;
import de.ugoe.cs.swe.tTCN3.ReferencedValue;
import de.ugoe.cs.swe.tTCN3.SUTStatements;
import de.ugoe.cs.swe.tTCN3.SelectCase;
import de.ugoe.cs.swe.tTCN3.SelectCaseConstruct;
import de.ugoe.cs.swe.tTCN3.SetDefNamed;
import de.ugoe.cs.swe.tTCN3.SetLocalVerdict;
import de.ugoe.cs.swe.tTCN3.SetOfDefNamed;
import de.ugoe.cs.swe.tTCN3.SingleTempVarInstance;
import de.ugoe.cs.swe.tTCN3.SingleVarInstance;
import de.ugoe.cs.swe.tTCN3.StartTimerStatement;
import de.ugoe.cs.swe.tTCN3.StatementBlock;
import de.ugoe.cs.swe.tTCN3.TempVarList;
import de.ugoe.cs.swe.tTCN3.TemplateBody;
import de.ugoe.cs.swe.tTCN3.TemplateDef;
import de.ugoe.cs.swe.tTCN3.TemplateInstance;
import de.ugoe.cs.swe.tTCN3.TestcaseOperation;
import de.ugoe.cs.swe.tTCN3.TimerInstance;
import de.ugoe.cs.swe.tTCN3.TimerStatements;
import de.ugoe.cs.swe.tTCN3.Type;
import de.ugoe.cs.swe.tTCN3.TypeReference;
import de.ugoe.cs.swe.tTCN3.UnionDefNamed;
import de.ugoe.cs.swe.tTCN3.Value;
import de.ugoe.cs.swe.tTCN3.ValueRef;
import de.ugoe.cs.swe.tTCN3.VarInstance;
import de.ugoe.cs.swe.tTCN3.VarList;
import de.ugoe.cs.swe.tTCN3.WhileStatement;
import de.ugoe.cs.swe.tTCN3.WithStatement;
import de.ugoe.cs.swe.validation.DataFlowHelper;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DataFlowValidator
extends AbstractDeclarativeValidator {
    private boolean debug = false;
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    @Override
    public void register(EValidatorRegistrar registrar) {
    }

    @Check(value=CheckType.NORMAL)
    public void checkNoUninitialisedLocalDefinitions(StatementBlock block) {
        boolean _not;
        boolean _isCheckNoUninitialisedVariables = this.activeProfile.isCheckNoUninitialisedVariables();
        boolean bl = _not = !_isCheckNoUninitialisedVariables;
        if (_not) {
            return;
        }
        StatementBlock parentBlock = TTCN3ScopeHelper.findDesiredParent(block, StatementBlock.class);
        ModuleControlBody parentControl = TTCN3ScopeHelper.findDesiredParent(block, ModuleControlBody.class);
        AltstepDef parentAltstep = TTCN3ScopeHelper.findDesiredParent(block, AltstepDef.class);
        if (parentBlock == null && parentControl == null && parentAltstep == null) {
            DataFlowHelper dfh = new DataFlowHelper();
            if (this.debug) {
                try {
                    this.traverseChildren(block, dfh);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        InputOutput.println(EcoreUtil.getURI(block));
                        e.printStackTrace();
                    }
                    throw Exceptions.sneakyThrow(_t);
                }
            } else {
                this.traverseChildren(block, dfh);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkNoUninitialisedLocalDefinitions(ModuleControlBody control) {
        boolean _not;
        boolean _isCheckNoUninitialisedVariables = this.activeProfile.isCheckNoUninitialisedVariables();
        boolean bl = _not = !_isCheckNoUninitialisedVariables;
        if (_not) {
            return;
        }
        DataFlowHelper dfh = new DataFlowHelper();
        if (this.debug) {
            try {
                this.traverseChildren(control, dfh);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    InputOutput.println(EcoreUtil.getURI(control));
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow(_t);
            }
        } else {
            this.traverseChildren(control, dfh);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkNoUninitialisedLocalDefinitions(AltstepDef altstep) {
        boolean _not;
        boolean _isCheckNoUninitialisedVariables = this.activeProfile.isCheckNoUninitialisedVariables();
        boolean bl = _not = !_isCheckNoUninitialisedVariables;
        if (_not) {
            return;
        }
        DataFlowHelper dfh = new DataFlowHelper();
        if (this.debug) {
            try {
                this.traverseChildren(altstep, dfh);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    InputOutput.println(EcoreUtil.getURI(altstep));
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow(_t);
            }
        } else {
            this.traverseChildren(altstep, dfh);
        }
    }

    private void traverseChildren(AltstepDef altstep, DataFlowHelper dfh) {
        EList<AltstepLocalDef> _defs = altstep.getLocal().getDefs();
        for (AltstepLocalDef cse : _defs) {
            this.processAltstepLocalDef(cse, dfh);
        }
        EList<GuardStatement> _guardList = altstep.getGuard().getGuardList();
        for (GuardStatement b : _guardList) {
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals;
            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(b.getGuard(), ReferencedValue.class));
            DataFlowHelper bdfh = new DataFlowHelper(dfh);
            GuardOp _op = b.getOp();
            boolean bl = _tripleNotEquals = _op != null;
            if (_tripleNotEquals) {
                List<ReferencedValue> bValues = EcoreUtil2.eAllOfType(b.getOp(), ReferencedValue.class);
                Functions.Function1<ReferencedValue, Boolean> _function = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof Value;
                };
                this.checkVariableStatus(dfh, IterableExtensions.filter(bValues, _function));
                Functions.Function1<ReferencedValue, Boolean> _function_1 = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof ValueRef;
                };
                Iterable<ReferencedValue> _filter = IterableExtensions.filter(bValues, _function_1);
                for (ReferencedValue v : _filter) {
                    this.updateVariableStatus(bdfh, v);
                }
            } else {
                boolean _tripleNotEquals_1;
                AltstepInstance _step = b.getStep();
                boolean bl2 = _tripleNotEquals_1 = _step != null;
                if (_tripleNotEquals_1) {
                    this.processAltstepInstance(b.getStep(), dfh);
                }
            }
            StatementBlock _block = b.getBlock();
            boolean bl3 = _tripleNotEquals_2 = _block != null;
            if (!_tripleNotEquals_2) continue;
            this.traverseChildren(b.getBlock(), bdfh);
        }
        EList<ElseStatement> _elseList = altstep.getGuard().getElseList();
        for (ElseStatement b_1 : _elseList) {
            DataFlowHelper bdfh = new DataFlowHelper(dfh);
            this.traverseChildren(b_1.getBlock(), bdfh);
        }
    }

    private void traverseChildren(ModuleControlBody control, DataFlowHelper dfh) {
        Functions.Function1<INode, Boolean> _function = it -> it.hasDirectSemanticElement();
        Iterable<INode> _filter = IterableExtensions.filter(NodeModelUtils.getNode(control.getList()).getChildren(), _function);
        for (INode c : _filter) {
            EObject cse = c.getSemanticElement();
            if (cse instanceof FunctionLocalDef) continue;
            if (cse instanceof FunctionLocalInst) {
                this.processFunctionLocalInst((FunctionLocalInst)cse, dfh);
                continue;
            }
            if (!(cse instanceof ControlStatement)) continue;
            this.processControlStatement((ControlStatement)cse, dfh);
        }
    }

    private void traverseChildren(StatementBlock block, DataFlowHelper dfh) {
        Functions.Function1<INode, Boolean> _function = it -> it.hasDirectSemanticElement();
        Iterable<INode> _filter = IterableExtensions.filter(NodeModelUtils.getNode(block).getChildren(), _function);
        for (INode c : _filter) {
            EObject e;
            if (!(c instanceof CompositeNode) || !((e = ((CompositeNode)c).getSemanticElement()) instanceof FunctionDefOrStatementList)) continue;
            Functions.Function1<INode, Boolean> _function_1 = it -> it.hasDirectSemanticElement();
            Iterable<INode> _filter_1 = IterableExtensions.filter(((CompositeNode)c).getChildren(), _function_1);
            for (INode ce : _filter_1) {
                EObject cse = ce.getSemanticElement();
                if (cse instanceof FunctionLocalDef) continue;
                if (cse instanceof FunctionLocalInst) {
                    this.processFunctionLocalInst((FunctionLocalInst)cse, dfh);
                    continue;
                }
                if (cse instanceof WithStatement) {
                    this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(cse, ReferencedValue.class));
                    continue;
                }
                if (!(cse instanceof FunctionStatement)) continue;
                this.processFunctionStatement((FunctionStatement)cse, dfh);
            }
        }
    }

    protected void processControlStatement(ControlStatement cse, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        BasicStatements _basic = cse.getBasic();
        boolean bl = _tripleNotEquals = _basic != null;
        if (_tripleNotEquals) {
            this.processBasicStatement(cse.getBasic(), dfh);
        } else {
            boolean _tripleNotEquals_1;
            BehaviourStatements _behavior = cse.getBehavior();
            boolean bl2 = _tripleNotEquals_1 = _behavior != null;
            if (_tripleNotEquals_1) {
                this.processBehaviourStatement(cse.getBehavior(), dfh);
            } else {
                boolean _tripleNotEquals_2;
                TimerStatements _timer = cse.getTimer();
                boolean bl3 = _tripleNotEquals_2 = _timer != null;
                if (_tripleNotEquals_2) {
                    this.processTimerStatement(cse.getTimer(), dfh);
                } else {
                    boolean _tripleNotEquals_3;
                    SUTStatements _sut = cse.getSut();
                    boolean bl4 = _tripleNotEquals_3 = _sut != null;
                    if (_tripleNotEquals_3) {
                        EList<ActionText> _txt = cse.getSut().getTxt();
                        for (ActionText t2 : _txt) {
                            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(t2.getExpr(), ReferencedValue.class));
                        }
                    }
                }
            }
        }
    }

    protected void processFunctionLocalInst(FunctionLocalInst inst, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        VarInstance _variable = inst.getVariable();
        boolean bl = _tripleNotEquals = _variable != null;
        if (_tripleNotEquals) {
            this.processVarInstance(inst.getVariable(), dfh);
        } else {
            boolean _tripleNotEquals_1;
            TimerInstance _timer = inst.getTimer();
            boolean bl2 = _tripleNotEquals_1 = _timer != null;
            if (_tripleNotEquals_1) {
                EList<SingleVarInstance> _variables = inst.getTimer().getList().getVariables();
                for (SingleVarInstance target : _variables) {
                    this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(target, ReferencedValue.class));
                }
            }
        }
    }

    protected void processAltstepLocalDef(AltstepLocalDef inst, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        VarInstance _variable = inst.getVariable();
        boolean bl = _tripleNotEquals = _variable != null;
        if (_tripleNotEquals) {
            this.processVarInstance(inst.getVariable(), dfh);
        } else {
            boolean _tripleNotEquals_1;
            TimerInstance _timer = inst.getTimer();
            boolean bl2 = _tripleNotEquals_1 = _timer != null;
            if (_tripleNotEquals_1) {
                EList<SingleVarInstance> _variables = inst.getTimer().getList().getVariables();
                for (SingleVarInstance target : _variables) {
                    this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(target, ReferencedValue.class));
                }
            } else {
                boolean _tripleNotEquals_2;
                ConstDef _const = inst.getConst();
                boolean bl3 = _tripleNotEquals_2 = _const != null;
                if (_tripleNotEquals_2) {
                    this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(inst.getConst(), ReferencedValue.class));
                } else {
                    boolean _tripleNotEquals_3;
                    TemplateDef _template = inst.getTemplate();
                    boolean bl4 = _tripleNotEquals_3 = _template != null;
                    if (_tripleNotEquals_3) {
                        this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(inst.getTemplate(), ReferencedValue.class));
                    }
                }
            }
        }
    }

    protected void processVarInstance(VarInstance variable, DataFlowHelper dfh) {
        block4: {
            boolean _tripleNotEquals_1;
            block3: {
                boolean _tripleNotEquals;
                VarList _list = variable.getList();
                boolean bl = _tripleNotEquals = _list != null;
                if (!_tripleNotEquals) break block3;
                EList<SingleVarInstance> _variables = variable.getList().getVariables();
                for (SingleVarInstance target : _variables) {
                    boolean _tripleNotEquals_12;
                    Expression _expr = target.getExpr();
                    boolean bl2 = _tripleNotEquals_12 = _expr != null;
                    if (_tripleNotEquals_12) {
                        this.processExpression(target.getExpr(), dfh);
                    }
                    this.updateVariableStatus(dfh, target);
                }
                break block4;
            }
            TempVarList _tempList = variable.getTempList();
            boolean bl = _tripleNotEquals_1 = _tempList != null;
            if (!_tripleNotEquals_1) break block4;
            EList<SingleTempVarInstance> _variables_1 = variable.getTempList().getVariables();
            for (SingleTempVarInstance target_1 : _variables_1) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(target_1, ReferencedValue.class));
                this.updateVariableStatus(dfh, target_1);
            }
        }
    }

    protected void processFunctionStatement(FunctionStatement cse, DataFlowHelper dfh) {
        block4: {
            boolean _tripleNotEquals_7;
            block10: {
                boolean _tripleNotEquals_6;
                block9: {
                    boolean _tripleNotEquals_5;
                    block8: {
                        boolean _tripleNotEquals_4;
                        block7: {
                            boolean _tripleNotEquals_3;
                            block6: {
                                boolean _tripleNotEquals_2;
                                block5: {
                                    boolean _tripleNotEquals_1;
                                    block3: {
                                        boolean _tripleNotEquals;
                                        BasicStatements _basic = cse.getBasic();
                                        boolean bl = _tripleNotEquals = _basic != null;
                                        if (!_tripleNotEquals) break block3;
                                        this.processBasicStatement(cse.getBasic(), dfh);
                                        break block4;
                                    }
                                    BehaviourStatements _behavior = cse.getBehavior();
                                    boolean bl = _tripleNotEquals_1 = _behavior != null;
                                    if (!_tripleNotEquals_1) break block5;
                                    this.processBehaviourStatement(cse.getBehavior(), dfh);
                                    break block4;
                                }
                                CommunicationStatements _communication = cse.getCommunication();
                                boolean bl = _tripleNotEquals_2 = _communication != null;
                                if (!_tripleNotEquals_2) break block6;
                                this.processCommunicationStatement(cse.getCommunication(), dfh);
                                break block4;
                            }
                            ConfigurationStatements _configuration = cse.getConfiguration();
                            boolean bl = _tripleNotEquals_3 = _configuration != null;
                            if (!_tripleNotEquals_3) break block7;
                            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(cse.getConfiguration(), ReferencedValue.class));
                            break block4;
                        }
                        SUTStatements _sut = cse.getSut();
                        boolean bl = _tripleNotEquals_4 = _sut != null;
                        if (!_tripleNotEquals_4) break block8;
                        EList<ActionText> _txt = cse.getSut().getTxt();
                        for (ActionText t2 : _txt) {
                            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(t2.getExpr(), ReferencedValue.class));
                        }
                        break block4;
                    }
                    TestcaseOperation _test = cse.getTest();
                    boolean bl = _tripleNotEquals_5 = _test != null;
                    if (!_tripleNotEquals_5) break block9;
                    EList<LogItem> _log = cse.getTest().getLog();
                    for (LogItem t_1 : _log) {
                        this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(t_1, ReferencedValue.class));
                    }
                    break block4;
                }
                TimerStatements _timer = cse.getTimer();
                boolean bl = _tripleNotEquals_6 = _timer != null;
                if (!_tripleNotEquals_6) break block10;
                this.processTimerStatement(cse.getTimer(), dfh);
                break block4;
            }
            SetLocalVerdict _verdict = cse.getVerdict();
            boolean bl = _tripleNotEquals_7 = _verdict != null;
            if (!_tripleNotEquals_7) break block4;
            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(cse.getVerdict().getExpression(), ReferencedValue.class));
            EList<LogItem> _log_1 = cse.getVerdict().getLog();
            for (LogItem l : _log_1) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(l, ReferencedValue.class));
            }
        }
    }

    protected void processTimerStatement(TimerStatements timer, DataFlowHelper dfh) {
        ObjectReference target_1;
        boolean _tripleNotEquals;
        this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(timer, ReferencedValue.class));
        StartTimerStatement _start = timer.getStart();
        boolean bl = _tripleNotEquals = _start != null;
        if (_tripleNotEquals) {
            ObjectReference target = timer.getStart().getRef();
            if (target instanceof SingleVarInstance) {
                this.checkComponentVariableStatus(dfh, target, timer);
            }
        } else if (timer.getStop() != null && timer.getStop().getRef() != null && timer.getStop().getRef().getRef() != null && (target_1 = timer.getStop().getRef().getRef()) instanceof SingleVarInstance) {
            this.checkComponentVariableStatus(dfh, target_1, timer);
        }
    }

    protected void processCommunicationStatement(CommunicationStatements communication, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        CallStatement _call = communication.getCall();
        boolean bl = _tripleNotEquals = _call != null;
        if (_tripleNotEquals) {
            this.processCallStatement(communication.getCall(), dfh);
        } else {
            List<ReferencedValue> values = EcoreUtil2.eAllOfType(communication, ReferencedValue.class);
            Functions.Function1<ReferencedValue, Boolean> _function = it -> {
                EObject _eContainer = it.eContainer();
                return _eContainer instanceof Value;
            };
            this.checkVariableStatus(dfh, IterableExtensions.filter(values, _function));
            Functions.Function1<ReferencedValue, Boolean> _function_1 = it -> {
                EObject _eContainer = it.eContainer();
                return _eContainer instanceof ValueRef;
            };
            Iterable<ReferencedValue> _filter = IterableExtensions.filter(values, _function_1);
            for (ReferencedValue v : _filter) {
                this.updateVariableStatus(dfh, v);
            }
        }
    }

    protected void processCallStatement(CallStatement call, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        List<ReferencedValue> oValues = EcoreUtil2.eAllOfType(call.getOp(), ReferencedValue.class);
        this.checkVariableStatus(dfh, oValues);
        PortCallBody _body = call.getBody();
        boolean bl = _tripleNotEquals = _body != null;
        if (_tripleNotEquals) {
            ArrayList bdfhs = CollectionLiterals.newArrayList();
            HashSet<EObject> bdfhkeys = CollectionLiterals.newHashSet();
            EList<CallBodyStatement> _body_1 = call.getBody().getCallBody().getBody();
            for (CallBodyStatement b : _body_1) {
                DataFlowHelper bdfh = new DataFlowHelper(dfh);
                List<ReferencedValue> bValues = EcoreUtil2.eAllOfType(b.getCall(), ReferencedValue.class);
                Functions.Function1<ReferencedValue, Boolean> _function = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof Value;
                };
                this.checkVariableStatus(dfh, IterableExtensions.filter(bValues, _function));
                Functions.Function1<ReferencedValue, Boolean> _function_1 = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof ValueRef;
                };
                Iterable<ReferencedValue> _filter = IterableExtensions.filter(bValues, _function_1);
                for (ReferencedValue v : _filter) {
                    this.updateVariableStatus(bdfh, v);
                }
                this.traverseChildren(b.getBlock(), bdfh);
                bdfhs.add(bdfh);
                bdfhkeys.addAll(bdfh.getStates().keySet());
            }
            for (EObject k : bdfhkeys) {
                if (dfh.getState(k) != DataFlowHelper.STATUS.DECLARED || !IterableExtensions.forall(bdfhs, it -> it.getStates().containsKey(k))) continue;
                dfh.setState(k, ((DataFlowHelper)bdfhs.get(0)).getStates().get(k));
            }
        }
    }

    protected void processBehaviourStatement(BehaviourStatements behavior, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        AltConstruct _alt = behavior.getAlt();
        boolean bl = _tripleNotEquals = _alt != null;
        if (_tripleNotEquals) {
            this.processAltStatement(behavior.getAlt(), dfh);
        } else {
            boolean _tripleNotEquals_1;
            FunctionInstance _function = behavior.getFunction();
            boolean bl2 = _tripleNotEquals_1 = _function != null;
            if (_tripleNotEquals_1) {
                this.processFunctionInstance(behavior.getFunction(), dfh);
            } else {
                boolean _tripleNotEquals_2;
                InterleavedConstruct _interleaved = behavior.getInterleaved();
                boolean bl3 = _tripleNotEquals_2 = _interleaved != null;
                if (_tripleNotEquals_2) {
                    this.processInterleavedStatement(behavior.getInterleaved(), dfh);
                } else {
                    boolean _tripleNotEquals_3;
                    GotoStatement _goto = behavior.getGoto();
                    boolean bl4 = _tripleNotEquals_3 = _goto != null;
                    if (!_tripleNotEquals_3) {
                        boolean _tripleNotEquals_4;
                        LabelStatement _label = behavior.getLabel();
                        boolean bl5 = _tripleNotEquals_4 = _label != null;
                        if (!_tripleNotEquals_4) {
                            boolean _tripleNotEquals_5;
                            AltstepInstance _altstep = behavior.getAltstep();
                            boolean bl6 = _tripleNotEquals_5 = _altstep != null;
                            if (_tripleNotEquals_5) {
                                this.processAltstepInstance(behavior.getAltstep(), dfh);
                            } else {
                                List<ReferencedValue> values = EcoreUtil2.eAllOfType(behavior, ReferencedValue.class);
                                this.checkVariableStatus(dfh, values);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void processAltstepInstance(AltstepInstance altstep, DataFlowHelper dfh) {
        if (altstep.getList() != null && altstep.getRef().getParams() != null) {
            this.processParameters(altstep.getList().getActual(), altstep.getRef().getParams().getParams(), dfh);
        }
    }

    protected void processFunctionInstance(FunctionInstance function, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        ActualParList _params = function.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            FunctionRef r = function.getRef();
            if (r instanceof FunctionDef) {
                boolean _tripleNotEquals_1;
                FunctionFormalParList _parameterList = ((FunctionDef)r).getParameterList();
                boolean bl2 = _tripleNotEquals_1 = _parameterList != null;
                if (_tripleNotEquals_1) {
                    this.processParameters(function.getParams().getActual(), ((FunctionDef)r).getParameterList().getParams(), dfh);
                }
            } else if (r instanceof ExtFunctionDef) {
                boolean _tripleNotEquals_2;
                FunctionFormalParList _list = ((ExtFunctionDef)r).getList();
                boolean bl3 = _tripleNotEquals_2 = _list != null;
                if (_tripleNotEquals_2) {
                    this.processParameters(function.getParams().getActual(), ((ExtFunctionDef)r).getList().getParams(), dfh);
                }
            } else if (r instanceof AltstepDef) {
                boolean _tripleNotEquals_3;
                FunctionFormalParList _params_1 = ((AltstepDef)r).getParams();
                boolean bl4 = _tripleNotEquals_3 = _params_1 != null;
                if (_tripleNotEquals_3) {
                    this.processParameters(function.getParams().getActual(), ((AltstepDef)r).getParams().getParams(), dfh);
                }
            } else {
                List<ReferencedValue> values = EcoreUtil2.eAllOfType(function, ReferencedValue.class);
                this.checkVariableStatus(dfh, values);
            }
        } else {
            List<ReferencedValue> values_1 = EcoreUtil2.eAllOfType(function, ReferencedValue.class);
            this.checkVariableStatus(dfh, values_1);
        }
    }

    protected void processParameters(EList<ActualPar> actualParameters, EList<FunctionFormalPar> formalParameters, DataFlowHelper dfh) {
        int i = 0;
        for (ActualPar p : actualParameters) {
            boolean _tripleNotEquals;
            TemplateInstance _template = p.getTemplate();
            boolean bl = _tripleNotEquals = _template != null;
            if (_tripleNotEquals) {
                boolean _tripleNotEquals_1;
                boolean _lessEqualsThan;
                int _size = formalParameters.size();
                boolean bl2 = _lessEqualsThan = _size <= i;
                if (_lessEqualsThan) {
                    return;
                }
                FunctionFormalPar fp = (FunctionFormalPar)formalParameters.get(i);
                FormalValuePar _value = fp.getValue();
                boolean bl3 = _tripleNotEquals_1 = _value != null;
                if (_tripleNotEquals_1) {
                    boolean _equals;
                    boolean _tripleEquals;
                    FormalValuePar fpp = fp.getValue();
                    String _inOut = fpp.getInOut();
                    boolean bl4 = _tripleEquals = _inOut == null;
                    if (_tripleEquals) {
                        fpp.setInOut("in");
                    }
                    if (_equals = fpp.getInOut().equals("out")) {
                        this.updateVariableStatus(dfh, EcoreUtil2.eAllOfType(p, ReferencedValue.class).get(0));
                    } else {
                        boolean _equals_1 = fpp.getInOut().equals("in");
                        if (_equals_1) {
                            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(p, ReferencedValue.class));
                        }
                    }
                } else {
                    boolean _tripleNotEquals_2;
                    FormalTemplatePar _template_1 = fp.getTemplate();
                    boolean bl5 = _tripleNotEquals_2 = _template_1 != null;
                    if (_tripleNotEquals_2) {
                        boolean _equals_2;
                        boolean _tripleEquals_1;
                        FormalTemplatePar fpp_1 = fp.getTemplate();
                        String _inOut_1 = fpp_1.getInOut();
                        boolean bl6 = _tripleEquals_1 = _inOut_1 == null;
                        if (_tripleEquals_1) {
                            fpp_1.setInOut("in");
                        }
                        if (_equals_2 = fpp_1.getInOut().equals("out")) {
                            this.updateVariableStatus(dfh, EcoreUtil2.eAllOfType(p, ReferencedValue.class).get(0));
                        } else {
                            boolean _equals_3 = fpp_1.getInOut().equals("in");
                            if (_equals_3) {
                                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(p, ReferencedValue.class));
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void processInterleavedStatement(InterleavedConstruct interleaved, DataFlowHelper dfh) {
        EObject igl = (EObject)interleaved.eContents().get(0);
        if (igl instanceof InterleavedGuardList) {
            ArrayList bdfhs = CollectionLiterals.newArrayList();
            HashSet<EObject> bdfhkeys = CollectionLiterals.newHashSet();
            EList<InterleavedGuardElement> _elements = ((InterleavedGuardList)igl).getElements();
            for (InterleavedGuardElement b : _elements) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(b.getGuard(), ReferencedValue.class));
                DataFlowHelper bdfh = new DataFlowHelper(dfh);
                List<ReferencedValue> bValues = EcoreUtil2.eAllOfType(b.getGuard().getGuardOp(), ReferencedValue.class);
                Functions.Function1<ReferencedValue, Boolean> _function = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof Value;
                };
                this.checkVariableStatus(dfh, IterableExtensions.filter(bValues, _function));
                Functions.Function1<ReferencedValue, Boolean> _function_1 = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof ValueRef;
                };
                Iterable<ReferencedValue> _filter = IterableExtensions.filter(bValues, _function_1);
                for (ReferencedValue v : _filter) {
                    this.updateVariableStatus(bdfh, v);
                }
                this.traverseChildren(b.getStatement(), bdfh);
                bdfhs.add(bdfh);
                bdfhkeys.addAll(bdfh.getStates().keySet());
            }
            for (EObject k : bdfhkeys) {
                if (dfh.getState(k) != DataFlowHelper.STATUS.DECLARED || !IterableExtensions.forall(bdfhs, it -> it.getStates().containsKey(k))) continue;
                dfh.setState(k, ((DataFlowHelper)bdfhs.get(0)).getStates().get(k));
            }
        }
    }

    protected void processAltStatement(AltConstruct alt, DataFlowHelper dfh) {
        ArrayList bdfhs = CollectionLiterals.newArrayList();
        HashSet<EObject> bdfhkeys = CollectionLiterals.newHashSet();
        EList<GuardStatement> _guardList = alt.getAgList().getGuardList();
        for (GuardStatement b : _guardList) {
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals;
            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(b.getGuard(), ReferencedValue.class));
            DataFlowHelper bdfh = new DataFlowHelper(dfh);
            GuardOp _op = b.getOp();
            boolean bl = _tripleNotEquals = _op != null;
            if (_tripleNotEquals) {
                List<ReferencedValue> bValues = EcoreUtil2.eAllOfType(b.getOp(), ReferencedValue.class);
                Functions.Function1<ReferencedValue, Boolean> _function = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof Value;
                };
                this.checkVariableStatus(dfh, IterableExtensions.filter(bValues, _function));
                Functions.Function1<ReferencedValue, Boolean> _function_1 = it -> {
                    EObject _eContainer = it.eContainer();
                    return _eContainer instanceof ValueRef;
                };
                Iterable<ReferencedValue> _filter = IterableExtensions.filter(bValues, _function_1);
                for (ReferencedValue v : _filter) {
                    this.updateVariableStatus(bdfh, v);
                }
            } else {
                boolean _tripleNotEquals_1;
                AltstepInstance _step = b.getStep();
                boolean bl2 = _tripleNotEquals_1 = _step != null;
                if (_tripleNotEquals_1) {
                    this.processAltstepInstance(b.getStep(), dfh);
                }
            }
            StatementBlock _block = b.getBlock();
            boolean bl3 = _tripleNotEquals_2 = _block != null;
            if (_tripleNotEquals_2) {
                this.traverseChildren(b.getBlock(), bdfh);
            }
            bdfhs.add(bdfh);
            bdfhkeys.addAll(bdfh.getStates().keySet());
        }
        EList<ElseStatement> _elseList = alt.getAgList().getElseList();
        for (ElseStatement b_1 : _elseList) {
            DataFlowHelper bdfh = new DataFlowHelper(dfh);
            this.traverseChildren(b_1.getBlock(), bdfh);
            bdfhs.add(bdfh);
            bdfhkeys.addAll(bdfh.getStates().keySet());
        }
        for (EObject k : bdfhkeys) {
            if (dfh.getState(k) != DataFlowHelper.STATUS.DECLARED || !IterableExtensions.forall(bdfhs, it -> it.getStates().containsKey(k))) continue;
            dfh.setState(k, ((DataFlowHelper)bdfhs.get(0)).getStates().get(k));
        }
    }

    protected void processOpCall(OpCall opCall, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        PreDefFunction _preFunction = opCall.getPreFunction();
        boolean bl = _tripleNotEquals = _preFunction != null;
        if (_tripleNotEquals) {
            PreDefFunction pf = opCall.getPreFunction();
            if (pf instanceof Fdecvalue) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(((Fdecvalue)pf).getE1(), ReferencedValue.class));
                EObject outPar = (EObject)((Fdecvalue)pf).getE2().eContents().get(0);
                if (outPar instanceof ReferencedValue) {
                    this.updateVariableStatus(dfh, (ReferencedValue)outPar);
                }
            } else if (pf instanceof Fint2enum) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(((Fint2enum)pf).getE1(), ReferencedValue.class));
                EObject outPar_1 = (EObject)((Fint2enum)pf).getE2().eContents().get(0);
                if (outPar_1 instanceof ReferencedValue) {
                    this.updateVariableStatus(dfh, (ReferencedValue)outPar_1);
                }
            } else if (pf instanceof FdecvalueUnichar) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(((FdecvalueUnichar)pf).getE1(), ReferencedValue.class));
                EObject outPar_2 = (EObject)((FdecvalueUnichar)pf).getE2().eContents().get(0);
                if (outPar_2 instanceof ReferencedValue) {
                    this.updateVariableStatus(dfh, (ReferencedValue)outPar_2);
                }
            } else {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(pf, ReferencedValue.class));
            }
        } else {
            boolean _tripleNotEquals_1;
            FunctionInstance _function = opCall.getFunction();
            boolean bl2 = _tripleNotEquals_1 = _function != null;
            if (_tripleNotEquals_1) {
                this.processFunctionInstance(opCall.getFunction(), dfh);
            } else {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(opCall, ReferencedValue.class));
            }
        }
    }

    protected void processExpression(Expression expression, DataFlowHelper dfh) {
        if (expression instanceof OpCall) {
            this.processOpCall((OpCall)expression, dfh);
        } else {
            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(expression, ReferencedValue.class));
        }
    }

    protected void processBody(TemplateBody body, DataFlowHelper dfh) {
        if (body.getSimple() != null && body.getSimple().getExpr() != null) {
            boolean _tripleNotEquals;
            this.processExpression(body.getSimple().getExpr(), dfh);
            ExtraMatchingAttributes _extra = body.getExtra();
            boolean bl = _tripleNotEquals = _extra != null;
            if (_tripleNotEquals) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(body.getExtra(), ReferencedValue.class));
            }
        } else {
            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(body, ReferencedValue.class));
        }
    }

    protected void processBasicStatement(BasicStatements basic, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        Assignment _assign = basic.getAssign();
        boolean bl = _tripleNotEquals = _assign != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            TemplateBody _body = basic.getAssign().getBody();
            boolean bl2 = _tripleNotEquals_1 = _body != null;
            if (_tripleNotEquals_1) {
                this.processBody(basic.getAssign().getBody(), dfh);
            }
            this.updateVariableStatus(dfh, basic.getAssign().getRef().getRef());
        } else {
            boolean _tripleNotEquals_2;
            StatementBlock _block = basic.getBlock();
            boolean bl3 = _tripleNotEquals_2 = _block != null;
            if (_tripleNotEquals_2) {
                this.processBlock(basic.getBlock(), dfh);
            } else {
                boolean _tripleNotEquals_3;
                ConditionalConstruct _conditional = basic.getConditional();
                boolean bl4 = _tripleNotEquals_3 = _conditional != null;
                if (_tripleNotEquals_3) {
                    this.processConditionalStatement(basic.getConditional(), dfh);
                } else {
                    boolean _tripleNotEquals_4;
                    LogStatement _log = basic.getLog();
                    boolean bl5 = _tripleNotEquals_4 = _log != null;
                    if (_tripleNotEquals_4) {
                        this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(basic.getLog(), ReferencedValue.class));
                    } else {
                        boolean _tripleNotEquals_5;
                        LoopConstruct _loop = basic.getLoop();
                        boolean bl6 = _tripleNotEquals_5 = _loop != null;
                        if (_tripleNotEquals_5) {
                            this.processLoopStatement(basic.getLoop(), dfh);
                        } else {
                            boolean _tripleNotEquals_6;
                            SelectCaseConstruct _select = basic.getSelect();
                            boolean bl7 = _tripleNotEquals_6 = _select != null;
                            if (_tripleNotEquals_6) {
                                this.processSelectStatement(basic.getSelect(), dfh);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void processBlock(StatementBlock block, DataFlowHelper dfh) {
        DataFlowHelper bdfh = new DataFlowHelper(dfh);
        this.traverseChildren(block, bdfh);
        Set<EObject> _keySet = bdfh.getStates().keySet();
        for (EObject k : _keySet) {
            boolean _tripleEquals;
            DataFlowHelper.STATUS _state = dfh.getState(k);
            boolean bl = _tripleEquals = _state == DataFlowHelper.STATUS.DECLARED;
            if (!_tripleEquals) continue;
            dfh.setState(k, bdfh.getStates().get(k));
        }
    }

    protected void processConditionalStatementExpression(BooleanExpression expression, DataFlowHelper dfh) {
        Functions.Function1<ReferencedValue, Boolean> _function = it -> {
            OpCall _containerOfType = EcoreUtil2.getContainerOfType(it, OpCall.class);
            return _containerOfType == null;
        };
        this.checkVariableStatus(dfh, IterableExtensions.filter(EcoreUtil2.eAllOfType(expression, ReferencedValue.class), _function));
        List<OpCall> _eAllOfType = EcoreUtil2.eAllOfType(expression, OpCall.class);
        for (OpCall e : _eAllOfType) {
            this.processOpCall(e, dfh);
        }
    }

    protected void processConditionalStatement(ConditionalConstruct conditional, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        this.processConditionalStatementExpression(conditional.getExpression(), dfh);
        DataFlowHelper sdfh = new DataFlowHelper(dfh);
        this.traverseChildren(conditional.getStatement(), sdfh);
        ArrayList eidfhs = CollectionLiterals.newArrayList();
        EList<ElseIfClause> _elseifs = conditional.getElseifs();
        for (ElseIfClause elseIf : _elseifs) {
            this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(elseIf.getExpression(), ReferencedValue.class));
            DataFlowHelper eidfh = new DataFlowHelper(dfh);
            this.traverseChildren(conditional.getStatement(), eidfh);
            eidfhs.add(eidfh);
        }
        ElseClause _else = conditional.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            DataFlowHelper edfh = new DataFlowHelper(dfh);
            this.traverseChildren(conditional.getElse().getStatement(), edfh);
            Set<EObject> _keySet = edfh.getStates().keySet();
            for (EObject k : _keySet) {
                if (!sdfh.getStates().containsKey(k) || dfh.getState(k) != DataFlowHelper.STATUS.DECLARED || !IterableExtensions.forall(eidfhs, it -> it.getStates().containsKey(k))) continue;
                dfh.setState(k, edfh.getStates().get(k));
            }
        }
    }

    protected void processSelectStatement(SelectCaseConstruct select, DataFlowHelper dfh) {
        this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(select.getExpression(), ReferencedValue.class));
        ArrayList bdfhs = CollectionLiterals.newArrayList();
        HashSet<EObject> bdfhkeys = CollectionLiterals.newHashSet();
        EList<SelectCase> _cases = select.getBody().getCases();
        for (SelectCase sc : _cases) {
            EList<TemplateInstance> _template = sc.getTemplate();
            for (TemplateInstance t2 : _template) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(t2, ReferencedValue.class));
            }
            DataFlowHelper bdfh = new DataFlowHelper(dfh);
            this.traverseChildren(sc.getStatement(), bdfh);
            bdfhs.add(bdfh);
            bdfhkeys.addAll(bdfh.getStates().keySet());
        }
        for (EObject k : bdfhkeys) {
            if (dfh.getState(k) != DataFlowHelper.STATUS.DECLARED || !IterableExtensions.forall(bdfhs, it -> it.getStates().containsKey(k))) continue;
            dfh.setState(k, ((DataFlowHelper)bdfhs.get(0)).getStates().get(k));
        }
    }

    protected void processLoopStatement(LoopConstruct loop, DataFlowHelper dfh) {
        boolean _tripleNotEquals;
        ForStatement _forStm = loop.getForStm();
        boolean bl = _tripleNotEquals = _forStm != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            DataFlowHelper fdfh = new DataFlowHelper(dfh);
            Assignment _assignment = loop.getForStm().getInit().getAssignment();
            boolean bl2 = _tripleNotEquals_1 = _assignment != null;
            if (_tripleNotEquals_1) {
                this.checkVariableStatus(fdfh, EcoreUtil2.eAllOfType(loop.getForStm().getInit().getAssignment(), ReferencedValue.class));
                this.updateVariableStatus(dfh, loop.getForStm().getInit().getAssignment().getRef().getRef());
            } else {
                boolean _tripleNotEquals_2;
                VarInstance _variable = loop.getForStm().getInit().getVariable();
                boolean bl3 = _tripleNotEquals_2 = _variable != null;
                if (_tripleNotEquals_2) {
                    EList<SingleVarInstance> _variables = loop.getForStm().getInit().getVariable().getList().getVariables();
                    for (SingleVarInstance target : _variables) {
                        this.checkVariableStatus(fdfh, EcoreUtil2.eAllOfType(target, ReferencedValue.class));
                        this.updateVariableStatus(fdfh, target);
                    }
                }
            }
            this.checkVariableStatus(fdfh, EcoreUtil2.eAllOfType(loop.getForStm().getExpression(), ReferencedValue.class));
            this.checkVariableStatus(fdfh, EcoreUtil2.eAllOfType(loop.getForStm().getAssign(), ReferencedValue.class));
            this.updateVariableStatus(fdfh, loop.getForStm().getAssign().getRef().getRef());
            this.traverseChildren(loop.getForStm().getStatement(), fdfh);
        } else {
            boolean _tripleNotEquals_3;
            WhileStatement _whileStm = loop.getWhileStm();
            boolean bl4 = _tripleNotEquals_3 = _whileStm != null;
            if (_tripleNotEquals_3) {
                this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(loop.getWhileStm().getExpression(), ReferencedValue.class));
                StatementBlock _statement = loop.getWhileStm().getStatement();
                DataFlowHelper _dataFlowHelper = new DataFlowHelper(dfh);
                this.traverseChildren(_statement, _dataFlowHelper);
            } else {
                boolean _tripleNotEquals_4;
                DoWhileStatement _doStm = loop.getDoStm();
                boolean bl5 = _tripleNotEquals_4 = _doStm != null;
                if (_tripleNotEquals_4) {
                    this.checkVariableStatus(dfh, EcoreUtil2.eAllOfType(loop.getDoStm().getExpression(), ReferencedValue.class));
                    StatementBlock _statement_1 = loop.getDoStm().getStatement();
                    DataFlowHelper _dataFlowHelper_1 = new DataFlowHelper(dfh);
                    this.traverseChildren(_statement_1, _dataFlowHelper_1);
                }
            }
        }
    }

    protected void updateVariableStatus(DataFlowHelper dfh, SingleVarInstance target) {
        this.updateVariableStatus(dfh, target, target.getExpr());
    }

    protected void updateVariableStatus(DataFlowHelper dfh, SingleTempVarInstance target) {
        this.updateVariableStatus(dfh, target, target.getTemplate());
    }

    protected void updateVariableStatus(DataFlowHelper dfh, EObject target, EObject targetValue) {
        boolean _tripleEquals;
        DataFlowHelper.STATUS _state = dfh.getState(target);
        boolean bl = _tripleEquals = _state == DataFlowHelper.STATUS.UNDECLARED;
        if (_tripleEquals) {
            if (targetValue != null) {
                dfh.getStates().put(target, DataFlowHelper.STATUS.INITIALISED);
            } else {
                dfh.getStates().put(target, DataFlowHelper.STATUS.DECLARED);
            }
        }
    }

    protected void updateVariableStatus(DataFlowHelper dfh, ReferencedValue value) {
        RefValueHead target = value.getHead().getTarget();
        if (target instanceof SingleVarInstance) {
            this.updateVariableStatusRV(dfh, target, value);
        } else if (target instanceof SingleTempVarInstance) {
            this.updateVariableStatusRV(dfh, target, value);
        } else {
            boolean cfr_ignored_0 = target instanceof FormalTemplatePar;
        }
    }

    protected void updateVariableStatusRV(DataFlowHelper dfh, EObject target, EObject context) {
        boolean _tripleNotEquals;
        DataFlowHelper.STATUS _state = dfh.getState(target);
        boolean bl = _tripleNotEquals = _state != DataFlowHelper.STATUS.UNDECLARED;
        if (_tripleNotEquals) {
            boolean _tripleEquals;
            DataFlowHelper.STATUS _state_1 = dfh.getState(target);
            boolean bl2 = _tripleEquals = _state_1 == DataFlowHelper.STATUS.DECLARED;
            if (_tripleEquals) {
                dfh.setState(target, DataFlowHelper.STATUS.INITIALISED);
            }
        } else {
            boolean _not;
            EObject _eContainer = target.eContainer().eContainer().eContainer();
            boolean bl3 = _not = !(_eContainer instanceof ComponentElementDef);
            if (_not) {
                this.uninitialisedVariableWarning(target, "declared", context);
            }
        }
    }

    protected void checkVariableStatus(DataFlowHelper dfh, Iterable<ReferencedValue> values) {
        Functions.Function1<ReferencedValue, Boolean> _function = it -> it.eContainer() instanceof Value || it.eContainer() instanceof ValueRef && !(it.eContainer().eContainer() instanceof Assignment);
        Iterable<ReferencedValue> _filter = IterableExtensions.filter(values, _function);
        for (ReferencedValue value : _filter) {
            RefValueHead target = value.getHead().getTarget();
            EObject _eContainer = target.eContainer();
            if (_eContainer instanceof FunctionFormalPar || target instanceof Enumeration) continue;
            this.checkVariableStatus(dfh, target, value);
        }
    }

    protected String getName(EObject target) {
        String _name = target.eClass().getName();
        String name = _name + " : ";
        if (target instanceof SingleVarInstance) {
            String _name_1 = name;
            String _name_2 = ((SingleVarInstance)target).getName();
            name = _name_1 + _name_2;
        } else if (target instanceof SingleTempVarInstance) {
            String _name_3 = name;
            String _name_4 = ((SingleTempVarInstance)target).getName();
            name = _name_3 + _name_4;
        } else if (target instanceof FormalValuePar) {
            String _name_5 = name;
            String _name_6 = ((FormalValuePar)target).getName();
            name = _name_5 + _name_6;
        } else if (target instanceof FormalTemplatePar) {
            String _name_7 = name;
            String _name_8 = ((FormalTemplatePar)target).getName();
            name = _name_7 + _name_8;
        } else {
            String _name_9 = name;
            name = _name_9 + "TODO";
        }
        return name;
    }

    protected void checkVariableStatus(DataFlowHelper dfh, EObject target, EObject context) {
        boolean _tripleNotEquals;
        DataFlowHelper.STATUS _state = dfh.getState(target);
        boolean bl = _tripleNotEquals = _state != DataFlowHelper.STATUS.UNDECLARED;
        if (_tripleNotEquals) {
            boolean _tripleEquals;
            DataFlowHelper.STATUS _state_1 = dfh.getState(target);
            boolean bl2 = _tripleEquals = _state_1 == DataFlowHelper.STATUS.DECLARED;
            if (_tripleEquals) {
                this.uninitialisedVariableWarning(target, "initialised", context);
            }
        } else {
            EObject parent;
            boolean _tripleNotEquals_1;
            EObject _eContainer = target.eContainer();
            boolean bl3 = _tripleNotEquals_1 = _eContainer != null;
            if (_tripleNotEquals_1 && !((parent = target.eContainer().eContainer()) instanceof TimerInstance) && !(parent.eContainer() instanceof ComponentElementDef)) {
                this.uninitialisedVariableWarning(target, "declared", context);
            }
        }
    }

    protected void checkComponentVariableStatus(DataFlowHelper dfh, EObject target, EObject context) {
        ReferencedType _head;
        EObject parent = target.eContainer().eContainer();
        if (parent instanceof VarInstance && (_head = ((VarInstance)parent).getListType().getRef().getHead()) instanceof ComponentDef) {
            boolean _tripleNotEquals;
            DataFlowHelper.STATUS _state = dfh.getState(target);
            boolean bl = _tripleNotEquals = _state != DataFlowHelper.STATUS.UNDECLARED;
            if (_tripleNotEquals) {
                boolean _tripleEquals;
                DataFlowHelper.STATUS _state_1 = dfh.getState(target);
                boolean bl2 = _tripleEquals = _state_1 == DataFlowHelper.STATUS.DECLARED;
                if (_tripleEquals) {
                    this.uninitialisedVariableWarning(target, "initialised", context);
                }
            } else {
                boolean _not;
                EObject _eContainer = ((VarInstance)parent).eContainer();
                boolean bl3 = _not = !(_eContainer instanceof ComponentElementDef);
                if (_not) {
                    this.uninitialisedVariableWarning(target, "declared", context);
                }
            }
        }
    }

    protected Boolean checkIfExcluded(EObject target) {
        boolean _not;
        boolean filter = false;
        boolean _isEmpty = ((List)Conversions.doWrapArray(this.activeProfile.getCheckNoUninitialisedVariablesExclude())).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            filter = this.checkExclusionForVarInstance(target);
        }
        return filter;
    }

    protected boolean checkExclusionForVarInstance(EObject target) {
        Type type;
        boolean filter = false;
        VarInstance vi = TTCN3ScopeHelper.findDesiredParent(target, VarInstance.class);
        if (vi != null && (type = vi.getListType()) != null) {
            if (type.getPre() != null && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), type.getPre())) {
                filter = true;
            } else {
                boolean _tripleNotEquals;
                TypeReference _ref = type.getRef();
                boolean bl = _tripleNotEquals = _ref != null;
                if (_tripleNotEquals) {
                    if (type.getRef().getHead() instanceof RecordDefNamed && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), "record")) {
                        filter = true;
                    } else if (type.getRef().getHead() instanceof RecordOfDefNamed && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), "record of")) {
                        filter = true;
                    } else if (type.getRef().getHead() instanceof SetDefNamed && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), "set")) {
                        filter = true;
                    } else if (type.getRef().getHead() instanceof SetOfDefNamed && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), "set of")) {
                        filter = true;
                    } else if (type.getRef().getHead() instanceof UnionDefNamed && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), "union")) {
                        filter = true;
                    } else if (type.getRef().getHead() instanceof EnumDefNamed && ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), "enumerated")) {
                        filter = true;
                    } else {
                        boolean _contains = ArrayExtensions.contains(this.activeProfile.getCheckNoUninitialisedVariablesExclude(), type.getRef().getHead().getName());
                        if (_contains) {
                            filter = true;
                        }
                    }
                }
            }
        }
        return filter;
    }

    protected void uninitialisedVariableWarning(EObject target, String status, EObject context) {
        Boolean _checkIfExcluded = this.checkIfExcluded(target);
        if (_checkIfExcluded.booleanValue()) {
            return;
        }
        if (target instanceof SingleVarInstance) {
            this.uninitialisedVariableWarning(((SingleVarInstance)target).getName(), status, context);
        } else if (target instanceof SingleTempVarInstance) {
            this.uninitialisedVariableWarning(((SingleTempVarInstance)target).getName(), status, context);
        }
    }

    protected void uninitialisedVariableWarning(String targetName, String status, EObject context) {
        TTCN3StatisticsProvider.getInstance().incrementCountStyle();
        String parentName = "Module Control Part";
        FunctionDef parent = TTCN3ScopeHelper.findDesiredParent(context, FunctionDef.class);
        if (parent != null) {
            parentName = parent.getName();
        } else {
            AltstepDef asd = TTCN3ScopeHelper.findDesiredParent(context, AltstepDef.class);
            if (asd != null) {
                parentName = asd.getName();
            }
        }
        String message = "Local definition for \"" + targetName + "\" in definition of \"" + parentName + "\" is not " + status + "!";
        ICompositeNode node = NodeModelUtils.getNode(context);
        this.warning(message, context, null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "6.10, checkNoUninitialisedVariables");
    }
}

