/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.TTCN3ReferenceHelper;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.scoping.ImportData;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import de.ugoe.cs.swe.tTCN3.AltConstruct;
import de.ugoe.cs.swe.tTCN3.AltstepDef;
import de.ugoe.cs.swe.tTCN3.AltstepInstance;
import de.ugoe.cs.swe.tTCN3.AltstepLocalDef;
import de.ugoe.cs.swe.tTCN3.ArrayElementExpressionList;
import de.ugoe.cs.swe.tTCN3.ArrayOrBitRef;
import de.ugoe.cs.swe.tTCN3.ArrayOrMixedExpression;
import de.ugoe.cs.swe.tTCN3.Assignment;
import de.ugoe.cs.swe.tTCN3.BaseTemplate;
import de.ugoe.cs.swe.tTCN3.ComponentDef;
import de.ugoe.cs.swe.tTCN3.ComponentDefList;
import de.ugoe.cs.swe.tTCN3.ComponentElementDef;
import de.ugoe.cs.swe.tTCN3.ConstDef;
import de.ugoe.cs.swe.tTCN3.ConstList;
import de.ugoe.cs.swe.tTCN3.DerivedDef;
import de.ugoe.cs.swe.tTCN3.EnumDef;
import de.ugoe.cs.swe.tTCN3.EnumDefNamed;
import de.ugoe.cs.swe.tTCN3.Enumeration;
import de.ugoe.cs.swe.tTCN3.ExtFunctionDef;
import de.ugoe.cs.swe.tTCN3.ExtendedFieldReference;
import de.ugoe.cs.swe.tTCN3.FieldExpressionList;
import de.ugoe.cs.swe.tTCN3.FieldExpressionSpec;
import de.ugoe.cs.swe.tTCN3.FieldReference;
import de.ugoe.cs.swe.tTCN3.FormalTemplatePar;
import de.ugoe.cs.swe.tTCN3.FormalValuePar;
import de.ugoe.cs.swe.tTCN3.FunctionBodyDef;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionDefOrStatement;
import de.ugoe.cs.swe.tTCN3.FunctionFormalParList;
import de.ugoe.cs.swe.tTCN3.FunctionInstance;
import de.ugoe.cs.swe.tTCN3.FunctionRef;
import de.ugoe.cs.swe.tTCN3.FunctionStatement;
import de.ugoe.cs.swe.tTCN3.GotoStatement;
import de.ugoe.cs.swe.tTCN3.GroupDef;
import de.ugoe.cs.swe.tTCN3.ImportDef;
import de.ugoe.cs.swe.tTCN3.LabelStatement;
import de.ugoe.cs.swe.tTCN3.MatchingSymbol;
import de.ugoe.cs.swe.tTCN3.ModuleControlBody;
import de.ugoe.cs.swe.tTCN3.ModuleDefinition;
import de.ugoe.cs.swe.tTCN3.ModuleDefinitionsList;
import de.ugoe.cs.swe.tTCN3.ModulePar;
import de.ugoe.cs.swe.tTCN3.ModuleParDef;
import de.ugoe.cs.swe.tTCN3.ModuleParameter;
import de.ugoe.cs.swe.tTCN3.MultitypedModuleParList;
import de.ugoe.cs.swe.tTCN3.NestedUnionDef;
import de.ugoe.cs.swe.tTCN3.NotUsedOrExpression;
import de.ugoe.cs.swe.tTCN3.OpCall;
import de.ugoe.cs.swe.tTCN3.PermutationMatch;
import de.ugoe.cs.swe.tTCN3.PortDef;
import de.ugoe.cs.swe.tTCN3.PortElement;
import de.ugoe.cs.swe.tTCN3.PortInstance;
import de.ugoe.cs.swe.tTCN3.PreDefFunction;
import de.ugoe.cs.swe.tTCN3.PredefinedValue;
import de.ugoe.cs.swe.tTCN3.RecordDef;
import de.ugoe.cs.swe.tTCN3.RecordDefNamed;
import de.ugoe.cs.swe.tTCN3.RecordOfDef;
import de.ugoe.cs.swe.tTCN3.RecordOfDefNamed;
import de.ugoe.cs.swe.tTCN3.RefValue;
import de.ugoe.cs.swe.tTCN3.RefValueHead;
import de.ugoe.cs.swe.tTCN3.ReferencedType;
import de.ugoe.cs.swe.tTCN3.ReferencedValue;
import de.ugoe.cs.swe.tTCN3.RestrictedTemplate;
import de.ugoe.cs.swe.tTCN3.ReturnType;
import de.ugoe.cs.swe.tTCN3.RunsOnSpec;
import de.ugoe.cs.swe.tTCN3.SetDef;
import de.ugoe.cs.swe.tTCN3.SetDefNamed;
import de.ugoe.cs.swe.tTCN3.SetOfDef;
import de.ugoe.cs.swe.tTCN3.SetOfDefNamed;
import de.ugoe.cs.swe.tTCN3.SignatureDef;
import de.ugoe.cs.swe.tTCN3.SimpleSpec;
import de.ugoe.cs.swe.tTCN3.SimpleTemplateSpec;
import de.ugoe.cs.swe.tTCN3.SingleConstDef;
import de.ugoe.cs.swe.tTCN3.SingleExpression;
import de.ugoe.cs.swe.tTCN3.SingleTempVarInstance;
import de.ugoe.cs.swe.tTCN3.SingleTemplateExpression;
import de.ugoe.cs.swe.tTCN3.SingleVarInstance;
import de.ugoe.cs.swe.tTCN3.StatementBlock;
import de.ugoe.cs.swe.tTCN3.StructFieldDef;
import de.ugoe.cs.swe.tTCN3.StructuredTypeDef;
import de.ugoe.cs.swe.tTCN3.SubTypeDef;
import de.ugoe.cs.swe.tTCN3.SubTypeDefNamed;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.tTCN3.TTCN3Reference;
import de.ugoe.cs.swe.tTCN3.TempVarList;
import de.ugoe.cs.swe.tTCN3.TemplateBody;
import de.ugoe.cs.swe.tTCN3.TemplateDef;
import de.ugoe.cs.swe.tTCN3.TemplateInstance;
import de.ugoe.cs.swe.tTCN3.TemplateOps;
import de.ugoe.cs.swe.tTCN3.TemplateOrValueFormalParList;
import de.ugoe.cs.swe.tTCN3.TestcaseDef;
import de.ugoe.cs.swe.tTCN3.TimerInstance;
import de.ugoe.cs.swe.tTCN3.TimerRefOrAll;
import de.ugoe.cs.swe.tTCN3.TimerRefOrAny;
import de.ugoe.cs.swe.tTCN3.Type;
import de.ugoe.cs.swe.tTCN3.TypeDef;
import de.ugoe.cs.swe.tTCN3.TypeDefBody;
import de.ugoe.cs.swe.tTCN3.TypeReference;
import de.ugoe.cs.swe.tTCN3.UnionDef;
import de.ugoe.cs.swe.tTCN3.UnionDefNamed;
import de.ugoe.cs.swe.tTCN3.UnionFieldDef;
import de.ugoe.cs.swe.tTCN3.Value;
import de.ugoe.cs.swe.tTCN3.ValueRef;
import de.ugoe.cs.swe.tTCN3.ValueofOp;
import de.ugoe.cs.swe.tTCN3.VarInstance;
import de.ugoe.cs.swe.tTCN3.VarList;
import de.ugoe.cs.swe.tTCN3.impl.ArrayOrMixedExpressionImpl;
import de.ugoe.cs.swe.validation.CheckDefinitionComeFirstParameter;
import de.ugoe.cs.swe.validation.Guard;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CodeStyleValidator
extends AbstractDeclarativeValidator {
    private static final Map<String, HashMap<String, List<TTCN3Reference>>> moduleLevelIdentifiersMap = new ConcurrentHashMap<String, HashMap<String, List<TTCN3Reference>>>();
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();
    private final TTCN3StatisticsProvider statistics = TTCN3StatisticsProvider.getInstance();
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    @Check
    public void checkNoGotoStatements(GotoStatement goto_) {
        this.checkNoLabelsOrGotoStatements(goto_);
    }

    @Check
    public void checkNoGotoStatements(LabelStatement label) {
        this.checkNoLabelsOrGotoStatements(label);
    }

    private void checkNoLabelsOrGotoStatements(TTCN3Reference ref) {
        boolean _not;
        boolean _isCheckNoLabelsOrGotoStatements = this.activeProfile.isCheckNoLabelsOrGotoStatements();
        boolean bl = _not = !_isCheckNoLabelsOrGotoStatements;
        if (_not) {
            return;
        }
        String message = "";
        String methodName = "";
        ICompositeNode node = NodeModelUtils.getNode(ref);
        boolean _matched = false;
        if (ref instanceof GotoStatement) {
            _matched = true;
            message = "A \"goto\" statement is used!";
            methodName = "checkNoGotoStatements";
        }
        if (!_matched && ref instanceof LabelStatement) {
            _matched = true;
            message = "A \"label\" statement is used!";
            methodName = "checkNoLabelStatements";
        }
        this.statistics.incrementCountStyle();
        this.warning(message, (EStructuralFeature)TTCN3Package.eINSTANCE.getTTCN3Reference_Name(), LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "6.1, " + methodName);
    }

    @Check
    public void checkNoNestedAltStatements(AltConstruct alt) {
        boolean _greaterThan;
        boolean _notEquals;
        boolean _not;
        boolean _isCheckNoNestedAltStatements = this.activeProfile.isCheckNoNestedAltStatements();
        boolean bl = _not = !_isCheckNoNestedAltStatements;
        if (_not) {
            return;
        }
        int depth = this.nestingDepth(alt, AltConstruct.class);
        AltstepDef _findDesiredParent = TTCN3ScopeHelper.findDesiredParent(alt, AltstepDef.class);
        boolean bl2 = _notEquals = !Objects.equals(_findDesiredParent, null);
        if (_notEquals) {
            ++depth;
        }
        ICompositeNode node = NodeModelUtils.getNode(alt);
        int _maximumAllowedNestingDepth = this.activeProfile.getMaximumAllowedNestingDepth();
        boolean bl3 = _greaterThan = depth > _maximumAllowedNestingDepth;
        if (_greaterThan) {
            this.statistics.incrementCountStyle();
            int _maximumAllowedNestingDepth_1 = this.activeProfile.getMaximumAllowedNestingDepth();
            String _plus = "Alt statement nesting depth (" + String.valueOf((Object)depth) + ") exceeds maximum allowed nesting depth (" + String.valueOf((Object)_maximumAllowedNestingDepth_1);
            String message = _plus + ")!";
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_1 = "6.2, " + _methodName;
            this.warning(message, (EObject)alt, null, _string, _string_1, _string_2, _plus_1);
        }
    }

    @Check
    public void checkLevelOfNestedCalls(FunctionInstance instance) {
        boolean _not;
        boolean _isCheckLevelOfNestedCalls = this.activeProfile.isCheckLevelOfNestedCalls();
        boolean bl = _not = !_isCheckLevelOfNestedCalls;
        if (_not) {
            return;
        }
        int maxLevel = this.activeProfile.getMaxLevelOfNestedCalls();
        int depth = 1;
        FunctionInstance parent = instance;
        do {
            if (Objects.equals(parent = TTCN3ScopeHelper.findDesiredParent(parent, FunctionInstance.class), null) || !(parent.getRef() instanceof FunctionDef) && !(parent.getRef() instanceof BaseTemplate)) continue;
            ++depth;
        } while (!Objects.equals(parent, null));
        ICompositeNode node = NodeModelUtils.getNode(instance);
        if (depth > maxLevel) {
            this.statistics.incrementCountStyle();
            String message = "Level of nested functions (" + String.valueOf((Object)depth) + ") exceeds maximum allowed nesting depth (" + String.valueOf((Object)maxLevel) + ")!";
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.20, " + _methodName;
            this.warning(message, (EObject)instance, null, _string, _string_1, _string_2, _plus);
        }
    }

    @Check
    public void checkListedVariableDeclarations(TempVarList list) {
        boolean _greaterThan;
        boolean _not;
        boolean _isCheckListedVariableDeclarations = this.activeProfile.isCheckListedVariableDeclarations();
        boolean bl = _not = !_isCheckListedVariableDeclarations;
        if (_not) {
            return;
        }
        int _size = list.getVariables().size();
        boolean bl2 = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(list);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.21, " + _methodName;
            this.warning("Listed variable declarations are used!", (EObject)list, null, _string, _string_1, _string_2, _plus);
        }
    }

    @Check
    public void checkListedVariableDeclarations(VarList list) {
        boolean _greaterThan;
        boolean _not;
        boolean _isCheckListedVariableDeclarations = this.activeProfile.isCheckListedVariableDeclarations();
        boolean bl = _not = !_isCheckListedVariableDeclarations;
        if (_not) {
            return;
        }
        int _size = list.getVariables().size();
        boolean bl2 = _greaterThan = _size > 1;
        if (_greaterThan) {
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(list);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.21, " + _methodName;
            this.warning("Listed variable declarations are used!", (EObject)list, null, _string, _string_1, _string_2, _plus);
        }
    }

    @Check
    public void checkInlineTemplates(TemplateInstance template) {
        SingleExpression _expr;
        boolean _notEquals;
        boolean _not;
        boolean _isCheckInlineTemplates = this.activeProfile.isCheckInlineTemplates();
        boolean bl = _not = !_isCheckInlineTemplates;
        if (_not) {
            return;
        }
        boolean found = false;
        SimpleSpec _simple = template.getTemplate().getSimple();
        boolean bl2 = _notEquals = !Objects.equals(_simple, null);
        if (_notEquals && (_expr = template.getTemplate().getSimple().getExpr()) instanceof FieldExpressionList) {
            found = true;
        }
        if (found) {
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(template);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getStartLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.22, " + _methodName;
            this.warning("In-line template is used!", (EObject)template, null, _string, _string_1, _string_2, _plus);
        }
    }

    private <T extends EObject> int nestingDepth(EObject o, Class<T> t2) {
        int depth = -1;
        EObject parent = o;
        do {
            parent = TTCN3ScopeHelper.findDesiredParent(parent, t2);
            ++depth;
        } while (!Objects.equals(parent, null));
        return depth;
    }

    @Check
    public void checkNoPermutationKeyword(PermutationMatch permutation) {
        boolean _not;
        boolean _isCheckNoPermutationKeyword = this.activeProfile.isCheckNoPermutationKeyword();
        boolean bl = _not = !_isCheckNoPermutationKeyword;
        if (_not) {
            return;
        }
        this.statistics.incrementCountStyle();
        ICompositeNode node = NodeModelUtils.getNode(permutation);
        String _string = LoggingInterface.MessageClass.STYLE.toString();
        String _string_1 = Integer.valueOf(node.getStartLine()).toString();
        String _string_2 = Integer.valueOf(node.getEndLine()).toString();
        String _methodName = MiscTools.getMethodName();
        String _plus = "6.4, " + _methodName;
        this.warning("Keyword \"permutation\" is used!", (EObject)permutation, null, _string, _string_1, _string_2, _plus);
    }

    @Check
    public void checkNoAnyTypeKeyword(Type type) {
        boolean _not;
        boolean _isCheckNoAnyTypeKeyword = this.activeProfile.isCheckNoAnyTypeKeyword();
        boolean bl = _not = !_isCheckNoAnyTypeKeyword;
        if (_not) {
            return;
        }
        if (!Objects.equals(type.getPre(), null) && Objects.equals(type.getPre(), "anytype")) {
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(type);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.5, " + _methodName;
            this.warning("Keyword \"anytype\" is used!", (EObject)type, null, _string, _string_1, _string_2, _plus);
        }
    }

    public boolean checkValueTemplate(TemplateDef td) {
        return td.getRestriction().getValue() == null && td.getRestriction().getPresent() == null;
    }

    public boolean checkValueTemplate(RestrictedTemplate td) {
        return td.getRestriction().getValue() == null && td.getRestriction().getPresent() == null;
    }

    public boolean checkAnyValueOrNoneUsage(SingleExpression expr) {
        if (expr instanceof Value) {
            boolean _tripleNotEquals;
            ReferencedValue _ref = ((Value)expr).getRef();
            boolean bl = _tripleNotEquals = _ref != null;
            if (_tripleNotEquals) {
                RefValueHead ref = ((Value)expr).getRef().getHead().getTarget();
                if (ref instanceof SingleVarInstance) {
                    return false;
                }
                if (ref instanceof SingleTempVarInstance) {
                    boolean _tripleNotEquals_1;
                    VarInstance vi = TTCN3ScopeHelper.findDesiredParent(ref, VarInstance.class);
                    RestrictedTemplate _resTemplate = vi.getResTemplate();
                    boolean bl2 = _tripleNotEquals_1 = _resTemplate != null;
                    if (_tripleNotEquals_1) {
                        return this.checkValueTemplate(vi.getResTemplate());
                    }
                    return true;
                }
                if (ref instanceof BaseTemplate) {
                    TemplateDef td = TTCN3ScopeHelper.findDesiredParent(ref, TemplateDef.class);
                    return this.checkValueTemplate(td);
                }
                if (ref instanceof SingleConstDef) {
                    return false;
                }
                if (ref instanceof FormalValuePar) {
                    return false;
                }
                if (ref instanceof FormalTemplatePar) {
                    boolean _tripleNotEquals_2;
                    RestrictedTemplate _restriction = ((FormalTemplatePar)ref).getRestriction();
                    boolean bl3 = _tripleNotEquals_2 = _restriction != null;
                    if (_tripleNotEquals_2) {
                        return this.checkValueTemplate(((FormalTemplatePar)ref).getRestriction());
                    }
                    return true;
                }
            } else {
                PredefinedValue _predef_1;
                boolean _tripleNotEquals_3;
                PredefinedValue _predef = ((Value)expr).getPredef();
                boolean bl4 = _tripleNotEquals_3 = _predef != null;
                if (_tripleNotEquals_3 && (_predef_1 = ((Value)expr).getPredef()) instanceof PredefinedValue) {
                    boolean _tripleNotEquals_4;
                    String _omit = ((Value)expr).getPredef().getOmit();
                    boolean bl5 = _tripleNotEquals_4 = _omit != null;
                    if (_tripleNotEquals_4) {
                        return true;
                    }
                }
            }
        } else if (expr instanceof OpCall) {
            TemplateOps _templateOps;
            boolean _tripleNotEquals_9;
            boolean _tripleNotEquals_5;
            FunctionInstance _function = ((OpCall)expr).getFunction();
            boolean bl = _tripleNotEquals_5 = _function != null;
            if (_tripleNotEquals_5) {
                FunctionRef _ref_3;
                boolean _tripleNotEquals_6;
                PreDefFunction _pre = ((OpCall)expr).getFunction().getPre();
                boolean bl6 = _tripleNotEquals_6 = _pre != null;
                if (_tripleNotEquals_6) {
                    return false;
                }
                FunctionRef _ref_1 = ((OpCall)expr).getFunction().getRef();
                if (_ref_1 instanceof FunctionDef) {
                    boolean _tripleNotEquals_8;
                    boolean _tripleNotEquals_7;
                    FunctionRef _ref_2 = ((OpCall)expr).getFunction().getRef();
                    ReturnType returnType = ((FunctionDef)_ref_2).getReturnType();
                    String _template = returnType.getTemplate();
                    boolean bl7 = _tripleNotEquals_7 = _template != null;
                    if (_tripleNotEquals_7) {
                        return true;
                    }
                    RestrictedTemplate _restricted = returnType.getRestricted();
                    boolean bl8 = _tripleNotEquals_8 = _restricted != null;
                    if (_tripleNotEquals_8) {
                        return this.checkValueTemplate(returnType.getRestricted());
                    }
                }
                if ((_ref_3 = ((OpCall)expr).getFunction().getRef()) instanceof BaseTemplate) {
                    TemplateDef td_1 = TTCN3ScopeHelper.findDesiredParent(((OpCall)expr).getFunction().getRef(), TemplateDef.class);
                    return this.checkValueTemplate(td_1);
                }
            }
            boolean bl9 = _tripleNotEquals_9 = (_templateOps = ((OpCall)expr).getTemplateOps()) != null;
            if (_tripleNotEquals_9) {
                return false;
            }
        }
        return false;
    }

    @Check
    public void checkNoAnyValueOrNoneInListValues(ExtendedFieldReference r) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _not;
        boolean _isCheckNoAnyValueOrNoneInListValues = this.activeProfile.isCheckNoAnyValueOrNoneInListValues();
        boolean bl = _not = !_isCheckNoAnyValueOrNoneInListValues;
        if (_not) {
            return;
        }
        EObject _eContainer = r.eContainer();
        if (_eContainer instanceof Type) {
            return;
        }
        EObject _nextSibling = EcoreUtil2.getNextSibling(r);
        boolean bl2 = _tripleNotEquals = _nextSibling != null;
        if (_tripleNotEquals) {
            return;
        }
        ArrayOrBitRef _array = r.getArray();
        boolean bl3 = _tripleNotEquals_1 = _array != null;
        if (_tripleNotEquals_1) {
            boolean _tripleNotEquals_3;
            String v = "";
            EObject c = r.eContainer();
            if (c instanceof ReferencedValue) {
                v = TTCN3ScopeHelper.getReferencedValue((ReferencedValue)c).getName();
            } else if (c instanceof SingleTemplateExpression) {
                boolean _tripleNotEquals_2;
                Enumeration _enumeration = ((SingleTemplateExpression)c).getEnumeration();
                boolean bl4 = _tripleNotEquals_2 = _enumeration != null;
                if (_tripleNotEquals_2) {
                    v = ((SingleTemplateExpression)c).getEnumeration().getName();
                }
            }
            Assignment assignment = TTCN3ScopeHelper.findDesiredParent(r, Assignment.class);
            TemplateBody _body = assignment.getBody();
            boolean bl5 = _tripleNotEquals_3 = _body != null;
            if (_tripleNotEquals_3) {
                SingleTemplateExpression tExpr;
                boolean _tripleNotEquals_4;
                boolean _not_1;
                EObject _eContainer_1 = r.eContainer().eContainer();
                boolean bl6 = _not_1 = !(_eContainer_1 instanceof ValueRef);
                if (_not_1) {
                    return;
                }
                SingleExpression expr = assignment.getBody().getSimple().getExpr();
                if (expr instanceof ArrayOrMixedExpression) {
                    this.checkArrayExpression((ArrayOrMixedExpressionImpl)expr, v);
                }
                boolean present = this.checkAnyValueOrNoneUsage(expr);
                SimpleTemplateSpec _spec = assignment.getBody().getSimple().getSpec();
                boolean bl7 = _tripleNotEquals_4 = _spec != null;
                if (_tripleNotEquals_4 && (tExpr = assignment.getBody().getSimple().getSpec().getExpr()) instanceof SingleTemplateExpression) {
                    boolean _tripleNotEquals_5;
                    MatchingSymbol _symbol = tExpr.getSymbol();
                    boolean bl8 = _tripleNotEquals_5 = _symbol != null;
                    if (_tripleNotEquals_5) {
                        boolean _tripleNotEquals_6;
                        String _anyornone = tExpr.getSymbol().getAnyornone();
                        boolean bl9 = _tripleNotEquals_6 = _anyornone != null;
                        if (_tripleNotEquals_6) {
                            present = true;
                        }
                    }
                }
                if (!present) {
                    return;
                }
            }
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(r);
            String message = "\"AnyValueOrNone\" used as a list value in \"" + v + "\"!";
            EObject _eContainer_2 = r.eContainer();
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.15, " + _methodName;
            this.warning(message, _eContainer_2, null, _string, _string_1, _string_2, _plus);
        }
    }

    public void checkArrayExpression(ArrayOrMixedExpressionImpl expr, String target) {
        EList<NotUsedOrExpression> _expr = expr.getList().getExpr();
        for (NotUsedOrExpression v : _expr) {
            boolean present;
            if (!(v instanceof Value) || !(present = this.checkAnyValueOrNoneUsage((SingleExpression)v))) continue;
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(v);
            String message = "\"AnyValueOrNone\" is used as a list value in \"" + target + "\"!";
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.15, " + _methodName;
            this.warning(message, (EObject)v, null, _string, _string_1, _string_2, _plus);
        }
    }

    @Check
    public void checkNoAnyValueOrNoneInListValues(SingleTempVarInstance vi) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _not;
        boolean _isCheckNoAnyValueOrNoneInListValues = this.activeProfile.isCheckNoAnyValueOrNoneInListValues();
        boolean bl = _not = !_isCheckNoAnyValueOrNoneInListValues;
        if (_not) {
            return;
        }
        Type type = TTCN3ScopeHelper.findDesiredParent(vi, VarInstance.class).getType();
        String _pre = type.getPre();
        boolean bl2 = _tripleNotEquals = _pre != null;
        if (_tripleNotEquals) {
            return;
        }
        TypeReference _ref = type.getRef();
        boolean bl3 = _tripleNotEquals_1 = _ref != null;
        if (_tripleNotEquals_1) {
            ReferencedType refType = type.getRef().getHead();
            if (!(refType instanceof RecordOfDefNamed) && !(refType instanceof SetOfDefNamed)) {
                return;
            }
            SingleExpression expr = vi.getTemplate().getSimple().getExpr();
            if (!(expr instanceof ArrayOrMixedExpression)) {
                return;
            }
            this.checkArrayExpression((ArrayOrMixedExpressionImpl)expr, vi.getName());
        }
    }

    @Check
    public void checkNoAnyValueOrNoneInListValues(TemplateDef template) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _not;
        boolean _isCheckNoAnyValueOrNoneInListValues = this.activeProfile.isCheckNoAnyValueOrNoneInListValues();
        boolean bl = _not = !_isCheckNoAnyValueOrNoneInListValues;
        if (_not) {
            return;
        }
        Type type = template.getBase().getType();
        String _pre = type.getPre();
        boolean bl2 = _tripleNotEquals = _pre != null;
        if (_tripleNotEquals) {
            return;
        }
        TypeReference _ref = template.getBase().getType().getRef();
        boolean bl3 = _tripleNotEquals_1 = _ref != null;
        if (_tripleNotEquals_1) {
            ReferencedType refType = template.getBase().getType().getRef().getHead();
            if (!(refType instanceof RecordOfDefNamed) && !(refType instanceof SetOfDefNamed)) {
                return;
            }
            SingleExpression expr = template.getBody().getSimple().getExpr();
            if (!(expr instanceof ArrayOrMixedExpression)) {
                return;
            }
            this.checkArrayExpression((ArrayOrMixedExpressionImpl)expr, template.getBase().getName());
        }
    }

    @Check
    public void checkNoModifiedTemplateOfModifiedTemplate(TemplateDef template) {
        boolean _notEquals;
        boolean _not;
        boolean _isCheckNoModifiedTemplateOfModifiedTemplate = this.activeProfile.isCheckNoModifiedTemplateOfModifiedTemplate();
        boolean bl = _not = !_isCheckNoModifiedTemplateOfModifiedTemplate;
        if (_not) {
            return;
        }
        DerivedDef _derived = template.getDerived();
        boolean bl2 = _notEquals = !Objects.equals(_derived, null);
        if (_notEquals) {
            boolean _notEquals_1;
            TemplateDef baseTemplate = TTCN3ScopeHelper.findDesiredParent(template.getDerived().getTemplate(), TemplateDef.class);
            ICompositeNode node = NodeModelUtils.getNode(template);
            DerivedDef _derived_1 = baseTemplate.getDerived();
            boolean bl3 = _notEquals_1 = !Objects.equals(_derived_1, null);
            if (_notEquals_1) {
                this.statistics.incrementCountStyle();
                String _name = template.getBase().getName();
                String _plus = "Template \"" + _name;
                String _plus_1 = _plus + "\" modifies another modified template (\"";
                String _name_1 = baseTemplate.getBase().getName();
                String _plus_2 = _plus_1 + _name_1;
                String message = _plus_2 + "\")!";
                BaseTemplate _base = template.getBase();
                String _string = LoggingInterface.MessageClass.STYLE.toString();
                String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                String _methodName = MiscTools.getMethodName();
                String _plus_3 = "6.7, " + _methodName;
                this.warning(message, (EObject)_base, null, _string, _string_1, _string_2, _plus_3);
            }
        }
    }

    @Check
    public void checkLocalDefinitionsComeFirst(SingleVarInstance variable) {
        boolean _not;
        boolean _isCheckLocalDefinitionsComeFirst = this.activeProfile.isCheckLocalDefinitionsComeFirst();
        boolean bl = _not = !_isCheckLocalDefinitionsComeFirst;
        if (_not) {
            return;
        }
        this.checkLocalDefinitionsComeFirstAll(variable);
    }

    @Check
    public void checkLocalDefinitionsComeFirst(SingleConstDef variable) {
        boolean _not;
        boolean _isCheckLocalDefinitionsComeFirst = this.activeProfile.isCheckLocalDefinitionsComeFirst();
        boolean bl = _not = !_isCheckLocalDefinitionsComeFirst;
        if (_not) {
            return;
        }
        this.checkLocalDefinitionsComeFirstAll(variable);
    }

    @Check
    public void checkLocalDefinitionsComeFirst(PortDef variable) {
        boolean _not;
        boolean _isCheckLocalDefinitionsComeFirst = this.activeProfile.isCheckLocalDefinitionsComeFirst();
        boolean bl = _not = !_isCheckLocalDefinitionsComeFirst;
        if (_not) {
            return;
        }
        this.checkLocalDefinitionsComeFirstAll(variable);
    }

    private void checkLocalDefinitionsComeFirstAll(TTCN3Reference definition) {
        boolean _notEquals;
        FunctionDef function = TTCN3ScopeHelper.findDesiredParent(definition, FunctionDef.class);
        AltstepDef altstep = TTCN3ScopeHelper.findDesiredParent(definition, AltstepDef.class);
        TestcaseDef testcase = TTCN3ScopeHelper.findDesiredParent(definition, TestcaseDef.class);
        ModuleControlBody control = TTCN3ScopeHelper.findDesiredParent(definition, ModuleControlBody.class);
        int lastDef = Integer.MIN_VALUE;
        int firstStat = Integer.MIN_VALUE;
        int line = NodeModelUtils.getNode(definition).getStartLine();
        if (function != null && function.getStatement() != null && function.getStatement().getDefOrStatementList() != null) {
            boolean _not;
            Functions.Function1<FunctionDefOrStatement, Boolean> _function = it -> it instanceof FunctionBodyDef;
            List<FunctionDefOrStatement> defs = IterableExtensions.toList(IterableExtensions.filter(function.getStatement().getDefOrStatementList().getDefOrStatement(), _function));
            boolean _isEmpty = defs.isEmpty();
            if (_isEmpty) {
                return;
            }
            FunctionDefOrStatement last = defs.getLast();
            Functions.Function1<FunctionDefOrStatement, Boolean> _function_1 = it -> it instanceof FunctionStatement;
            List<FunctionDefOrStatement> statements = IterableExtensions.toList(IterableExtensions.filter(function.getStatement().getDefOrStatementList().getDefOrStatement(), _function_1));
            boolean _isEmpty_1 = statements.isEmpty();
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                FunctionDefOrStatement firstStatement = statements.getFirst();
                firstStat = NodeModelUtils.getNode(firstStatement).getStartLine();
            }
            lastDef = NodeModelUtils.getNode(last).getStartLine();
        }
        if (testcase != null && testcase.getStatement() != null && testcase.getStatement().getDefOrStatementList() != null) {
            boolean _not_1;
            Functions.Function1<FunctionDefOrStatement, Boolean> _function_2 = it -> it instanceof FunctionBodyDef;
            FunctionDefOrStatement last_1 = IterableExtensions.toList(IterableExtensions.filter(testcase.getStatement().getDefOrStatementList().getDefOrStatement(), _function_2)).getLast();
            Functions.Function1<FunctionDefOrStatement, Boolean> _function_3 = it -> it instanceof FunctionStatement;
            List<FunctionDefOrStatement> statements_1 = IterableExtensions.toList(IterableExtensions.filter(testcase.getStatement().getDefOrStatementList().getDefOrStatement(), _function_3));
            boolean _isEmpty_2 = statements_1.isEmpty();
            boolean bl = _not_1 = !_isEmpty_2;
            if (_not_1) {
                FunctionDefOrStatement firstStatement_1 = IterableExtensions.toList(statements_1).getFirst();
                firstStat = NodeModelUtils.getNode(firstStatement_1).getStartLine();
            }
            lastDef = NodeModelUtils.getNode(last_1).getStartLine();
        }
        if (!Objects.equals(altstep, null) && !Objects.equals(altstep.getLocal().getDefs(), null)) {
            lastDef = NodeModelUtils.getNode((EObject)altstep.getLocal().getDefs().getLast()).getStartLine();
            firstStat = Integer.MAX_VALUE;
        }
        boolean bl = _notEquals = !Objects.equals(control, null);
        if (_notEquals) {
            boolean _not_2;
            boolean _isEmpty_3 = control.getList().getLocalDef().isEmpty();
            boolean bl2 = _not_2 = !_isEmpty_3;
            if (_not_2) {
                lastDef = NodeModelUtils.getNode((EObject)control.getList().getLocalDef().getLast()).getStartLine();
            } else {
                boolean _not_3;
                boolean _isEmpty_4 = control.getList().getLocalInst().isEmpty();
                boolean bl3 = _not_3 = !_isEmpty_4;
                if (_not_3) {
                    lastDef = NodeModelUtils.getNode((EObject)control.getList().getLocalInst().getLast()).getStartLine();
                }
            }
        }
        if (lastDef > Integer.MIN_VALUE && firstStat < line) {
            boolean _notEquals_1;
            String checkName = "checkLocalDefinitionsComeFirst";
            boolean bl4 = _notEquals_1 = !Objects.equals(control, null);
            if (_notEquals_1) {
                checkName = "checkLocalDefinitionsComeFirstWithinControlPart";
            }
            this.statistics.incrementCountStyle();
            this.warning("Local definition is not at the beginning!", null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(line).toString(), Integer.valueOf(line).toString(), "6.8, " + checkName);
        }
    }

    @Check
    public void checkLocalDefinitionsComeFirst(ModuleDefinition moduleDefinition) {
        boolean _not;
        boolean _isCheckLocalDefinitionsComeFirst = this.activeProfile.isCheckLocalDefinitionsComeFirst();
        boolean bl = _not = !_isCheckLocalDefinitionsComeFirst;
        if (_not) {
            return;
        }
        EObject definition = moduleDefinition.getDef();
        if (definition instanceof FunctionDef) {
            this.checkLocalDefinitionsComeFirstStatement(((FunctionDef)definition).getStatement());
        } else if (definition instanceof TestcaseDef) {
            this.checkLocalDefinitionsComeFirstStatement(((TestcaseDef)definition).getStatement());
        } else if (definition instanceof AltstepDef) {
            this.checkLocalDefinitionsComeFirstAltstepDef((AltstepDef)definition);
        } else if (definition instanceof TypeDef && !Objects.equals(((TypeDef)definition).getBody().getStructured(), null) && !Objects.equals(((TypeDef)definition).getBody().getStructured().getComponent(), null)) {
            this.checkLocalDefinitionsComeFirstComponent(((TypeDef)definition).getBody().getStructured().getComponent());
        }
    }

    private void checkLocalDefinitionsComeFirstStatement(StatementBlock statement) {
        CheckDefinitionComeFirstParameter params = new CheckDefinitionComeFirstParameter();
        Functions.Function1<FunctionDefOrStatement, Boolean> _function = it -> it instanceof FunctionBodyDef;
        Iterable<FunctionDefOrStatement> _filter = IterableExtensions.filter(statement.getDefOrStatementList().getDefOrStatement(), _function);
        for (FunctionDefOrStatement d : _filter) {
            if (!(d instanceof FunctionBodyDef)) continue;
            if (((FunctionBodyDef)d).getLocDef() != null && ((FunctionBodyDef)d).getLocDef().getConstDef() != null) {
                this.checkLocalDefinitionsComeFirstOrder(((FunctionBodyDef)d).getLocDef().getConstDef(), params);
                continue;
            }
            if (((FunctionBodyDef)d).getLocInst() != null && ((FunctionBodyDef)d).getLocInst().getTimer() != null) {
                this.checkLocalDefinitionsComeFirstOrder(((FunctionBodyDef)d).getLocInst().getTimer(), params);
                continue;
            }
            if (((FunctionBodyDef)d).getLocInst() == null || ((FunctionBodyDef)d).getLocInst().getVariable() == null) continue;
            this.checkLocalDefinitionsComeFirstOrder(((FunctionBodyDef)d).getLocInst().getVariable(), params);
        }
    }

    private void checkLocalDefinitionsComeFirstAltstepDef(AltstepDef altstep) {
        CheckDefinitionComeFirstParameter params = new CheckDefinitionComeFirstParameter();
        EList<AltstepLocalDef> _defs = altstep.getLocal().getDefs();
        for (AltstepLocalDef d : _defs) {
            boolean _notEquals_2;
            boolean _notEquals_1;
            boolean _notEquals;
            VarInstance _variable = d.getVariable();
            boolean bl = _notEquals = !Objects.equals(_variable, null);
            if (_notEquals) {
                this.checkLocalDefinitionsComeFirstOrder(d.getVariable(), params);
                continue;
            }
            TimerInstance _timer = d.getTimer();
            boolean bl2 = _notEquals_1 = !Objects.equals(_timer, null);
            if (_notEquals_1) {
                this.checkLocalDefinitionsComeFirstOrder(d.getTimer(), params);
                continue;
            }
            ConstDef _const = d.getConst();
            boolean bl3 = _notEquals_2 = !Objects.equals(_const, null);
            if (!_notEquals_2) continue;
            this.checkLocalDefinitionsComeFirstOrder(d.getConst(), params);
        }
    }

    private void checkLocalDefinitionsComeFirstComponent(ComponentDef component) {
        CheckDefinitionComeFirstParameter params = new CheckDefinitionComeFirstParameter();
        EList<ComponentDefList> _defs = component.getDefs();
        for (ComponentDefList d : _defs) {
            boolean _notEquals_4;
            boolean _notEquals_3;
            boolean _notEquals_2;
            boolean _notEquals_1;
            boolean _notEquals;
            PortInstance _port = d.getElement().getPort();
            boolean bl = _notEquals = !Objects.equals(_port, null);
            if (_notEquals) {
                this.checkLocalDefinitionsComeFirstOrder(d.getElement().getPort(), params);
                continue;
            }
            VarInstance _variable = d.getElement().getVariable();
            boolean bl2 = _notEquals_1 = !Objects.equals(_variable, null);
            if (_notEquals_1) {
                this.checkLocalDefinitionsComeFirstOrder(d.getElement().getVariable(), params);
                continue;
            }
            TimerInstance _timer = d.getElement().getTimer();
            boolean bl3 = _notEquals_2 = !Objects.equals(_timer, null);
            if (_notEquals_2) {
                this.checkLocalDefinitionsComeFirstOrder(d.getElement().getTimer(), params);
                continue;
            }
            ConstDef _const = d.getElement().getConst();
            boolean bl4 = _notEquals_3 = !Objects.equals(_const, null);
            if (_notEquals_3) {
                this.checkLocalDefinitionsComeFirstOrder(d.getElement().getConst(), params);
                continue;
            }
            TemplateDef _template = d.getElement().getTemplate();
            boolean bl5 = _notEquals_4 = !Objects.equals(_template, null);
            if (!_notEquals_4) continue;
            this.checkLocalDefinitionsComeFirstOrder(d.getElement().getTemplate(), params);
        }
    }

    private Object checkLocalDefinitionsComeFirstOrder(EObject o, CheckDefinitionComeFirstParameter params) {
        Boolean _xblockexpression = null;
        List<EClass> configuredOrder = this.localDefOrderClasses();
        int currentLocalDefinitionTypeOrderLevel = configuredOrder.indexOf(o.eClass());
        ICompositeNode node = NodeModelUtils.getNode(o);
        Comparable<Boolean> _xifexpression = null;
        boolean _contains = configuredOrder.contains(o.eClass());
        if (_contains) {
            int _xifexpression_1 = 0;
            if (params.hasOtherDefinitions) {
                this.statistics.incrementCountStyle();
                this.warning("Local definition is not at the beginning!", o, null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "6.8, checkLocalDefinitionsComeFirst");
            } else {
                int _xifexpression_2 = 0;
                if (currentLocalDefinitionTypeOrderLevel < params.previousLocalDefinitionsOrderLevel) {
                    this.statistics.incrementCountStyle();
                    String _eClassesToString = this.eClassesToString(configuredOrder);
                    String _plus = "Local definition order is not maintained as configured (" + _eClassesToString;
                    String message_1 = _plus + ")!";
                    this.warning(message_1, o, null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "6.8, checkLocalDefinitionsComeFirst");
                } else {
                    _xifexpression_2 = params.previousLocalDefinitionsOrderLevel = currentLocalDefinitionTypeOrderLevel;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            params.hasOtherDefinitions = true;
            _xifexpression = true;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String eClassesToString(List<EClass> order) {
        String _xblockexpression = null;
        Object res = "";
        int index = 0;
        for (EClass c : order) {
            boolean _lessThan;
            String _res = res;
            String _name = c.getName();
            res = _res + _name;
            int _size = order.size();
            boolean bl = _lessThan = ++index < _size;
            if (!_lessThan) continue;
            Object _res_1 = res;
            res = (String)_res_1 + ", ";
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    private List<EClass> localDefOrderClasses() {
        List<String> defs = IterableExtensions.toList((Iterable)Conversions.doWrapArray(this.activeProfile.getLocalDefinitionTypes()));
        ArrayList<EClass> res = CollectionLiterals.newArrayList();
        for (String d : defs) {
            boolean _equals = Objects.equals(d, "VarInstance");
            if (_equals) {
                res.add(TTCN3Package.eINSTANCE.getVarInstance());
                continue;
            }
            boolean _equals_1 = Objects.equals(d, "ConstDef");
            if (_equals_1) {
                res.add(TTCN3Package.eINSTANCE.getConstDef());
                continue;
            }
            boolean _equals_2 = Objects.equals(d, "TimerInstance");
            if (_equals_2) {
                res.add(TTCN3Package.eINSTANCE.getTimerInstance());
                continue;
            }
            boolean _equals_3 = Objects.equals(d, "PortInstance");
            if (!_equals_3) continue;
            res.add(TTCN3Package.eINSTANCE.getPortInstance());
        }
        return res;
    }

    @Check
    public void checkImportsComeFirst(TTCN3Module module) {
        boolean _not;
        boolean _isCheckImportsComeFirst = this.activeProfile.isCheckImportsComeFirst();
        boolean bl = _not = !_isCheckImportsComeFirst;
        if (_not) {
            return;
        }
        ModuleDefinitionsList _defs = module.getDefs();
        boolean _equals = Objects.equals(_defs, null);
        if (_equals) {
            return;
        }
        boolean hasOtherDefs = false;
        EList<ModuleDefinition> _definitions = module.getDefs().getDefinitions();
        for (ModuleDefinition d : _definitions) {
            EObject _def = d.getDef();
            if (_def instanceof ImportDef) {
                if (!hasOtherDefs) continue;
                this.statistics.incrementCountStyle();
                ICompositeNode node = NodeModelUtils.getNode(d);
                String _string = LoggingInterface.MessageClass.STYLE.toString();
                String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                String _methodName = MiscTools.getMethodName();
                String _plus = "6.9, " + _methodName;
                this.warning("Import statement is not at the beginning!", (EObject)d, null, _string, _string_1, _string_2, _plus);
                continue;
            }
            hasOtherDefs = true;
        }
    }

    @Check
    public void checkNoDuplicatedModuleDefinitionIdentifiers(ModuleDefinition definition) {
        boolean _not;
        boolean _isCheckNoDuplicatedModuleDefinitionIdentifiers = this.activeProfile.isCheckNoDuplicatedModuleDefinitionIdentifiers();
        boolean bl = _not = !_isCheckNoDuplicatedModuleDefinitionIdentifiers;
        if (_not) {
            return;
        }
        TTCN3Module parentModule = TTCN3ScopeHelper.findDesiredParent(definition, TTCN3Module.class);
        HashMap<String, List<TTCN3Reference>> identifiers = CollectionLiterals.newHashMap();
        boolean idExists = false;
        TTCN3Reference detailDef = null;
        boolean _containsKey = moduleLevelIdentifiersMap.containsKey(parentModule.getName());
        if (_containsKey) {
            identifiers = moduleLevelIdentifiersMap.get(parentModule.getName());
        } else {
            moduleLevelIdentifiersMap.put(parentModule.getName(), identifiers);
        }
        EObject _def = definition.getDef();
        if (_def instanceof ConstDef) {
            ConstList _defs;
            EObject _def_1 = definition.getDef();
            ConstList constDefList = _defs = ((ConstDef)_def_1).getDefs();
            EList<SingleConstDef> _list = constDefList.getList();
            for (SingleConstDef d : _list) {
                detailDef = d;
                idExists = this.checkIdentifier(d.getName(), detailDef, identifiers);
            }
        } else {
            EObject _def_2 = definition.getDef();
            if (_def_2 instanceof ModuleParDef) {
                boolean _notEquals;
                EObject _def_3 = definition.getDef();
                ModulePar _param = ((ModuleParDef)_def_3).getParam();
                boolean bl2 = _notEquals = !Objects.equals(_param, null);
                if (_notEquals) {
                    EObject _def_4 = definition.getDef();
                    EList<ModuleParameter> _params = ((ModuleParDef)_def_4).getParam().getList().getParams();
                    for (ModuleParameter p : _params) {
                        detailDef = p;
                        idExists = this.checkIdentifier(p.getName(), detailDef, identifiers);
                    }
                } else {
                    boolean _notEquals_1;
                    EObject _def_5 = definition.getDef();
                    MultitypedModuleParList _multitypeParam = ((ModuleParDef)_def_5).getMultitypeParam();
                    boolean bl3 = _notEquals_1 = !Objects.equals(_multitypeParam, null);
                    if (_notEquals_1) {
                        EObject _def_6 = definition.getDef();
                        EList<ModulePar> _params_1 = ((ModuleParDef)_def_6).getMultitypeParam().getParams();
                        for (ModulePar p_1 : _params_1) {
                            EList<ModuleParameter> _params_2 = p_1.getList().getParams();
                            for (ModuleParameter pa : _params_2) {
                                detailDef = pa;
                                idExists = this.checkIdentifier(pa.getName(), detailDef, identifiers);
                            }
                        }
                    }
                }
            } else {
                EObject _def_7 = definition.getDef();
                if (_def_7 instanceof FunctionDef) {
                    EObject _def_8 = definition.getDef();
                    detailDef = (FunctionDef)_def_8;
                    EObject _def_9 = definition.getDef();
                    idExists = this.checkIdentifier(((FunctionDef)_def_9).getName(), detailDef, identifiers);
                } else {
                    EObject _def_10 = definition.getDef();
                    if (_def_10 instanceof TemplateDef) {
                        EObject _def_11 = definition.getDef();
                        detailDef = ((TemplateDef)_def_11).getBase();
                        EObject _def_12 = definition.getDef();
                        idExists = this.checkIdentifier(((TemplateDef)_def_12).getBase().getName(), detailDef, identifiers);
                    } else {
                        EObject _def_13 = definition.getDef();
                        if (_def_13 instanceof SignatureDef) {
                            EObject _def_14 = definition.getDef();
                            detailDef = (SignatureDef)_def_14;
                            EObject _def_15 = definition.getDef();
                            idExists = this.checkIdentifier(((SignatureDef)_def_15).getName(), detailDef, identifiers);
                        } else {
                            EObject _def_16 = definition.getDef();
                            if (_def_16 instanceof TestcaseDef) {
                                EObject _def_17 = definition.getDef();
                                detailDef = (TestcaseDef)_def_17;
                                EObject _def_18 = definition.getDef();
                                idExists = this.checkIdentifier(((TestcaseDef)_def_18).getName(), detailDef, identifiers);
                            } else {
                                EObject _def_19 = definition.getDef();
                                if (_def_19 instanceof AltstepDef) {
                                    EObject _def_20 = definition.getDef();
                                    detailDef = (AltstepDef)_def_20;
                                    EObject _def_21 = definition.getDef();
                                    idExists = this.checkIdentifier(((AltstepDef)_def_21).getName(), detailDef, identifiers);
                                } else {
                                    EObject _def_22 = definition.getDef();
                                    if (_def_22 instanceof GroupDef) {
                                        EObject _def_23 = definition.getDef();
                                        detailDef = (GroupDef)_def_23;
                                        EObject _def_24 = definition.getDef();
                                        idExists = this.checkIdentifier(((GroupDef)_def_24).getName(), detailDef, identifiers);
                                    } else {
                                        EObject _def_25 = definition.getDef();
                                        if (_def_25 instanceof TypeDef) {
                                            boolean _notEquals_2;
                                            EObject _def_26 = definition.getDef();
                                            TypeDef typeDef = (TypeDef)_def_26;
                                            StructuredTypeDef _structured = typeDef.getBody().getStructured();
                                            boolean bl4 = _notEquals_2 = !Objects.equals(_structured, null);
                                            if (_notEquals_2) {
                                                StructuredTypeDef struct = typeDef.getBody().getStructured();
                                                if (!Objects.equals(struct.getRecord(), null) && struct.getRecord() instanceof RecordDefNamed) {
                                                    RecordDef _record = struct.getRecord();
                                                    detailDef = (TTCN3Reference)((Object)_record);
                                                    RecordDef _record_1 = struct.getRecord();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_record_1)).getName(), detailDef, identifiers);
                                                } else if (!Objects.equals(struct.getUnion(), null) && struct.getUnion() instanceof UnionDefNamed) {
                                                    UnionDef _union = struct.getUnion();
                                                    detailDef = (TTCN3Reference)((Object)_union);
                                                    UnionDef _union_1 = struct.getUnion();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_union_1)).getName(), detailDef, identifiers);
                                                } else if (!Objects.equals(struct.getSet(), null) && struct.getSet() instanceof SetDefNamed) {
                                                    SetDef _set = struct.getSet();
                                                    detailDef = (TTCN3Reference)((Object)_set);
                                                    SetDef _set_1 = struct.getSet();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_set_1)).getName(), detailDef, identifiers);
                                                } else if (!Objects.equals(struct.getRecordOf(), null) && struct.getRecordOf() instanceof RecordOfDefNamed) {
                                                    RecordOfDef _recordOf = struct.getRecordOf();
                                                    detailDef = (TTCN3Reference)((Object)_recordOf);
                                                    RecordOfDef _recordOf_1 = struct.getRecordOf();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_recordOf_1)).getName(), detailDef, identifiers);
                                                } else if (!Objects.equals(struct.getSetOf(), null) && struct.getSetOf() instanceof SetOfDefNamed) {
                                                    SetOfDef _setOf = struct.getSetOf();
                                                    detailDef = (TTCN3Reference)((Object)_setOf);
                                                    SetOfDef _setOf_1 = struct.getSetOf();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_setOf_1)).getName(), detailDef, identifiers);
                                                } else if (!Objects.equals(struct.getEnumDef(), null) && struct.getEnumDef() instanceof EnumDefNamed) {
                                                    EnumDef _enumDef = struct.getEnumDef();
                                                    detailDef = (TTCN3Reference)((Object)_enumDef);
                                                    EnumDef _enumDef_1 = struct.getEnumDef();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_enumDef_1)).getName(), detailDef, identifiers);
                                                } else {
                                                    boolean _notEquals_3;
                                                    PortDef _port = struct.getPort();
                                                    boolean bl5 = _notEquals_3 = !Objects.equals(_port, null);
                                                    if (_notEquals_3) {
                                                        PortDef _port_1 = struct.getPort();
                                                        detailDef = _port_1;
                                                        PortDef _port_2 = struct.getPort();
                                                        idExists = this.checkIdentifier(_port_2.getName(), detailDef, identifiers);
                                                    } else {
                                                        boolean _notEquals_4;
                                                        ComponentDef _component = struct.getComponent();
                                                        boolean bl6 = _notEquals_4 = !Objects.equals(_component, null);
                                                        if (_notEquals_4) {
                                                            ComponentDef _component_1 = struct.getComponent();
                                                            detailDef = _component_1;
                                                            ComponentDef _component_2 = struct.getComponent();
                                                            idExists = this.checkIdentifier(_component_2.getName(), detailDef, identifiers);
                                                        }
                                                    }
                                                }
                                            } else {
                                                SubTypeDef _sub_1;
                                                boolean _notEquals_5;
                                                SubTypeDef _sub = typeDef.getBody().getSub();
                                                boolean bl7 = _notEquals_5 = !Objects.equals(_sub, null);
                                                if (_notEquals_5 && (_sub_1 = typeDef.getBody().getSub()) instanceof SubTypeDefNamed) {
                                                    SubTypeDef _sub_2 = typeDef.getBody().getSub();
                                                    detailDef = (TTCN3Reference)((Object)_sub_2);
                                                    SubTypeDef _sub_3 = typeDef.getBody().getSub();
                                                    idExists = this.checkIdentifier(((TTCN3Reference)((Object)_sub_3)).getName(), detailDef, identifiers);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (idExists) {
            this.statistics.incrementCountStyle();
            String _name = detailDef.getName();
            String _plus = "Identifier \"" + _name;
            String message = _plus + "\" on the module level has already been used in ";
            int _size = identifiers.get(detailDef.getName()).size();
            int size = _size - 1;
            int i = 0;
            List<TTCN3Reference> _get = identifiers.get(detailDef.getName());
            for (TTCN3Reference d_1 : _get) {
                boolean _notEquals_6;
                boolean bl8 = _notEquals_6 = !Objects.equals(d_1, detailDef);
                if (!_notEquals_6) continue;
                ICompositeNode node = NodeModelUtils.getNode(d_1);
                String _message = message;
                String _name_1 = parentModule.getName();
                String _plus_1 = "<\"" + _name_1;
                String _plus_2 = _plus_1 + ": ";
                String _string = Integer.valueOf(node.getStartLine()).toString();
                String _plus_3 = _plus_2 + _string;
                String _plus_4 = _plus_3 + "\">";
                message = _message + _plus_4;
                if (size > 1 && i < size - 1) {
                    String _message_1 = message;
                    message = _message_1 + ", ";
                }
                ++i;
            }
            String _message_2 = message;
            message = _message_2 + "!";
            ICompositeNode node_1 = NodeModelUtils.getNode(detailDef);
            String _string_1 = LoggingInterface.MessageClass.STYLE.toString();
            String _string_2 = Integer.valueOf(node_1.getStartLine()).toString();
            String _string_3 = Integer.valueOf(node_1.getStartLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_5 = "6.10, " + _methodName;
            this.warning(message, (EObject)detailDef, null, _string_1, _string_2, _string_3, _plus_5);
        }
    }

    private boolean checkIdentifier(String name, TTCN3Reference definition, HashMap<String, List<TTCN3Reference>> ids) {
        boolean _xblockexpression = false;
        boolean res = false;
        boolean _containsKey = ids.containsKey(name);
        if (_containsKey) {
            ids.get(name).add(definition);
            res = true;
        } else {
            ArrayList<TTCN3Reference> list = CollectionLiterals.newArrayList(definition);
            ids.put(name, list);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Check
    public void checkZeroReferencedModuleDefinitions(ModuleDefinition definition) {
        boolean _not;
        boolean _isCheckZeroReferencedModuleDefinitions = this.activeProfile.isCheckZeroReferencedModuleDefinitions();
        boolean bl = _not = !_isCheckZeroReferencedModuleDefinitions;
        if (_not) {
            return;
        }
        TTCN3Module parentModule = TTCN3ScopeHelper.findDesiredParent(definition, TTCN3Module.class);
        Pattern zeroReferencedModuleDefinitionsExcludedPattern = Pattern.compile(this.activeProfile.getZeroReferencedModuleDefinitionsExcludedRegExp());
        Matcher zeroReferencedModuleDefinitionsExcludedMatcher = zeroReferencedModuleDefinitionsExcludedPattern.matcher(parentModule.getName());
        boolean _matches = zeroReferencedModuleDefinitionsExcludedMatcher.matches();
        if (_matches) {
            return;
        }
        TTCN3Reference detailDef = null;
        boolean notReferenced = false;
        boolean showEndLine = false;
        EObject _def = definition.getDef();
        if (_def instanceof ConstDef) {
            ConstList _defs;
            EObject _def_1 = definition.getDef();
            ConstList constDefList = _defs = ((ConstDef)_def_1).getDefs();
            EList<SingleConstDef> _list = constDefList.getList();
            for (SingleConstDef d : _list) {
                notReferenced = this.isUnreferenced(d, parentModule, true);
                detailDef = d;
            }
        } else {
            EObject _def_2 = definition.getDef();
            if (_def_2 instanceof ModuleParDef) {
                boolean _notEquals;
                EObject _def_3 = definition.getDef();
                ModulePar _param = ((ModuleParDef)_def_3).getParam();
                boolean bl2 = _notEquals = !Objects.equals(_param, null);
                if (_notEquals) {
                    EObject _def_4 = definition.getDef();
                    EList<ModuleParameter> _params = ((ModuleParDef)_def_4).getParam().getList().getParams();
                    for (ModuleParameter p : _params) {
                        notReferenced = this.isUnreferenced(p, parentModule, true);
                        detailDef = p;
                    }
                } else {
                    boolean _notEquals_1;
                    EObject _def_5 = definition.getDef();
                    MultitypedModuleParList _multitypeParam = ((ModuleParDef)_def_5).getMultitypeParam();
                    boolean bl3 = _notEquals_1 = !Objects.equals(_multitypeParam, null);
                    if (_notEquals_1) {
                        EObject _def_6 = definition.getDef();
                        EList<ModulePar> _params_1 = ((ModuleParDef)_def_6).getMultitypeParam().getParams();
                        for (ModulePar p_1 : _params_1) {
                            EList<ModuleParameter> _params_2 = p_1.getList().getParams();
                            for (ModuleParameter pa : _params_2) {
                                notReferenced = this.isUnreferenced(pa, parentModule, true);
                                detailDef = pa;
                            }
                        }
                    }
                }
            } else {
                EObject _def_7 = definition.getDef();
                if (_def_7 instanceof FunctionDef) {
                    notReferenced = this.isUnreferenced(definition.getDef(), parentModule, true);
                    EObject _def_8 = definition.getDef();
                    detailDef = (FunctionDef)_def_8;
                } else {
                    EObject _def_9 = definition.getDef();
                    if (_def_9 instanceof ExtFunctionDef) {
                        notReferenced = this.isUnreferenced(definition.getDef(), parentModule, true);
                        EObject _def_10 = definition.getDef();
                        detailDef = (ExtFunctionDef)_def_10;
                    } else {
                        EObject _def_11 = definition.getDef();
                        if (_def_11 instanceof TemplateDef) {
                            EObject _def_12 = definition.getDef();
                            notReferenced = this.isUnreferenced(((TemplateDef)_def_12).getBase(), parentModule, true);
                            EObject _def_13 = definition.getDef();
                            detailDef = ((TemplateDef)_def_13).getBase();
                        } else {
                            EObject _def_14 = definition.getDef();
                            if (_def_14 instanceof SignatureDef) {
                                notReferenced = this.isUnreferenced(definition.getDef(), parentModule, true);
                                EObject _def_15 = definition.getDef();
                                detailDef = (SignatureDef)_def_15;
                            } else {
                                EObject _def_16 = definition.getDef();
                                if (_def_16 instanceof TestcaseDef) {
                                    notReferenced = this.isUnreferenced(definition.getDef(), parentModule, true);
                                    EObject _def_17 = definition.getDef();
                                    detailDef = (TestcaseDef)_def_17;
                                } else {
                                    EObject _def_18 = definition.getDef();
                                    if (_def_18 instanceof AltstepDef) {
                                        notReferenced = this.isUnreferenced(definition.getDef(), parentModule, true);
                                        EObject _def_19 = definition.getDef();
                                        detailDef = (AltstepDef)_def_19;
                                    } else {
                                        EObject _def_20 = definition.getDef();
                                        if (_def_20 instanceof TypeDef) {
                                            boolean _notEquals_2;
                                            EObject _def_21 = definition.getDef();
                                            TypeDefBody body = ((TypeDef)_def_21).getBody();
                                            StructuredTypeDef _structured = body.getStructured();
                                            boolean bl4 = _notEquals_2 = !Objects.equals(_structured, null);
                                            if (_notEquals_2) {
                                                if (!Objects.equals(body.getStructured().getRecordOf(), null) && body.getStructured().getRecordOf() instanceof RecordOfDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getRecordOf(), parentModule, true);
                                                    RecordOfDef _recordOf = body.getStructured().getRecordOf();
                                                    detailDef = (RecordOfDefNamed)_recordOf;
                                                } else if (!Objects.equals(body.getStructured().getSetOf(), null) && body.getStructured().getSetOf() instanceof SetOfDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getSetOf(), parentModule, true);
                                                    SetOfDef _setOf = body.getStructured().getSetOf();
                                                    detailDef = (SetOfDefNamed)_setOf;
                                                } else if (!Objects.equals(body.getStructured().getRecord(), null) && body.getStructured().getRecord() instanceof RecordDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getRecord(), parentModule, true);
                                                    RecordDef _record = body.getStructured().getRecord();
                                                    detailDef = (RecordDefNamed)_record;
                                                } else if (!Objects.equals(body.getStructured().getUnion(), null) && body.getStructured().getUnion() instanceof UnionDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getUnion(), parentModule, true);
                                                    UnionDef _union = body.getStructured().getUnion();
                                                    detailDef = (UnionDefNamed)_union;
                                                } else if (!Objects.equals(body.getStructured().getSet(), null) && body.getStructured().getSet() instanceof SetDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getSet(), parentModule, true);
                                                    SetDef _set = body.getStructured().getSet();
                                                    detailDef = (SetDefNamed)_set;
                                                } else if (!Objects.equals(body.getStructured().getPort(), null) && body.getStructured().getPort() instanceof PortDef) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getPort(), parentModule, true);
                                                    PortDef _port = body.getStructured().getPort();
                                                    detailDef = _port;
                                                    showEndLine = true;
                                                } else if (!Objects.equals(body.getStructured().getComponent(), null) && body.getStructured().getComponent() instanceof ComponentDef) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getComponent(), parentModule, true);
                                                    ComponentDef _component = body.getStructured().getComponent();
                                                    detailDef = _component;
                                                } else if (!Objects.equals(body.getStructured().getEnumDef(), null) && body.getStructured().getEnumDef() instanceof EnumDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getStructured().getEnumDef(), parentModule, true);
                                                    EnumDef _enumDef = body.getStructured().getEnumDef();
                                                    detailDef = (EnumDefNamed)_enumDef;
                                                }
                                            } else {
                                                SubTypeDef _sub_1;
                                                boolean _notEquals_3;
                                                SubTypeDef _sub = body.getSub();
                                                boolean bl5 = _notEquals_3 = !Objects.equals(_sub, null);
                                                if (_notEquals_3 && (_sub_1 = body.getSub()) instanceof SubTypeDefNamed) {
                                                    notReferenced = this.isUnreferenced(body.getSub(), parentModule, true);
                                                    SubTypeDef _sub_2 = body.getSub();
                                                    detailDef = (SubTypeDefNamed)_sub_2;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (notReferenced) {
            this.statistics.incrementCountStyle();
            String _name = detailDef.getName();
            String _plus = "Definition for \"" + _name;
            String message = _plus + "\" is never referenced!";
            ICompositeNode node = NodeModelUtils.getNode(detailDef);
            String endLine = "";
            endLine = showEndLine ? Integer.valueOf(node.getEndLine()).toString() : Integer.valueOf(node.getStartLine()).toString();
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_1 = "6.17, " + _methodName;
            this.warning(message, (EObject)detailDef, null, _string, _string_1, endLine, _plus_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUnreferenced(EObject type, TTCN3Module parent, boolean searchAllImports) {
        HashSet<EObject> target = CollectionLiterals.newHashSet(type);
        boolean found = TTCN3ReferenceHelper.isReferenced2(parent, target);
        if (searchAllImports && !found) {
            Multimap<TTCN3Module, TTCN3Module> multimap = TTCN3GlobalScopeProvider.IMPORTED_FROM;
            synchronized (multimap) {
                boolean _containsKey = TTCN3GlobalScopeProvider.IMPORTED_FROM.containsKey(parent);
                if (_containsKey) {
                    Collection<TTCN3Module> list = TTCN3GlobalScopeProvider.IMPORTED_FROM.get(parent);
                    int _size = list.size();
                    int _minus = _size - 1;
                    IntegerRange _upTo = new IntegerRange(0, _minus);
                    for (Integer i : _upTo) {
                        boolean _isReferenced2 = TTCN3ReferenceHelper.isReferenced2(((TTCN3Module[])Conversions.unwrapArray(list, TTCN3Module.class))[i], target);
                        if (!_isReferenced2) continue;
                        return false;
                    }
                }
            }
        }
        if (!found) return true;
        return false;
    }

    @Check
    public void checkNoZeroOrMultipleFieldsInUnionTemplates(TemplateDef template) {
        boolean _tripleNotEquals;
        boolean _not;
        boolean _isCheckNoZeroOrMultipleFieldsInUnionTemplates = this.activeProfile.isCheckNoZeroOrMultipleFieldsInUnionTemplates();
        boolean bl = _not = !_isCheckNoZeroOrMultipleFieldsInUnionTemplates;
        if (_not) {
            return;
        }
        TypeReference _ref = template.getBase().getType().getRef();
        boolean bl2 = _tripleNotEquals = _ref != null;
        if (_tripleNotEquals) {
            EObject type;
            SingleExpression expr = template.getBody().getSimple().getExpr();
            if (expr instanceof Value) {
                boolean _tripleNotEquals_1;
                PredefinedValue _predef = ((Value)expr).getPredef();
                boolean bl3 = _tripleNotEquals_1 = _predef != null;
                if (_tripleNotEquals_1) {
                    boolean _tripleNotEquals_2;
                    String _omit = ((Value)expr).getPredef().getOmit();
                    boolean bl4 = _tripleNotEquals_2 = _omit != null;
                    if (_tripleNotEquals_2) {
                        return;
                    }
                }
            }
            EObject originalType = type = TTCN3ScopeHelper.getReferencedOrNestedTypeWithTail(template.getBase().getType().getRef());
            if (type instanceof ReferencedType) {
                originalType = TTCN3ScopeHelper.findOriginalType((ReferencedType)type);
            }
            if (!(type instanceof RecordOfDefNamed) && !(type instanceof SetOfDefNamed) && (originalType instanceof NestedUnionDef || originalType instanceof UnionDefNamed)) {
                Guard guard = new Guard();
                ArrayList<FieldReference> referencedFields = new ArrayList<FieldReference>();
                this.collectAssignedFieldSpecifications(template, referencedFields, true, guard);
                if (!guard.stop) {
                    boolean _equals;
                    int _size = referencedFields.size();
                    boolean bl5 = _equals = _size == 0;
                    if (_equals) {
                        this.statistics.incrementCountStyle();
                        String _name = template.getBase().getName();
                        String _plus = "At lest one field shall be specified in union template \"" + _name;
                        String message = _plus + "\"!";
                        ICompositeNode node = NodeModelUtils.getNode(expr);
                        String _string = LoggingInterface.MessageClass.STYLE.toString();
                        String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                        String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                        String _methodName = MiscTools.getMethodName();
                        String _plus_1 = "6.19, " + _methodName;
                        this.warning(message, null, _string, _string_1, _string_2, _plus_1);
                    } else {
                        boolean _greaterThan;
                        int _size_1 = IterableExtensions.toSet(referencedFields).size();
                        boolean bl6 = _greaterThan = _size_1 > 1;
                        if (_greaterThan) {
                            this.statistics.incrementCountStyle();
                            String _name_1 = template.getBase().getName();
                            String _plus_2 = "More than one field specified in union template \"" + _name_1;
                            String message_1 = _plus_2 + "\"!";
                            ICompositeNode node_1 = NodeModelUtils.getNode(expr);
                            String _string_3 = LoggingInterface.MessageClass.STYLE.toString();
                            String _string_4 = Integer.valueOf(node_1.getStartLine()).toString();
                            String _string_5 = Integer.valueOf(node_1.getEndLine()).toString();
                            String _methodName_1 = MiscTools.getMethodName();
                            String _plus_3 = "6.19, " + _methodName_1;
                            this.warning(message_1, null, _string_3, _string_4, _string_5, _plus_3);
                        }
                    }
                }
            }
        }
    }

    @Check
    public void checkNoUninitializedFieldsInTemplates(TemplateDef template) {
        boolean _tripleNotEquals;
        boolean _not;
        boolean _isCheckNoUninitializedFieldsInTemplates = this.activeProfile.isCheckNoUninitializedFieldsInTemplates();
        boolean bl = _not = !_isCheckNoUninitializedFieldsInTemplates;
        if (_not) {
            return;
        }
        TypeReference _ref = template.getBase().getType().getRef();
        boolean bl2 = _tripleNotEquals = _ref != null;
        if (_tripleNotEquals) {
            EObject type;
            SingleExpression expr = template.getBody().getSimple().getExpr();
            if (expr instanceof Value) {
                boolean _tripleNotEquals_1;
                PredefinedValue _predef = ((Value)expr).getPredef();
                boolean bl3 = _tripleNotEquals_1 = _predef != null;
                if (_tripleNotEquals_1) {
                    boolean _tripleNotEquals_2;
                    String _omit = ((Value)expr).getPredef().getOmit();
                    boolean bl4 = _tripleNotEquals_2 = _omit != null;
                    if (_tripleNotEquals_2) {
                        return;
                    }
                }
            }
            EObject originalType = type = TTCN3ScopeHelper.getReferencedOrNestedTypeWithTail(template.getBase().getType().getRef());
            if (type instanceof ReferencedType) {
                originalType = TTCN3ScopeHelper.findOriginalType((ReferencedType)type);
            }
            if (!(originalType instanceof NestedUnionDef || originalType instanceof UnionDefNamed || type instanceof RecordOfDefNamed || type instanceof SetOfDefNamed)) {
                Guard guard = new Guard();
                Iterable<FieldReference> fields = TTCN3ScopeHelper.getFields(type);
                ArrayList<FieldReference> referencedFields = new ArrayList<FieldReference>();
                this.collectAssignedFieldSpecifications(template, referencedFields, true, guard);
                if (!guard.stop) {
                    this.checkNoUninitializedFieldsInTemplates(referencedFields, fields, template.getBase().getName(), expr);
                }
            }
        }
    }

    protected void collectAssignedFieldSpecifications(TemplateDef template, ArrayList<FieldReference> referencedFields, boolean recursive, Guard guard) {
        SingleExpression expr = template.getBody().getSimple().getExpr();
        if (expr instanceof FieldExpressionList) {
            Functions.Function1<FieldExpressionSpec, FieldReference> _function = it -> it.getFieldRef();
            referencedFields.addAll(ListExtensions.map(((FieldExpressionList)expr).getSpecs(), _function));
        } else if (expr instanceof Value) {
            boolean _tripleNotEquals;
            ReferencedValue _ref = ((Value)expr).getRef();
            boolean bl = _tripleNotEquals = _ref != null;
            if (_tripleNotEquals) {
                RefValue value = TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef());
                if (value instanceof BaseTemplate) {
                    EObject assigned = ((BaseTemplate)value).eContainer();
                    if (assigned instanceof TemplateDef) {
                        this.collectAssignedFieldSpecifications((TemplateDef)assigned, referencedFields, this.activeProfile.isCheckNoUninitializedFieldsInTemplatesRecursion(), guard);
                    }
                } else {
                    guard.stop = true;
                }
            }
        } else if (expr instanceof OpCall) {
            FunctionRef ref = ((OpCall)expr).getFunction().getRef();
            if (ref instanceof BaseTemplate) {
                EObject assigned_1 = ((BaseTemplate)ref).eContainer();
                if (assigned_1 instanceof TemplateDef) {
                    this.collectAssignedFieldSpecifications((TemplateDef)assigned_1, referencedFields, this.activeProfile.isCheckNoUninitializedFieldsInTemplatesRecursion(), guard);
                }
            } else {
                guard.stop = true;
            }
        } else if (expr instanceof ArrayOrMixedExpression) {
            boolean _tripleEquals;
            ArrayElementExpressionList _list = ((ArrayOrMixedExpression)expr).getList();
            boolean bl = _tripleEquals = _list == null;
            if (!_tripleEquals) {
                boolean _tripleNotEquals_1;
                TypeReference _ref_1 = template.getBase().getType().getRef();
                boolean bl2 = _tripleNotEquals_1 = _ref_1 != null;
                if (_tripleNotEquals_1) {
                    int _size_1;
                    boolean _lessThan;
                    EObject type = TTCN3ScopeHelper.getReferencedOrNestedTypeWithTail(template.getBase().getType().getRef());
                    Iterable<FieldReference> fields = TTCN3ScopeHelper.getFields(type);
                    int _size = ((ArrayOrMixedExpression)expr).getList().getExpr().size();
                    boolean bl3 = _lessThan = _size < (_size_1 = IterableExtensions.size(fields));
                    if (_lessThan) {
                        List<FieldReference> filteredFields = IterableExtensions.toList(fields).subList(0, ((ArrayOrMixedExpression)expr).getList().getExpr().size());
                        referencedFields.addAll(filteredFields);
                    } else {
                        Iterables.addAll(referencedFields, fields);
                    }
                }
            }
        }
        if (template.getDerived() != null && recursive) {
            EObject _eContainer = template.getDerived().getTemplate().eContainer();
            TemplateDef derivedTemplate = (TemplateDef)_eContainer;
            this.collectAssignedFieldSpecifications(derivedTemplate, referencedFields, this.activeProfile.isCheckNoUninitializedFieldsInTemplatesRecursion(), guard);
        }
    }

    @Check
    public void checkNoUninitializedFieldsInTemplates(VarInstance variable) {
    }

    @Check
    public void checkNoUninitializedFieldsInTemplates(Assignment assignment) {
    }

    protected void checkNoUninitializedFieldsInTemplates(List<FieldReference> referencedFields, Iterable<FieldReference> fields, String template, EObject expr) {
        for (FieldReference field : fields) {
            boolean _not;
            boolean _contains = referencedFields.contains(field);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            this.statistics.incrementCountStyle();
            String _name = field.getName();
            String _plus = "Field \"" + _name;
            String _plus_1 = _plus + "\" not initialised in template \"";
            String _plus_2 = _plus_1 + template;
            String message = _plus_2 + "\"!";
            ICompositeNode node = NodeModelUtils.getNode(expr);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_3 = "6.16, " + _methodName;
            this.warning(message, null, _string, _string_1, _string_2, _plus_3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Check
    public void checkNoValueOfForValues(ValueofOp templateOp) {
        boolean _isCheckNoValueOfForValues = this.activeProfile.isCheckNoValueOfForValues();
        if (!_isCheckNoValueOfForValues) return;
        boolean bl = false;
        boolean _not = bl;
        if (_not) {
            return;
        }
        if (templateOp.getTemplate().getTemplate().getSimple() == null) return;
        if (templateOp.getTemplate().getTemplate().getSimple().getExpr() == null) {
            return;
        }
        String target = "";
        String prefix = "";
        SingleExpression expr = templateOp.getTemplate().getTemplate().getSimple().getExpr();
        if (expr instanceof Value) {
            RefValueHead _target;
            ReferencedValue _ref = ((Value)expr).getRef();
            if (_ref == null) return;
            boolean bl2 = true;
            boolean _tripleNotEquals = bl2;
            if (!_tripleNotEquals) return;
            RefValue _referencedValue = TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef());
            if (_referencedValue instanceof SingleTempVarInstance) {
                return;
            }
            RefValue _referencedValue_1 = TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef());
            if (_referencedValue_1 instanceof FormalTemplatePar) {
                return;
            }
            RefValue _referencedValue_2 = TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef());
            if (_referencedValue_2 instanceof BaseTemplate) {
                return;
            }
            if (TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef()) instanceof StructFieldDef || TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef()) instanceof UnionFieldDef || TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef()) == null) {
                if (((Value)expr).getRef().getHead().getTarget() instanceof SingleTempVarInstance) return;
                if (((Value)expr).getRef().getHead().getTarget() instanceof FormalTemplatePar) {
                    return;
                }
            }
            if ((_target = ((Value)expr).getRef().getHead().getTarget()) instanceof RefValue) {
                RefValueHead _target_1 = ((Value)expr).getRef().getHead().getTarget();
                target = ((RefValue)_target_1).getName();
            } else {
                target = TTCN3ScopeHelper.getReferencedValue(((Value)expr).getRef()).getName();
            }
        } else {
            boolean _tripleNotEquals_1;
            if (!(expr instanceof OpCall)) return;
            FunctionInstance _function = ((OpCall)expr).getFunction();
            boolean bl3 = _tripleNotEquals_1 = _function != null;
            if (_tripleNotEquals_1) {
                FunctionRef _ref_1 = ((OpCall)expr).getFunction().getRef();
                if (_ref_1 instanceof FunctionDef) {
                    boolean _tripleNotEquals_3;
                    boolean _tripleNotEquals_2;
                    FunctionRef _ref_2 = ((OpCall)expr).getFunction().getRef();
                    ReturnType returnType = ((FunctionDef)_ref_2).getReturnType();
                    String _template = returnType.getTemplate();
                    if (_template != null) {
                        return;
                    }
                    boolean bl4 = _tripleNotEquals_2 = false;
                    if (_tripleNotEquals_2) {
                        return;
                    }
                    RestrictedTemplate _restricted = returnType.getRestricted();
                    if (_restricted != null) {
                        return;
                    }
                    boolean bl5 = _tripleNotEquals_3 = false;
                    if (_tripleNotEquals_3) {
                        return;
                    }
                    target = ((OpCall)expr).getFunction().getRef().getName();
                    prefix = "returned by ";
                } else {
                    FunctionRef _ref_3 = ((OpCall)expr).getFunction().getRef();
                    if (_ref_3 instanceof BaseTemplate) {
                        return;
                    }
                }
            }
        }
        this.statistics.incrementCountStyle();
        String message = "ValueOf operation is used on a value " + prefix + "\"" + target + "\"!";
        ICompositeNode node = NodeModelUtils.getNode(templateOp);
        String _string = LoggingInterface.MessageClass.STYLE.toString();
        String _string_1 = Integer.valueOf(node.getStartLine()).toString();
        String _string_2 = Integer.valueOf(node.getEndLine()).toString();
        String _methodName = MiscTools.getMethodName();
        String _plus = "6.14, " + _methodName;
        this.warning(message, null, _string, _string_1, _string_2, _plus);
    }

    @Check
    public void checkNoInlineTemplates(TemplateInstance template) {
        boolean _not;
        boolean _isCheckNoInlineTemplates = this.activeProfile.isCheckNoInlineTemplates();
        boolean bl = _not = !_isCheckNoInlineTemplates;
        if (_not) {
            return;
        }
        Type _type = template.getType();
        boolean _equals = Objects.equals(_type, null);
        if (_equals) {
            return;
        }
        this.statistics.incrementCountStyle();
        ICompositeNode node = NodeModelUtils.getNode(template);
        String _string = LoggingInterface.MessageClass.STYLE.toString();
        String _string_1 = Integer.valueOf(node.getStartLine()).toString();
        String _string_2 = Integer.valueOf(node.getEndLine()).toString();
        String _methodName = MiscTools.getMethodName();
        String _plus = "6.13, " + _methodName;
        this.warning("Inline Template is used!", null, _string, _string_1, _string_2, _plus);
    }

    @Check
    public void checkNoOverSpecificRunsOnClauses(RunsOnSpec runsOn) {
        boolean _isReferencedComponentSpec;
        boolean _not;
        boolean _isCheckNoOverSpecificRunsOnClauses = this.activeProfile.isCheckNoOverSpecificRunsOnClauses();
        boolean bl = _not = !_isCheckNoOverSpecificRunsOnClauses;
        if (_not) {
            return;
        }
        EObject parent = runsOn.eContainer();
        ComponentDef component = null;
        ArrayList<TTCN3Reference> consideredAltOrFunc = CollectionLiterals.newArrayList();
        if (parent instanceof AltstepDef) {
            boolean _not_1;
            component = ((AltstepDef)parent).getSpec().getComponent();
            boolean _specifiedComponentResolved = this.specifiedComponentResolved((TTCN3Reference)parent, component);
            boolean bl2 = _not_1 = !_specifiedComponentResolved;
            if (_not_1) {
                return;
            }
        } else if (parent instanceof FunctionDef) {
            boolean _not_2;
            component = ((FunctionDef)parent).getRunsOn().getComponent();
            boolean _specifiedComponentResolved_1 = this.specifiedComponentResolved((TTCN3Reference)parent, component);
            boolean bl3 = _not_2 = !_specifiedComponentResolved_1;
            if (_not_2) {
                return;
            }
        } else {
            return;
        }
        boolean overSpecifiedFirstLevel = !(_isReferencedComponentSpec = this.isReferencedComponentSpec(component, parent));
        String _name = ((TTCN3Reference)parent).getName();
        String _plus = "Definition for \"" + _name;
        String message = _plus + "\" contains an over specific runs on clause!";
        ICompositeNode node = NodeModelUtils.getNode(parent);
        if (overSpecifiedFirstLevel) {
            boolean overSpecified = true;
            boolean _isRecursionInCheckNoOverSpecificRunsOnClauses = this.activeProfile.isRecursionInCheckNoOverSpecificRunsOnClauses();
            if (_isRecursionInCheckNoOverSpecificRunsOnClauses) {
                boolean _not_3;
                consideredAltOrFunc.add((TTCN3Reference)parent);
                boolean _isReferencedInHierarchy = this.isReferencedInHierarchy((TTCN3Reference)parent, consideredAltOrFunc);
                overSpecified = _not_3 = !_isReferencedInHierarchy;
            }
            if (overSpecified) {
                this.statistics.incrementCountStyle();
                this.warning(message, parent, null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getStartLine()).toString(), "6.13, checkNoOverSpecificRunsOnClauses");
            }
        }
    }

    private boolean specifiedComponentResolved(TTCN3Reference parent, ComponentDef component) {
        boolean _isNullOrEmpty = Strings.isNullOrEmpty(component.getName());
        if (_isNullOrEmpty) {
            this.statistics.incrementCountStyle();
            String _name = parent.getName();
            String _plus = "Runs on component reference of \"" + _name;
            String message = _plus + "\" cannot be resolved. It may not be possible to determine whether construct has an over-specific runs on clause!";
            ICompositeNode node = NodeModelUtils.getNode(parent);
            this.info(message, (EObject)parent, null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "6.13, checkNoOverSpecificRunsOnClauses", LoggingInterface.LogLevel.INFORMATION.toString());
            return false;
        }
        return true;
    }

    private ArrayList<TTCN3Reference> nextLevelFunctionsOrAltsteps(TTCN3Reference parent, ArrayList<TTCN3Reference> consideredAltOrFunc) {
        ArrayList<TTCN3Reference> nextLevelCheck = CollectionLiterals.newArrayList();
        Functions.Function1<FunctionInstance, FunctionRef> _function = it -> it.getRef();
        List<FunctionRef> _map = ListExtensions.map(EcoreUtil2.getAllContentsOfType(parent, FunctionInstance.class), _function);
        for (FunctionRef f : _map) {
            boolean _contains = consideredAltOrFunc.contains(f);
            if (_contains) continue;
            nextLevelCheck.add(f);
        }
        Functions.Function1<AltstepInstance, AltstepDef> _function_1 = it -> it.getRef();
        List<AltstepDef> _map_1 = ListExtensions.map(EcoreUtil2.getAllContentsOfType(parent, AltstepInstance.class), _function_1);
        for (AltstepDef a : _map_1) {
            boolean _contains_1 = consideredAltOrFunc.contains(a);
            if (_contains_1) continue;
            nextLevelCheck.add(a);
        }
        return nextLevelCheck;
    }

    private boolean isRunningOnSameComponent(TTCN3Reference parent, TTCN3Reference nextLevel) {
        ComponentDef _component_7;
        ComponentDef _component_6;
        boolean _equals_3;
        ComponentDef _component_5;
        ComponentDef _component_4;
        boolean _equals_2;
        ComponentDef _component_3;
        ComponentDef _component_2;
        boolean _equals_1;
        ComponentDef _component_1;
        ComponentDef _component;
        boolean _equals;
        return nextLevel instanceof FunctionDef ? (parent instanceof FunctionDef ? (_equals = Objects.equals(_component = ((FunctionDef)nextLevel).getRunsOn().getComponent(), _component_1 = ((FunctionDef)parent).getRunsOn().getComponent())) : parent instanceof AltstepDef && (_equals_1 = Objects.equals(_component_2 = ((FunctionDef)nextLevel).getRunsOn().getComponent(), _component_3 = ((AltstepDef)parent).getSpec().getComponent()))) : nextLevel instanceof AltstepDef && (parent instanceof FunctionDef ? (_equals_2 = Objects.equals(_component_4 = ((AltstepDef)nextLevel).getSpec().getComponent(), _component_5 = ((FunctionDef)parent).getRunsOn().getComponent())) : parent instanceof AltstepDef && (_equals_3 = Objects.equals(_component_6 = ((AltstepDef)nextLevel).getSpec().getComponent(), _component_7 = ((AltstepDef)parent).getSpec().getComponent())));
    }

    private boolean isReferencedInHierarchy(TTCN3Reference parent, ArrayList<TTCN3Reference> consideredAltOrFunc) {
        ArrayList<TTCN3Reference> nextLevelCheck = this.nextLevelFunctionsOrAltsteps(parent, consideredAltOrFunc);
        do {
            for (TTCN3Reference o : nextLevelCheck) {
                if (o instanceof FunctionDef) {
                    boolean _notEquals;
                    RunsOnSpec _runsOn = ((FunctionDef)o).getRunsOn();
                    boolean bl = _notEquals = !Objects.equals(_runsOn, null);
                    if (_notEquals) {
                        boolean _specifiedComponentResolved = this.specifiedComponentResolved(o, ((FunctionDef)o).getRunsOn().getComponent());
                        if (!_specifiedComponentResolved) continue;
                        if (this.isRunningOnSameComponent(o, parent) && this.isReferencedComponentSpec(((FunctionDef)o).getRunsOn().getComponent(), o)) {
                            return true;
                        }
                        ArrayList<TTCN3Reference> nlc = new ArrayList<TTCN3Reference>();
                        nlc.addAll(nextLevelCheck);
                        nlc.remove(o);
                        consideredAltOrFunc.addAll(nextLevelCheck);
                        ArrayList<TTCN3Reference> nlfa = this.nextLevelFunctionsOrAltsteps(o, consideredAltOrFunc);
                        nlc.addAll(nlfa);
                        nextLevelCheck = nlc;
                        continue;
                    }
                    ArrayList<TTCN3Reference> nlc_1 = new ArrayList<TTCN3Reference>();
                    nlc_1.addAll(nextLevelCheck);
                    nlc_1.remove(o);
                    nextLevelCheck = nlc_1;
                    continue;
                }
                if (o instanceof AltstepDef) {
                    boolean _notEquals_1;
                    RunsOnSpec _spec = ((AltstepDef)o).getSpec();
                    boolean bl = _notEquals_1 = !Objects.equals(_spec, null);
                    if (_notEquals_1) {
                        boolean _specifiedComponentResolved_1 = this.specifiedComponentResolved(o, ((AltstepDef)o).getSpec().getComponent());
                        if (!_specifiedComponentResolved_1) continue;
                        if (this.isRunningOnSameComponent(o, parent) && this.isReferencedComponentSpec(((AltstepDef)o).getSpec().getComponent(), o)) {
                            return true;
                        }
                        ArrayList<TTCN3Reference> nlc_2 = new ArrayList<TTCN3Reference>();
                        nlc_2.addAll(nextLevelCheck);
                        nlc_2.remove(o);
                        nlc_2.addAll(this.nextLevelFunctionsOrAltsteps(o, consideredAltOrFunc));
                        nextLevelCheck = nlc_2;
                        continue;
                    }
                    ArrayList<TTCN3Reference> nlc_3 = new ArrayList<TTCN3Reference>();
                    nlc_3.addAll(nextLevelCheck);
                    nlc_3.remove(o);
                    nextLevelCheck = nlc_3;
                    continue;
                }
                boolean _eIsProxy = o.eIsProxy();
                if (_eIsProxy) {
                    ArrayList<TTCN3Reference> nlc_4 = new ArrayList<TTCN3Reference>();
                    nlc_4.addAll(nextLevelCheck);
                    nlc_4.remove(o);
                    nextLevelCheck = nlc_4;
                    continue;
                }
                ArrayList<TTCN3Reference> nlc_5 = new ArrayList<TTCN3Reference>();
                nlc_5.addAll(nextLevelCheck);
                nlc_5.remove(o);
                nextLevelCheck = nlc_5;
            }
        } while (!Objects.equals(nextLevelCheck, null) && !nextLevelCheck.isEmpty());
        return false;
    }

    private boolean isReferencedComponentSpec(ComponentDef component, EObject parent) {
        boolean _isReferenced2;
        boolean _isEmpty;
        HashSet<EObject> variables = this.getComponentMembers(component);
        boolean _isAliasInCheckNoOverSpecificRunsOnClauses = this.activeProfile.isAliasInCheckNoOverSpecificRunsOnClauses();
        if (_isAliasInCheckNoOverSpecificRunsOnClauses && (_isEmpty = variables.isEmpty())) {
            variables.addAll(this.getDirectlyInheritedComponentMembers(component));
        }
        return _isReferenced2 = TTCN3ReferenceHelper.isReferenced2(parent, variables, false);
    }

    private HashSet<EObject> getDirectlyInheritedComponentMembers(ComponentDef component) {
        HashSet<EObject> inheritedVariables = Sets.newHashSet();
        EList<ComponentDef> _extends = component.getExtends();
        for (ComponentDef e : _extends) {
            inheritedVariables.addAll(this.getComponentMembers(e));
        }
        return inheritedVariables;
    }

    private HashSet<EObject> getInheritedComponentMembers(ComponentDef component) {
        HashSet<EObject> inheritedVariables = Sets.newHashSet();
        EList<ComponentDef> _extends = component.getExtends();
        for (ComponentDef e : _extends) {
            inheritedVariables.addAll(this.getComponentMembers(e));
            inheritedVariables.addAll(this.getInheritedComponentMembers(e));
        }
        return inheritedVariables;
    }

    private HashSet<EObject> getComponentMembers(ComponentDef component) {
        HashSet<EObject> variables = Sets.newHashSet();
        EList<ComponentDefList> _defs = component.getDefs();
        for (ComponentDefList d : _defs) {
            TempVarList _tempList;
            boolean _tripleNotEquals_5;
            boolean _tripleNotEquals_4;
            boolean _tripleNotEquals_3;
            boolean _tripleNotEquals_2;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            ComponentElementDef element = d.getElement();
            PortInstance _port = element.getPort();
            boolean bl = _tripleNotEquals = _port != null;
            if (_tripleNotEquals) {
                EList<PortElement> _instances = element.getPort().getInstances();
                for (PortElement p : _instances) {
                    variables.add(p);
                }
                continue;
            }
            ConstDef _const = element.getConst();
            boolean bl2 = _tripleNotEquals_1 = _const != null;
            if (_tripleNotEquals_1) {
                EList<SingleConstDef> _list = element.getConst().getDefs().getList();
                for (SingleConstDef c : _list) {
                    variables.add(c);
                }
                continue;
            }
            TimerInstance _timer = element.getTimer();
            boolean bl3 = _tripleNotEquals_2 = _timer != null;
            if (_tripleNotEquals_2) {
                EList<SingleVarInstance> _variables = element.getTimer().getList().getVariables();
                for (SingleVarInstance t2 : _variables) {
                    variables.add(t2);
                }
                continue;
            }
            VarInstance _variable = element.getVariable();
            boolean bl4 = _tripleNotEquals_3 = _variable != null;
            if (!_tripleNotEquals_3) continue;
            VarList _list_1 = element.getVariable().getList();
            boolean bl5 = _tripleNotEquals_4 = _list_1 != null;
            if (_tripleNotEquals_4) {
                EList<SingleVarInstance> _variables_1 = element.getVariable().getList().getVariables();
                for (SingleVarInstance v : _variables_1) {
                    variables.add(v);
                }
            }
            boolean bl6 = _tripleNotEquals_5 = (_tempList = element.getVariable().getTempList()) != null;
            if (!_tripleNotEquals_5) continue;
            EList<SingleTempVarInstance> _variables_2 = element.getVariable().getTempList().getVariables();
            for (SingleTempVarInstance tv : _variables_2) {
                variables.add(tv);
            }
        }
        return variables;
    }

    private ArrayList<TTCN3Reference> findAllParameters(EObject parent) {
        ArrayList<TTCN3Reference> paramList = CollectionLiterals.newArrayList();
        paramList.addAll(EcoreUtil2.getAllContentsOfType(parent, FormalValuePar.class));
        paramList.addAll(EcoreUtil2.getAllContentsOfType(parent, FormalTemplatePar.class));
        return paramList;
    }

    @Check
    public void checkNoUnusedFormalParameters(AltstepDef altstep) {
        boolean _isCheckNoUnusedFormalParameters = this.activeProfile.isCheckNoUnusedFormalParameters();
        if (_isCheckNoUnusedFormalParameters) {
            boolean _notEquals;
            FunctionFormalParList _params = altstep.getParams();
            boolean bl = _notEquals = !Objects.equals(_params, null);
            if (_notEquals) {
                ArrayList<TTCN3Reference> paramList = this.findAllParameters(altstep.getParams());
                this.checkNoUnusedFormalParameters(altstep, paramList);
            }
        }
    }

    @Check
    public void checkNoUnusedFormalParameters(TestcaseDef testcase) {
        boolean _isCheckNoUnusedFormalParameters = this.activeProfile.isCheckNoUnusedFormalParameters();
        if (_isCheckNoUnusedFormalParameters) {
            boolean _notEquals;
            TemplateOrValueFormalParList _parList = testcase.getParList();
            boolean bl = _notEquals = !Objects.equals(_parList, null);
            if (_notEquals) {
                ArrayList<TTCN3Reference> paramList = this.findAllParameters(testcase.getParList());
                this.checkNoUnusedFormalParameters(testcase, paramList);
            }
        }
    }

    @Check
    public void checkNoUnusedFormalParameters(FunctionDef function) {
        boolean _isCheckNoUnusedFormalParameters = this.activeProfile.isCheckNoUnusedFormalParameters();
        if (_isCheckNoUnusedFormalParameters) {
            boolean _notEquals;
            FunctionFormalParList _parameterList = function.getParameterList();
            boolean bl = _notEquals = !Objects.equals(_parameterList, null);
            if (_notEquals) {
                ArrayList<TTCN3Reference> paramList = this.findAllParameters(function.getParameterList());
                this.checkNoUnusedFormalParameters(function, paramList);
            }
        }
    }

    @Check
    public void checkNoUnusedFormalParameters(BaseTemplate template) {
        boolean _not;
        boolean _isCheckNoUnusedFormalParameters = this.activeProfile.isCheckNoUnusedFormalParameters();
        boolean bl = _not = !_isCheckNoUnusedFormalParameters;
        if (_not) {
            return;
        }
        BaseTemplate current = template;
        ArrayList baseParams = CollectionLiterals.newArrayList();
        ArrayList<TTCN3Reference> paramList = CollectionLiterals.newArrayList();
        ArrayList consideredTemplates = CollectionLiterals.newArrayList();
        consideredTemplates.add(current);
        do {
            EObject _eContainer;
            DerivedDef _derived;
            boolean _notEquals;
            boolean bl2 = _notEquals = !Objects.equals(_derived = ((TemplateDef)(_eContainer = current.eContainer())).getDerived(), null);
            if (_notEquals) {
                boolean _notEquals_1;
                EObject _eContainer_1 = current.eContainer();
                boolean _contains = consideredTemplates.contains(((TemplateDef)_eContainer_1).getDerived().getTemplate());
                if (_contains) {
                    this.statistics.incrementCountStyle();
                    String _name = template.getName();
                    String _plus = "Possible cyclic modifies sequence: \"" + _name;
                    String message = _plus + "\". Skipping...";
                    ICompositeNode node = NodeModelUtils.getNode(template);
                    String _string = LoggingInterface.MessageClass.STYLE.toString();
                    String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                    String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                    String _methodName = MiscTools.getMethodName();
                    String _plus_1 = "6.13, " + _methodName;
                    this.info(message, (EObject)template, null, _string, _string_1, _string_2, _plus_1, LoggingInterface.LogLevel.INFORMATION.toString());
                    current = null;
                    continue;
                }
                EObject _eContainer_2 = current.eContainer();
                boolean bl3 = _notEquals_1 = !Objects.equals(current = ((TemplateDef)_eContainer_2).getDerived().getTemplate(), null);
                if (!_notEquals_1) continue;
                consideredTemplates.add(current);
                baseParams.addAll(this.findAllParameters(current.getParList()));
                continue;
            }
            current = null;
        } while (!Objects.equals(current, null));
        ArrayList<TTCN3Reference> _findAllParameters = this.findAllParameters(template.getParList());
        for (TTCN3Reference p : _findAllParameters) {
            boolean _equals;
            Functions.Function1<TTCN3Reference, Boolean> _function = it -> {
                String _name_1 = it.getName();
                String _name_2 = p.getName();
                return Objects.equals(_name_1, _name_2);
            };
            int _size = IterableExtensions.size(IterableExtensions.filter(baseParams, _function));
            boolean bl4 = _equals = _size == 0;
            if (!_equals) continue;
            paramList.add(p);
        }
        this.checkNoUnusedFormalParameters(template, paramList);
    }

    private void checkNoUnusedFormalParameters(EObject parent, ArrayList<TTCN3Reference> params) {
        TTCN3Module module = TTCN3ScopeHelper.findDesiredParent(parent, TTCN3Module.class);
        List<TimerRefOrAll> listAll = EcoreUtil2.eAllOfType(parent, TimerRefOrAll.class);
        List<TimerRefOrAny> listAny = EcoreUtil2.eAllOfType(parent, TimerRefOrAny.class);
        boolean referenced = true;
        for (TTCN3Reference p : params) {
            boolean _equals;
            ICompositeNode nodeRef;
            referenced = true;
            boolean _isUnreferenced = this.isUnreferenced(p, module, false);
            if (_isUnreferenced) {
                referenced = false;
            }
            for (TimerRefOrAll t2 : listAll) {
                nodeRef = NodeModelUtils.getNode(t2);
                _equals = p.getName().equals(nodeRef.getText().trim());
                if (!_equals) continue;
                referenced = true;
            }
            for (TimerRefOrAny t_1 : listAny) {
                nodeRef = NodeModelUtils.getNode(t_1);
                _equals = p.getName().equals(nodeRef.getText().trim());
                if (!_equals) continue;
                referenced = true;
            }
            if (referenced) continue;
            this.statistics.incrementCountStyle();
            String _name = p.getName();
            String _plus = "Formal parameter \"" + _name;
            String _plus_1 = _plus + "\" in definition for \"";
            String _name_1 = ((TTCN3Reference)parent).getName();
            String _plus_2 = _plus_1 + _name_1;
            String message = _plus_2 + "\" is never used!";
            ICompositeNode node = NodeModelUtils.getNode(p);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_3 = "6.11, " + _methodName;
            this.warning(message, (EObject)p, null, _string, _string_1, _string_2, _plus_3);
        }
    }

    @Check
    public void checkNoUnusedLocalDefinitions(SingleVarInstance variable) {
        boolean _not;
        boolean _isCheckNoUnusedLocalDefinitions = this.activeProfile.isCheckNoUnusedLocalDefinitions();
        boolean bl = _not = !_isCheckNoUnusedLocalDefinitions;
        if (_not) {
            return;
        }
        this.checkNoUnusedLocalDefinitionsAll(variable);
    }

    @Check
    public void checkNoUnusedLocalDefinitions(SingleConstDef variable) {
        boolean _not;
        boolean _isCheckNoUnusedLocalDefinitions = this.activeProfile.isCheckNoUnusedLocalDefinitions();
        boolean bl = _not = !_isCheckNoUnusedLocalDefinitions;
        if (_not) {
            return;
        }
        this.checkNoUnusedLocalDefinitionsAll(variable);
    }

    @Check
    public void checkNoUnusedLocalDefinitions(SingleTempVarInstance variable) {
        boolean _not;
        boolean _isCheckNoUnusedLocalDefinitions = this.activeProfile.isCheckNoUnusedLocalDefinitions();
        boolean bl = _not = !_isCheckNoUnusedLocalDefinitions;
        if (_not) {
            return;
        }
        this.checkNoUnusedLocalDefinitionsAll(variable);
    }

    @Check
    public void checkNoUnusedLocalDefinitions(BaseTemplate variable) {
        boolean _not;
        boolean _isCheckNoUnusedLocalDefinitions = this.activeProfile.isCheckNoUnusedLocalDefinitions();
        boolean bl = _not = !_isCheckNoUnusedLocalDefinitions;
        if (_not) {
            return;
        }
        this.checkNoUnusedLocalDefinitionsAll(variable);
    }

    @Check
    public void checkNoUnusedLocalDefinitions(PortElement variable) {
        boolean _not;
        boolean _isCheckNoUnusedLocalDefinitions = this.activeProfile.isCheckNoUnusedLocalDefinitions();
        boolean bl = _not = !_isCheckNoUnusedLocalDefinitions;
        if (_not) {
            return;
        }
        this.checkNoUnusedLocalDefinitionsAll(variable);
    }

    private void checkNoUnusedLocalDefinitionsAll(TTCN3Reference variable) {
        boolean isComponentDefinition;
        TTCN3Module module;
        boolean unreferenced;
        ComponentDef component = TTCN3ScopeHelper.findDesiredParent(variable, ComponentDef.class);
        ModuleControlBody parentControl = TTCN3ScopeHelper.findDesiredParent(variable, ModuleControlBody.class);
        TTCN3Reference parent = this.variableLocal(variable);
        if (!(Objects.equals(parent, null) && Objects.equals(parentControl, null) || !(unreferenced = this.isUnreferenced(variable, module = TTCN3ScopeHelper.findDesiredParent(variable, TTCN3Module.class), isComponentDefinition = !Objects.equals(component, null))))) {
            boolean _notEquals;
            this.statistics.incrementCountStyle();
            String varName = "Module Control Part";
            boolean bl = _notEquals = !Objects.equals(parent, null);
            if (_notEquals) {
                varName = parent.getName();
            }
            String _name = variable.getName();
            String _plus = "Local definition for \"" + _name;
            String _plus_1 = _plus + "\" in definition of \"";
            String _plus_2 = _plus_1 + varName;
            String message = _plus_2 + "\" is never used!";
            ICompositeNode node = NodeModelUtils.getNode(variable);
            this.warning(message, (EObject)variable, null, LoggingInterface.MessageClass.STYLE.toString(), Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "6.11, checkNoUnusedLocalDefinitions");
        }
    }

    private TTCN3Reference variableLocal(EObject variable) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        FunctionDef parentFunction = TTCN3ScopeHelper.findDesiredParent(variable, FunctionDef.class);
        AltstepDef parentAltStep = TTCN3ScopeHelper.findDesiredParent(variable, AltstepDef.class);
        ComponentDef parentComponent = TTCN3ScopeHelper.findDesiredParent(variable, ComponentDef.class);
        TestcaseDef parentTestcase = TTCN3ScopeHelper.findDesiredParent(variable, TestcaseDef.class);
        boolean bl = _notEquals = !Objects.equals(parentFunction, null);
        if (_notEquals) {
            return parentFunction;
        }
        boolean bl2 = _notEquals_1 = !Objects.equals(parentAltStep, null);
        if (_notEquals_1) {
            return parentAltStep;
        }
        boolean bl3 = _notEquals_2 = !Objects.equals(parentComponent, null);
        if (_notEquals_2) {
            return parentComponent;
        }
        boolean bl4 = _notEquals_3 = !Objects.equals(parentTestcase, null);
        if (_notEquals_3) {
            return parentTestcase;
        }
        return null;
    }

    @Check
    public void checkNoLiterals(PredefinedValue value) {
        boolean _not;
        boolean _isCheckNoLiterals = this.activeProfile.isCheckNoLiterals();
        boolean bl = _not = !_isCheckNoLiterals;
        if (_not) {
            return;
        }
        ModuleParDef parentModulePar = TTCN3ScopeHelper.findDesiredParent(value, ModuleParDef.class);
        ConstDef parentConstDef = TTCN3ScopeHelper.findDesiredParent(value, ConstDef.class);
        TemplateDef parentTemplate = TTCN3ScopeHelper.findDesiredParent(value, TemplateDef.class);
        if (!(!Objects.equals(parentModulePar, null) || !Objects.equals(parentConstDef, null) || !Objects.equals(parentTemplate, null) || Objects.equals(value.getBstring(), null) && Objects.equals(value.getInteger(), null) && Objects.equals(value.getFloat(), null) && Objects.equals(value.getHstring(), null) && Objects.equals(value.getOstring(), null) && Objects.equals(value.getCharString(), null))) {
            this.statistics.incrementCountStyle();
            ICompositeNode node = NodeModelUtils.getNode(value);
            String _string = LoggingInterface.MessageClass.STYLE.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "6.12, " + _methodName;
            this.warning("Literal value is used!", (EObject)value, null, _string, _string_1, _string_2, _plus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Check
    public void checkNoUnusedImports(TTCN3Module module) {
        boolean _not;
        boolean _isCheckNoUnusedImports = this.activeProfile.isCheckNoUnusedImports();
        boolean bl = _not = !_isCheckNoUnusedImports;
        if (_not) {
            return;
        }
        TTCN3GlobalScopeProvider scopeProvider = (TTCN3GlobalScopeProvider)this.globalScopeProvider;
        if (scopeProvider == null) {
            return;
        }
        SetMultimap<String, ImportData> setMultimap = TTCN3GlobalScopeProvider.IMPORTS;
        synchronized (setMultimap) {
            boolean _containsKey = TTCN3GlobalScopeProvider.IMPORTS.containsKey(module.eResource().getURI().toString());
            if (_containsKey) {
                Collection list = TTCN3GlobalScopeProvider.IMPORTS.get((Object)module.eResource().getURI().toString());
                int _size = list.size();
                int _minus = _size - 1;
                IntegerRange _upTo = new IntegerRange(0, _minus);
                for (Integer i : _upTo) {
                    boolean _tripleEquals;
                    ImportData d = ((ImportData[])Conversions.unwrapArray(list, ImportData.class))[i];
                    TTCN3Module _module = d.getModule();
                    boolean bl2 = _tripleEquals = _module == null;
                    if (_tripleEquals) {
                        this.statistics.incrementCountStyle();
                        String _name = d.getImportDef().getName();
                        String _plus = "Imported module \"" + _name;
                        String message = _plus + "\" cannot be resolved!";
                        ICompositeNode node = NodeModelUtils.getNode(d.getImportDef());
                        ImportDef _importDef = d.getImportDef();
                        String _string = LoggingInterface.MessageClass.STYLE.toString();
                        String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                        String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                        String _methodName = MiscTools.getMethodName();
                        String _plus_1 = "6.18, " + _methodName;
                        this.info(message, (EObject)_importDef, null, _string, _string_1, _string_2, _plus_1, LoggingInterface.LogLevel.INFORMATION.toString());
                    }
                    Functions.Function1<IEObjectDescription, EObject> _function = it -> it.getEObjectOrProxy();
                    HashSet<EObject> target = CollectionLiterals.newHashSet((EObject[])Conversions.unwrapArray(ListExtensions.map(d.getExportedObjects(), _function), EObject.class));
                    boolean found = TTCN3ReferenceHelper.isReferenced2(module, target, false);
                    if (found || d.getModule() == null) continue;
                    this.statistics.incrementCountStyle();
                    String _name_1 = d.getImportDef().getName();
                    String _plus_2 = "No definitions from imported module \"" + _name_1;
                    String message_1 = _plus_2 + "\" are ever used!";
                    ICompositeNode node_1 = NodeModelUtils.getNode(d.getImportDef());
                    ImportDef _importDef_1 = d.getImportDef();
                    String _string_3 = LoggingInterface.MessageClass.STYLE.toString();
                    String _string_4 = Integer.valueOf(node_1.getStartLine()).toString();
                    String _string_5 = Integer.valueOf(node_1.getEndLine()).toString();
                    String _methodName_1 = MiscTools.getMethodName();
                    String _plus_3 = "6.18, " + _methodName_1;
                    this.warning(message_1, (EObject)_importDef_1, null, _string_3, _string_4, _string_5, _plus_3);
                }
            }
        }
    }

    @Check
    public void checkNoTabs(TTCN3Module module) {
        boolean _not;
        boolean _isCheckNoTabs = this.activeProfile.isCheckNoTabs();
        boolean bl = _not = !_isCheckNoTabs;
        if (_not) {
            return;
        }
        String[] segments = EcoreUtil.getURI(module).path().split("\\\\");
        String[] _converted_segments = segments;
        boolean _containsKey = TTCN3GlobalScopeProvider.FOUND_TABS.containsKey(((List)Conversions.doWrapArray(_converted_segments)).getLast());
        if (_containsKey) {
            String[] _converted_segments_1 = segments;
            List<String[]> _get = TTCN3GlobalScopeProvider.FOUND_TABS.get(((List)Conversions.doWrapArray(_converted_segments_1)).getLast());
            for (String[] s2 : _get) {
                this.statistics.incrementCountStyle();
                String _get_1 = s2[1];
                String _plus = "Line contains a tab character! (at column " + _get_1;
                String message = _plus + ")";
                this.warning(message, null, LoggingInterface.MessageClass.STYLE.toString(), s2[0], s2[0], MiscTools.getMethodName());
            }
        }
    }

    @Override
    public void register(EValidatorRegistrar registrar) {
    }
}

