/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.common;

import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import de.ugoe.cs.swe.common.CommonHelper;
import de.ugoe.cs.swe.scoping.ImportData;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import de.ugoe.cs.swe.tTCN3.ImportDef;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;

public class PreAnalyzer
implements Callable<Boolean> {
    private final Resource resource;

    public PreAnalyzer(Resource resource) {
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findImports() {
        List<TTCN3Module> modules = CommonHelper.getModules(this.resource);
        for (TTCN3Module currentModule : modules) {
            for (ImportDef i : EcoreUtil2.getAllContentsOfType(currentModule, ImportDef.class)) {
                TTCN3Module importedModule = TTCN3GlobalScopeProvider.NAMED_MODULES.get(i.getName());
                String key = this.resource.getURI().toString();
                if (importedModule != null) {
                    Multimap<Object, Object> multimap = TTCN3GlobalScopeProvider.IMPORTS;
                    synchronized (multimap) {
                        if (TTCN3GlobalScopeProvider.IMPORTS.containsKey(key)) {
                            TTCN3GlobalScopeProvider.IMPORTS.get((Object)key).add(this.initializeImportedObjects(i, importedModule));
                        } else {
                            TTCN3GlobalScopeProvider.IMPORTS.put(key, this.initializeImportedObjects(i, importedModule));
                        }
                    }
                    multimap = TTCN3GlobalScopeProvider.IMPORTED_RESOURCES;
                    synchronized (multimap) {
                        if (TTCN3GlobalScopeProvider.IMPORTED_RESOURCES.containsKey(key)) {
                            TTCN3GlobalScopeProvider.IMPORTED_RESOURCES.get((Object)key).add(importedModule.eResource().getURI().toString());
                        } else {
                            TTCN3GlobalScopeProvider.IMPORTED_RESOURCES.put(key, importedModule.eResource().getURI().toString());
                        }
                    }
                    multimap = TTCN3GlobalScopeProvider.IMPORTED_FROM;
                    synchronized (multimap) {
                        if (TTCN3GlobalScopeProvider.IMPORTED_FROM.containsKey(importedModule)) {
                            TTCN3GlobalScopeProvider.IMPORTED_FROM.get(importedModule).add(currentModule);
                        } else {
                            TTCN3GlobalScopeProvider.IMPORTED_FROM.put(importedModule, currentModule);
                        }
                        continue;
                    }
                }
                boolean isASN = false;
                if (i.getSpec() != null) {
                    for (String s2 : i.getSpec().getTxt()) {
                        if (!s2.contains("ASN")) continue;
                        isASN = true;
                        break;
                    }
                }
                if (isASN) continue;
                SetMultimap<String, ImportData> setMultimap = TTCN3GlobalScopeProvider.IMPORTS;
                synchronized (setMultimap) {
                    if (TTCN3GlobalScopeProvider.IMPORTS.containsKey(key)) {
                        TTCN3GlobalScopeProvider.IMPORTS.get((Object)key).add(this.initializeImportedObjects(i, importedModule));
                    } else {
                        TTCN3GlobalScopeProvider.IMPORTS.put(key, this.initializeImportedObjects(i, importedModule));
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportData initializeImportedObjects(ImportDef def, TTCN3Module module) {
        ImportData data = new ImportData(def.getName(), def, module);
        if (module != null) {
            SetMultimap<String, IEObjectDescription> setMultimap = TTCN3GlobalScopeProvider.EXPORTED_OBJECTS;
            synchronized (setMultimap) {
                String string = module.eResource().getURI().toString();
                data.getExportedObjects().addAll(TTCN3GlobalScopeProvider.EXPORTED_OBJECTS.get((Object)string));
            }
        }
        return data;
    }

    @Override
    public Boolean call() throws Exception {
        return this.findImports();
    }
}

