/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.ugoe.cs.swe.T3Q.TTCN3Usage;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.tTCN3.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class UsageAnalyzer
implements Callable<TTCN3Usage> {
    private final Resource resource;
    private final LoggingInterface logger;
    public static boolean printUnresolvedObjects = false;

    public UsageAnalyzer(Resource resource, LoggingInterface logger) {
        this.resource = resource;
        this.logger = logger;
    }

    private TTCN3Usage analyze() {
        TTCN3Usage output = new TTCN3Usage(this.resource);
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        EcoreUtil.resolveAll(this.resource);
        EObject model = (EObject)this.resource.getContents().get(0);
        Map<String, Long> counts = TTCN3Package.eINSTANCE.eContents().stream().map(e -> ((ENamedElement)e).getName()).collect(Collectors.toMap(e -> e, v -> 0L));
        ArrayList<EObject> nodes = Lists.newArrayList(model.eAllContents());
        Map<String, Long> grouped = nodes.stream().collect(Collectors.groupingBy(e -> e.eClass().getName(), Collectors.counting()));
        grouped.forEach((k, v) -> {
            Long l = counts.put((String)k, (Long)v);
        });
        List<Type> typeSpecs = EcoreUtil2.eAllOfType(model, Type.class);
        System.out.println(typeSpecs);
        GrammarElementTitleSwitch grammarElementHandler = new GrammarElementTitleSwitch();
        ICompositeNode root = NodeModelUtils.findActualNodeFor(model);
        root.getAsTreeIterable().forEach(node -> {
            if (!(node instanceof ILeafNode) || !((ILeafNode)node).isHidden()) {
                String element = grammarElementHandler.doSwitch(node.getGrammarElement());
                System.out.println(element);
            }
        });
        nodes.forEach(node -> {});
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson(counts);
        stopwatch.stop();
        System.out.println("Analyzing usage in file: " + this.resource.getURI().devicePath().replaceFirst("///", "") + "\n       ...done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms (" + MiscTools.secondsToString(stopwatch.elapsed(TimeUnit.SECONDS)) + " minutes).");
        return output;
    }

    @Override
    public TTCN3Usage call() throws Exception {
        return this.analyze();
    }
}

