/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import de.ugoe.cs.swe.T3Q.T3Q;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class Resolver
implements Callable<String> {
    private final Resource resource;
    private final LoggingInterface logger;

    public Resolver(Resource resource, LoggingInterface logger) {
        this.resource = resource;
        this.logger = logger;
    }

    private String analyze() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        EcoreUtil2.resolveAll(this.resource);
        if (T3Q.getLogLevel().equals((Object)LoggingInterface.LogLevel.DEBUG)) {
            System.out.print("Resolving file: " + this.resource.getURI().path().substring(1));
            System.out.println("\t...done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms (" + MiscTools.secondsToString(stopwatch.elapsed(TimeUnit.SECONDS)) + " minutes).");
        }
        stopwatch.stop();
        return "Done";
    }

    @Override
    public String call() throws Exception {
        return this.analyze();
    }
}

