/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import de.ugoe.cs.swe.T3Q.RuntimeConfiguration;
import de.ugoe.cs.swe.T3Q.T3Q;
import de.ugoe.cs.swe.T3Q.TTCN3Output;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class Analyzer
implements Callable<TTCN3Output> {
    private final Resource resource;
    private final LoggingInterface logger;
    private RuntimeConfiguration runtime;

    public Analyzer(Resource resource, LoggingInterface logger, RuntimeConfiguration runtime) {
        this.resource = resource;
        this.logger = logger;
        this.runtime = runtime;
    }

    private TTCN3Output analyze() {
        TTCN3Output output = new TTCN3Output(this.resource);
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        EcoreUtil.resolveAll(this.resource);
        if (T3Q.getLogLevel() == LoggingInterface.LogLevel.DEBUG) {
            System.out.println("Resolving references: " + this.resource.getURI().devicePath().replaceFirst("///", "") + "\n       ...done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms (" + MiscTools.secondsToString(stopwatch.elapsed(TimeUnit.SECONDS)) + " minutes).");
        }
        EObject model = (EObject)this.resource.getContents().get(0);
        Diagnostic diagnostic = null;
        diagnostic = Diagnostician.INSTANCE.validate(model);
        for (Diagnostic diagnostic2 : diagnostic.getChildren()) {
            if (!(diagnostic2 instanceof FeatureBasedDiagnostic)) continue;
            output.getOutput().add((FeatureBasedDiagnostic)diagnostic2);
        }
        if (this.runtime.isLogUnresolved()) {
            for (Resource.Diagnostic diagnostic3 : this.resource.getErrors()) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logInformation(this.resource.getURI(), diagnostic3.getLine(), diagnostic3.getLine(), LoggingInterface.MessageClass.UNIVERSAL, diagnostic3.getMessage());
            }
            for (Resource.Diagnostic diagnostic4 : this.resource.getWarnings()) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logInformation(this.resource.getURI(), diagnostic4.getLine(), diagnostic4.getLine(), LoggingInterface.MessageClass.UNIVERSAL, diagnostic4.getMessage());
            }
        }
        stopwatch.stop();
        System.out.println("Analyzing file: " + this.resource.getURI().devicePath().replaceFirst("///", "") + "\n       ...done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms (" + MiscTools.secondsToString(stopwatch.elapsed(TimeUnit.SECONDS)) + " minutes).");
        return output;
    }

    @Override
    public TTCN3Output call() throws Exception {
        return this.analyze();
    }
}

