/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class XMLParserActivator
implements BundleActivator,
ServiceFactory<Object> {
    private volatile BundleContext bundleContext;
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String PARSERCLASSFILEPATH = "/META-INF/services/";
    public static final String SAXCLASSFILE = "/META-INF/services/javax.xml.parsers.SAXParserFactory";
    public static final String DOMCLASSFILE = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAXFACTORYDESCRIPTION = "A JAXP Compliant SAX Parser";
    private static final String DOMFACTORYDESCRIPTION = "A JAXP Compliant DOM Parser";
    public static final String PARSER_VALIDATING = "parser.validating";
    public static final String PARSER_NAMESPACEAWARE = "parser.namespaceAware";
    private static final String FACTORYNAMEKEY = "parser.factoryname";

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        Bundle parserBundle = context.getBundle();
        this.registerSAXParsers(this.getParserFactoryClassNames(parserBundle.getResource(SAXCLASSFILE)));
        this.registerDOMParsers(this.getParserFactoryClassNames(parserBundle.getResource(DOMCLASSFILE)));
    }

    public void stop(BundleContext context) throws Exception {
    }

    private List<String> getParserFactoryClassNames(URL parserUrl) throws IOException {
        if (parserUrl == null) {
            return Collections.emptyList();
        }
        ArrayList<String> v = new ArrayList<String>(1);
        String parserFactoryClassName = null;
        InputStream is = parserUrl.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((parserFactoryClassName = br.readLine()) != null) {
            int commentIdx;
            String pfcName = parserFactoryClassName.trim();
            if (pfcName.length() == 0 || (commentIdx = pfcName.indexOf(35)) == 0) continue;
            if (commentIdx < 0) {
                v.add(pfcName);
                continue;
            }
            v.add(pfcName.substring(0, commentIdx).trim());
        }
        return v;
    }

    private void registerSAXParsers(List<String> parserFactoryClassNames) throws FactoryConfigurationError {
        Iterator<String> e = parserFactoryClassNames.iterator();
        int index = 0;
        while (e.hasNext()) {
            String parserFactoryClassName = e.next();
            SAXParserFactory factory = (SAXParserFactory)this.getFactory(parserFactoryClassName);
            Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
            this.setDefaultSAXProperties(factory, properties, index);
            properties.put(FACTORYNAMEKEY, parserFactoryClassName);
            this.bundleContext.registerService(SAXFACTORYNAME, (Object)this, properties);
            ++index;
        }
    }

    private void setDefaultSAXProperties(SAXParserFactory factory, Hashtable<String, Object> props, int index) {
        props.put("service.description", SAXFACTORYDESCRIPTION);
        props.put("service.pid", "javax.xml.parsers.SAXParserFactory." + this.bundleContext.getBundle().getBundleId() + "." + index);
        this.setSAXProperties(factory, props);
    }

    public void setSAXProperties(SAXParserFactory factory, Hashtable<String, Object> properties) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newSAXParser();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        properties.put(PARSER_NAMESPACEAWARE, namespaceaware);
        properties.put(PARSER_VALIDATING, validating);
    }

    private void registerDOMParsers(List<String> parserFactoryClassNames) throws FactoryConfigurationError {
        Iterator<String> e = parserFactoryClassNames.iterator();
        int index = 0;
        while (e.hasNext()) {
            String parserFactoryClassName = e.next();
            DocumentBuilderFactory factory = (DocumentBuilderFactory)this.getFactory(parserFactoryClassName);
            Hashtable<String, Object> properties = new Hashtable<String, Object>(7);
            this.setDefaultDOMProperties(factory, properties, index);
            properties.put(FACTORYNAMEKEY, parserFactoryClassName);
            this.bundleContext.registerService(DOMFACTORYNAME, (Object)this, properties);
            ++index;
        }
    }

    private void setDefaultDOMProperties(DocumentBuilderFactory factory, Hashtable<String, Object> props, int index) {
        props.put("service.description", DOMFACTORYDESCRIPTION);
        props.put("service.pid", "javax.xml.parsers.DocumentBuilderFactory." + this.bundleContext.getBundle().getBundleId() + "." + index);
        this.setDOMProperties(factory, props);
    }

    public void setDOMProperties(DocumentBuilderFactory factory, Hashtable<String, Object> props) {
        boolean validating = true;
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_val) {
            validating = false;
        }
        boolean namespaceaware = true;
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.newDocumentBuilder();
        }
        catch (Exception pce_nsa) {
            namespaceaware = false;
        }
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceaware);
        props.put(PARSER_VALIDATING, validating);
        props.put(PARSER_NAMESPACEAWARE, namespaceaware);
    }

    private Object getFactory(String parserFactoryClassName) throws FactoryConfigurationError {
        try {
            return this.bundleContext.getBundle().loadClass(parserFactoryClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FactoryConfigurationError(e);
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
        ServiceReference sref = registration.getReference();
        String parserFactoryClassName = (String)sref.getProperty(FACTORYNAMEKEY);
        Object factory = this.getFactory(parserFactoryClassName);
        if (factory instanceof SAXParserFactory) {
            ((SAXParserFactory)factory).setValidating((Boolean)sref.getProperty(PARSER_VALIDATING));
            ((SAXParserFactory)factory).setNamespaceAware((Boolean)sref.getProperty(PARSER_NAMESPACEAWARE));
        } else if (factory instanceof DocumentBuilderFactory) {
            ((DocumentBuilderFactory)factory).setValidating((Boolean)sref.getProperty(PARSER_VALIDATING));
            ((DocumentBuilderFactory)factory).setNamespaceAware((Boolean)sref.getProperty(PARSER_NAMESPACEAWARE));
        }
        return factory;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
    }
}

