/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.serializer.ISerializationContext;

public class SerializationContextMap<T> {
    private Map<ISerializationContext, T> keys = null;
    private List<Entry<T>> values;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    protected SerializationContextMap(List<Entry<T>> values) {
        this.values = values;
    }

    public T get(ISerializationContext ctx) {
        if (this.keys == null) {
            this.keys = Maps.newHashMap();
            for (Entry<T> e : this.values) {
                for (ISerializationContext c : e.getContexts()) {
                    this.keys.put(c, e.getValue());
                }
            }
        }
        return this.keys.get(ctx);
    }

    public SerializationContextMap<T> sortedCopy() {
        ArrayList result = Lists.newArrayList();
        for (Entry<T> e : this.values) {
            ArrayList<ISerializationContext> ctx = Lists.newArrayList(e.getContexts());
            Collections.sort(ctx);
            result.add(new Entry(e.value, ctx));
        }
        Collections.sort(result, new Comparator<Entry<T>>(){

            @Override
            public int compare(Entry<T> o1, Entry<T> o2) {
                return o1.getContexts().get(0).compareTo(o2.getContexts().get(0));
            }
        });
        return new SerializationContextMap<T>(ImmutableList.copyOf(result));
    }

    public List<Entry<T>> values() {
        return this.values;
    }

    public static class Builder<T> {
        private Map<T, MutableEntry<T>> entries = Maps.newLinkedHashMap();

        protected Builder() {
        }

        public SerializationContextMap<T> create() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MutableEntry<T> e : this.entries.values()) {
                builder.add(new Entry(e.value, e.contexts));
            }
            return new SerializationContextMap(builder.build());
        }

        public void put(Collection<ISerializationContext> ctx, T value) {
            MutableEntry<T> entry = this.entries.get(value);
            if (entry == null) {
                entry = new MutableEntry<T>(value);
                this.entries.put(value, entry);
            }
            entry.contexts.addAll(ctx);
        }

        public void put(ISerializationContext ctx, T value) {
            MutableEntry<T> entry = this.entries.get(value);
            if (entry == null) {
                entry = new MutableEntry<T>(value);
                this.entries.put(value, entry);
            }
            entry.contexts.add(ctx);
        }
    }

    public static class Entry<T> {
        private final List<ISerializationContext> contexts;
        private final T value;

        protected Entry(T value, Collection<ISerializationContext> contexts) {
            this.value = value;
            this.contexts = ImmutableList.copyOf(contexts);
        }

        public List<ISerializationContext> getContexts() {
            return this.contexts;
        }

        public List<ISerializationContext> getContexts(EClass type) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ISerializationContext ctx : this.contexts) {
                if (ctx.getType() != type) continue;
                builder.add(ctx);
            }
            return builder.build();
        }

        public Set<EClass> getTypes() {
            LinkedHashSet<EClass> types = Sets.newLinkedHashSet();
            for (ISerializationContext ctx : this.contexts) {
                types.add(ctx.getType());
            }
            return types;
        }

        public T getValue() {
            return this.value;
        }
    }

    protected static class MutableEntry<T> {
        private final Set<ISerializationContext> contexts = Sets.newLinkedHashSet();
        private final T value;

        protected MutableEntry(T value) {
            this.value = value;
        }
    }
}

