/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ServiceLoader;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.ResourceServiceProviderRegistryImpl;

@Singleton
public class ResourceServiceProviderServiceLoader
implements Provider<IResourceServiceProvider.Registry> {
    private final ServiceLoader<ISetup> setupLoader = ServiceLoader.load(ISetup.class);
    private final IResourceServiceProvider.Registry registry = this.loadRegistry();

    private IResourceServiceProvider.Registry loadRegistry() {
        ResourceServiceProviderRegistryImpl registry = new ResourceServiceProviderRegistryImpl();
        for (ISetup cp : this.setupLoader) {
            Injector injector = cp.createInjectorAndDoEMFRegistration();
            IResourceServiceProvider resourceServiceProvider = injector.getInstance(IResourceServiceProvider.class);
            FileExtensionProvider extensionProvider = injector.getInstance(FileExtensionProvider.class);
            String primaryFileExtension = extensionProvider.getPrimaryFileExtension();
            for (String ext : extensionProvider.getFileExtensions()) {
                if (registry.getExtensionToFactoryMap().containsKey(ext)) {
                    if (!primaryFileExtension.equals(ext)) continue;
                    registry.getExtensionToFactoryMap().put(ext, resourceServiceProvider);
                    continue;
                }
                registry.getExtensionToFactoryMap().put(ext, resourceServiceProvider);
            }
        }
        return registry;
    }

    @Override
    public IResourceServiceProvider.Registry get() {
        return this.registry;
    }
}

