/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;

@Singleton
public class GrammarElementLookup {
    private final IGrammarAccess grammarAccess;
    private Tabulated<EObject> lookup;

    @Inject
    public GrammarElementLookup(IGrammarAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Tabulated<EObject> delegate() {
        Tabulated<EObject> result = this.lookup;
        if (result == null) {
            GrammarElementLookup grammarElementLookup = this;
            synchronized (grammarElementLookup) {
                result = this.lookup;
                if (result == null) {
                    ImmutableMap.Builder<EObject, Integer> mapBuilder = ImmutableMap.builder();
                    ImmutableList.Builder listBuilder = ImmutableList.builder();
                    int counter = 0;
                    Grammar grammar = this.grammarAccess.getGrammar();
                    while (grammar != null) {
                        TreeIterator<EObject> iterator = EcoreUtil2.eAll(grammar);
                        while (iterator.hasNext()) {
                            EObject grammarElement = (EObject)iterator.next();
                            mapBuilder.put(grammarElement, counter);
                            listBuilder.add(grammarElement);
                            ++counter;
                        }
                        grammar = grammar.getUsedGrammars().isEmpty() ? null : (Grammar)grammar.getUsedGrammars().get(0);
                    }
                    this.lookup = result = new Tabulated(mapBuilder.build(), listBuilder.build());
                }
            }
        }
        return result;
    }

    public int getId(EObject object) {
        return this.delegate().getId(object);
    }

    public int size() {
        return this.delegate().size();
    }

    public EObject getGrammarElement(int id) {
        return this.delegate().getObject(id);
    }
}

