/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.detachable.AbstractDetachableParseResult;
import org.eclipse.xtext.nodemodel.detachable.DetachedNodeModelReader;
import org.eclipse.xtext.nodemodel.detachable.DetachedNodeModelWriter;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.NodeModelData;
import org.eclipse.xtext.nodemodel.detachable.StandardNodeModelReference;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.RootNode;

public class DetachableParseResult
extends AbstractDetachableParseResult<StandardNodeModelReference, NodeModelData> {
    private static final Logger logger = Logger.getLogger(DetachableParseResult.class);

    public DetachableParseResult(GrammarElementLookup grammarElementLookup) {
        super(grammarElementLookup);
    }

    public DetachableParseResult(GrammarElementLookup grammarElementLookup, Duration timeout) {
        super(grammarElementLookup, timeout);
    }

    @Override
    protected StandardNodeModelReference toNodeModelReference(ICompositeNode rootNode, Map<EObject, CompositeNodeWithSemanticElement> associations) {
        return new StandardNodeModelReference(this, (RootNode)Preconditions.checkNotNull(rootNode), associations);
    }

    @Override
    protected NodeModelData serialize(StandardNodeModelReference nodeModel) throws IOException {
        DetachedNodeModelWriter writer = new DetachedNodeModelWriter(this.grammarElementLookup);
        NodeModelData result = writer.serialize(nodeModel);
        if (logger.isTraceEnabled()) {
            logger.trace("DetachableParseResult.serialize:" + String.valueOf(result));
        }
        return result;
    }

    @Override
    protected StandardNodeModelReference deserialize(NodeModelData serialized) throws IOException {
        DetachedNodeModelReader reader = new DetachedNodeModelReader(serialized);
        StandardNodeModelReference result = reader.deserialize(this);
        if (logger.isTraceEnabled()) {
            logger.trace("DetachableParseResult.deserialize:" + String.valueOf(result));
        }
        return result;
    }
}

