/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractTraceRegionToString {
    private int radix = 10;
    private boolean showTree = true;
    private boolean showLegend = true;

    protected abstract String getRemoteText(SourceRelativeURI var1);

    protected abstract String getLocalText();

    protected abstract AbstractTraceRegion getTrace();

    protected ITextRegion getLocalFrame() {
        return null;
    }

    protected ITextRegion getRemoteFrame(SourceRelativeURI uri) {
        return null;
    }

    protected String getLocalTitle() {
        return "generated.java";
    }

    protected String getRemoteTitle(SourceRelativeURI uri) {
        return uri.getURI().toString();
    }

    protected boolean shouldInclude(AbstractTraceRegion region) {
        ITextRegion frame = this.getLocalFrame();
        return frame == null ? true : frame.contains(region.getMyRegion());
    }

    protected boolean shouldInclude(AbstractTraceRegion region, ILocationData location) {
        SourceRelativeURI srcRelativePath = location.getSrcRelativePath();
        ITextRegion frame = this.getRemoteFrame(srcRelativePath == null ? region.getAssociatedSrcRelativePath() : srcRelativePath);
        return frame == null ? true : frame.contains(location);
    }

    protected void add(Map<SourceRelativeURI, File> files, SourceRelativeURI uri, ITextRegion it, RegionHandle region, LocationHandle location) {
        File file = files.get(uri);
        if (file == null) {
            file = new File(uri);
            files.put(uri, file);
        }
        this.add(file, it, region, location);
    }

    protected void add(File file, ITextRegion it, RegionHandle region, LocationHandle location) {
        file.inserts.add(new Insert(it.getOffset(), true, region, location));
        file.inserts.add(new Insert(it.getOffset() + it.getLength(), false, region, location));
    }

    protected int collect(AbstractTraceRegion reg, int nextID, File lFile, Map<SourceRelativeURI, File> rFiles, List<RegionHandle> result) {
        int i = nextID;
        List<RegionHandle> childResult = result;
        if (this.shouldInclude(reg)) {
            RegionHandle regHandle = new RegionHandle(i++, reg);
            result.add(regHandle);
            childResult = regHandle.children;
            this.add(lFile, reg.getMyRegion(), regHandle, null);
            List<ILocationData> locs = IterableExtensions.toList(IterableExtensions.filter(reg.getAssociatedLocations(), loc -> this.shouldInclude(reg, (ILocationData)loc)));
            int j = 0;
            while (j < locs.size()) {
                ILocationData loc2 = locs.get(j);
                LocationHandle locHandle = new LocationHandle(regHandle, locs.size() > 1 ? j + 1 : -1, loc2);
                regHandle.locations.add(locHandle);
                SourceRelativeURI srcRelativePath = loc2.getSrcRelativePath();
                SourceRelativeURI path = srcRelativePath == null ? reg.getAssociatedSrcRelativePath() : srcRelativePath;
                this.add(rFiles, path, loc2, regHandle, locHandle);
                ++j;
            }
        }
        for (AbstractTraceRegion child : reg.getNestedRegions()) {
            i = this.collect(child, i, lFile, rFiles, childResult);
        }
        return i;
    }

    protected String render(Insert it, int width) {
        String first = Strings.padStart(Integer.toString(it.region.id, this.radix), width, '0');
        return it.location != null && it.location.id >= 0 ? first + "_" + Integer.toString(it.location.id, this.radix) : first;
    }

    protected int sortKey(Insert it) {
        int base = it.region.id * Short.MAX_VALUE;
        return it.location != null && it.location.id >= 0 ? base + it.location.id : base;
    }

    protected String render(Collection<Insert> inserts, int width) {
        String opens = IterableExtensions.join(Iterables.transform(IterableExtensions.sortBy(IterableExtensions.filter(inserts, i -> i.open), i -> this.sortKey((Insert)i)), i -> this.render((Insert)i, width)), ",");
        String closes = IterableExtensions.join(Iterables.transform(IterableExtensions.sortBy(IterableExtensions.filter(inserts, i -> !i.open), i -> -this.sortKey((Insert)i)), i -> this.render((Insert)i, width)), ",");
        Object s1 = opens.isEmpty() ? "" : "[" + opens + "[";
        Object s2 = closes.isEmpty() ? "" : "]" + closes + "]";
        return (String)s2 + (String)s1;
    }

    protected List<String> render(File file, int width) {
        try {
            String text = file.uri == null ? this.getLocalText() : this.getRemoteText(file.uri);
            ITextRegion localOrRemoteFrame = file.uri == null ? this.getLocalFrame() : this.getRemoteFrame(file.uri);
            ITextRegion frame = localOrRemoteFrame == null ? new TextRegion(0, text.length()) : localOrRemoteFrame;
            int last = frame.getOffset();
            StringBuilder result = new StringBuilder();
            for (Map.Entry e : IterableExtensions.sortBy(IterableExtensions.toList(((ImmutableMap)Multimaps.index(IterableExtensions.filter(file.inserts, i -> i.offset >= frame.getOffset() && i.offset <= frame.getOffset() + frame.getLength()), i -> i.offset).asMap()).entrySet()), i -> (Integer)i.getKey())) {
                int offset = (Integer)e.getKey();
                result.append(text.substring(last, offset));
                result.append(this.render((Collection)e.getValue(), width));
                last = offset;
            }
            int end = frame.getOffset() + frame.getLength();
            if (last < end) {
                result.append(text.substring(last, end));
            }
            return CharStreams.readLines(new StringReader(result.toString()));
        }
        catch (IOException t2) {
            throw new RuntimeIOException(t2);
        }
    }

    protected String title(SourceRelativeURI uri, int width) {
        String s2 = " " + (uri == null ? this.getLocalTitle() : this.getRemoteTitle(uri)) + " ";
        String left = Strings.repeat("-", (width - s2.length()) / 2);
        String right = Strings.repeat("-", width - (s2.length() + left.length()));
        return left + s2 + right;
    }

    protected <T> Set<T> collect(T start, Functions.Function1<? super T, ? extends Iterable<T>> reachable) {
        return this.collect(start, reachable, new LinkedHashSet());
    }

    protected <R extends Collection<? super T>, T> R collect(T start, Functions.Function1<? super T, ? extends Iterable<T>> reachable, R collector) {
        if (collector.add(start)) {
            for (T r : reachable.apply(start)) {
                this.collect(r, reachable, collector);
            }
        }
        return collector;
    }

    protected String render(LocationHandle loc) {
        String prefix = loc.id >= 0 ? Integer.toString(loc.id, this.radix) + ": " : "";
        String name = loc.location.getClass().getSimpleName();
        String path = loc.location.getSrcRelativePath() == null ? "" : "," + String.valueOf(loc.location.getSrcRelativePath());
        return prefix + name + "[" + loc.location.getOffset() + "," + loc.location.getLength() + path + "]";
    }

    protected void render(RegionHandle region, int idW, int offsetW, int lengthW, int indent, List<String> result) {
        String id = Strings.padStart(Integer.toString(region.id, this.radix), idW, '0');
        String debug = region.region.isUseForDebugging() ? "D" : " ";
        String offset = Strings.padStart(Integer.toString(region.region.getMyOffset()), offsetW, '0');
        String length = Strings.padStart(Integer.toString(region.region.getMyLength()), lengthW, '0');
        String space = Strings.repeat(" ", indent);
        String name = region.region.getClass().getSimpleName();
        String locations = IterableExtensions.join(Iterables.transform(region.locations, it -> this.render((LocationHandle)it)), ", ");
        String loc = debug + " " + offset + "-" + length + space;
        String header = id + ": " + loc + name + " -> " + locations;
        if (region.children.isEmpty()) {
            result.add(header);
        } else {
            result.add(header + " {");
            for (RegionHandle child : region.children) {
                this.render(child, idW, offsetW, lengthW, indent + 2, result);
            }
            result.add(id + ": " + Strings.repeat(" ", loc.length()) + "}");
        }
    }

    protected String render() {
        File localFile = new File(null);
        LinkedHashMap<SourceRelativeURI, File> remoteFiles = new LinkedHashMap<SourceRelativeURI, File>();
        ArrayList<RegionHandle> roothandles = new ArrayList<RegionHandle>();
        int maxid = this.collect(this.getTrace(), 1, localFile, remoteFiles, roothandles);
        int idwidth = Integer.toString(maxid, this.radix).length();
        Iterables.addAll(localFile.lines, this.render(localFile, idwidth));
        for (File file : remoteFiles.values()) {
            Iterables.addAll(file.lines, this.render(file, idwidth));
        }
        int localWidth = Math.max((Integer)IterableExtensions.max(Iterables.transform(localFile.lines, it -> it.length())), this.getLocalTitle().length() + 2);
        int remoteWidth = (Integer)IterableExtensions.max(Iterables.transform(remoteFiles.values(), it -> Math.max((Integer)IterableExtensions.max(Iterables.transform(it.lines, it_1 -> it_1.length())), this.getRemoteTitle(it.uri).length() + 2)));
        localFile.lines.add(0, this.title(null, localWidth));
        for (File file : remoteFiles.values()) {
            file.lines.add(0, this.title(file.uri, remoteWidth));
        }
        List<String> left = localFile.lines;
        List right = IterableExtensions.toList(Iterables.concat(Iterables.transform(remoteFiles.values(), it -> it.lines)));
        ArrayList<String> result = new ArrayList<String>();
        if (this.showLegend) {
            result.add("Regions are surrounded by [N[ ... ]N]. Regions on the left and right with the same N are associated.");
        }
        int i = 0;
        while (i < left.size() || i < right.size()) {
            String l = Strings.padEnd(i < left.size() ? left.get(i) : "", localWidth, ' ');
            String r = i < right.size() ? (String)right.get(i) : "";
            result.add(l + " | " + r);
            ++i;
        }
        if (this.showTree) {
            result.add(Strings.repeat("-", localWidth + remoteWidth + 3));
            if (this.showLegend) {
                result.add("<N>: <isDebug> <offset>-<length> <RegionJavaClass> -> <LocationJavaClass>[<offset>,<length>,<uri>]");
            }
            Iterable allhandles = Iterables.concat(Iterables.transform(roothandles, it -> this.collect(it, it_1 -> it_1.children)));
            int offsetWidth = String.valueOf(IterableExtensions.max(Iterables.transform(allhandles, it -> it.region.getMyOffset()))).length();
            int lengthWidth = String.valueOf(IterableExtensions.max(Iterables.transform(allhandles, it -> it.region.getMyLength()))).length();
            for (RegionHandle handle : roothandles) {
                this.render(handle, idwidth, offsetWidth, lengthWidth, 1, result);
            }
        }
        return IterableExtensions.join(result, org.eclipse.xtext.util.Strings.newLine());
    }

    public String toString() {
        try {
            return this.render();
        }
        catch (Exception t2) {
            return Throwables.getStackTraceAsString(t2);
        }
    }

    public int getRadix() {
        return this.radix;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    protected static class File {
        private final SourceRelativeURI uri;
        private final List<Insert> inserts = new ArrayList<Insert>();
        private final List<String> lines = new ArrayList<String>();

        public File(SourceRelativeURI uri) {
            this.uri = uri;
        }

        public SourceRelativeURI getUri() {
            return this.uri;
        }

        public List<Insert> getInserts() {
            return this.inserts;
        }

        public List<String> getLines() {
            return this.lines;
        }
    }

    protected static class Insert {
        private final int offset;
        private final boolean open;
        private final RegionHandle region;
        private final LocationHandle location;

        public Insert(int offset, boolean open, RegionHandle region, LocationHandle location) {
            this.offset = offset;
            this.open = open;
            this.region = region;
            this.location = location;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isOpen() {
            return this.open;
        }

        public RegionHandle getRegion() {
            return this.region;
        }

        public LocationHandle getLocation() {
            return this.location;
        }
    }

    protected static class LocationHandle {
        private final RegionHandle region;
        private final int id;
        private final ILocationData location;

        public LocationHandle(RegionHandle region, int id, ILocationData location) {
            this.region = region;
            this.id = id;
            this.location = location;
        }

        public RegionHandle getRegion() {
            return this.region;
        }

        public int getId() {
            return this.id;
        }

        public ILocationData getLocation() {
            return this.location;
        }
    }

    protected static class RegionHandle {
        private final int id;
        private final AbstractTraceRegion region;
        private final List<LocationHandle> locations = new ArrayList<LocationHandle>();
        private final List<RegionHandle> children = new ArrayList<RegionHandle>();

        public RegionHandle(int id, AbstractTraceRegion region) {
            this.id = id;
            this.region = region;
        }

        public int getId() {
            return this.id;
        }

        public AbstractTraceRegion getRegion() {
            return this.region;
        }

        public List<LocationHandle> getLocations() {
            return this.locations;
        }

        public List<RegionHandle> getChildren() {
            return this.children;
        }
    }
}

