/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionInstance;
import de.ugoe.cs.swe.tTCN3.FunctionRef;
import de.ugoe.cs.swe.tTCN3.ImportDef;
import de.ugoe.cs.swe.tTCN3.ModuleDefinition;
import de.ugoe.cs.swe.tTCN3.StartTCStatement;
import de.ugoe.cs.swe.tTCN3.StartTimerStatement;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.tTCN3.TimerInstance;
import de.ugoe.cs.swe.tTCN3.TypeDef;
import de.ugoe.cs.swe.validation.ModuleContentHelper;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class ModularizationValidator
extends AbstractDeclarativeValidator {
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();
    private ModuleContentHelper moduleHelper = new ModuleContentHelper(this.activeProfile);
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    @Check
    public void checkModuleContainment(TTCN3Module module) {
        if (this.activeProfile.isCheckTypesAndValuesModuleContainmentCheck() && module.getName().contains("TypesAndValues")) {
            this.checkModuleContainment(module, "TypesAndValues");
        } else if (this.activeProfile.isCheckTemplatesModuleContainmentCheck() && module.getName().contains("Templates") && module.getName().contains("Functions")) {
            this.checkModuleContainment(module, "Templates", "Functions");
        } else if (this.activeProfile.isCheckTemplatesModuleContainmentCheck() && module.getName().contains("Templates")) {
            this.checkModuleContainment(module, "Templates");
        } else if (this.activeProfile.isCheckFunctionsModuleContainmentCheck() && module.getName().contains("Functions")) {
            this.checkModuleContainment(module, "Functions");
        } else if (this.activeProfile.isCheckTestcasesModuleContainmentCheck() && module.getName().contains("Testcases")) {
            this.checkModuleContainment(module, "Testcases");
        } else if (this.activeProfile.isCheckModuleParamsModuleContainmentCheck() && module.getName().contains("ModuleParams")) {
            this.checkModuleContainment(module, "ModuleParams");
        } else if (this.activeProfile.isCheckInterfaceModuleContainmentCheck() && module.getName().contains("Interface")) {
            this.checkModuleContainment(module, "Interface");
        } else if (this.activeProfile.isCheckTestSystemModuleContainmentCheck() && module.getName().contains("TestSystem")) {
            this.checkModuleContainment(module, "TestSystem");
        } else if (this.activeProfile.isCheckTestControlModuleContainmentCheck() && module.getName().contains("TestControl")) {
            this.checkModuleContainment(module, "TestControl");
        }
    }

    private void checkModuleContainment(TTCN3Module module, String moduleRestriction) {
        List<ModuleDefinition> _allContentsOfType = EcoreUtil2.getAllContentsOfType(module, ModuleDefinition.class);
        for (ModuleDefinition d : _allContentsOfType) {
            boolean _not_1;
            boolean _typePermittedInRestrictedModule;
            boolean _not;
            EObject definition = null;
            boolean _equals = Objects.equals(moduleRestriction, "TestSystem");
            if (_equals) {
                definition = d.getDef();
                if (definition instanceof TypeDef && !Objects.equals(((TypeDef)definition).getBody().getStructured(), null) && !Objects.equals(((TypeDef)definition).getBody().getStructured().getComponent(), null)) {
                    definition = ((TypeDef)definition).getBody().getStructured().getComponent();
                }
            } else {
                definition = d.getDef();
            }
            boolean bl = _not = !(_typePermittedInRestrictedModule = this.moduleHelper.typePermittedInRestrictedModule(moduleRestriction, definition.eClass()));
            if (_not) {
                TTCN3StatisticsProvider.getInstance().incrementCountModularization();
                String message = "Definition in " + moduleRestriction + " module is not of the permissible definition type(s)!";
                ICompositeNode node = NodeModelUtils.getNode(definition);
                String _string = LoggingInterface.MessageClass.MODULARIZATION.toString();
                String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                String _methodName = MiscTools.getMethodName();
                String _plus = "7.x, " + _methodName;
                this.warning(message, null, _string, _string_1, _string_2, _plus);
                continue;
            }
            if (!Objects.equals(moduleRestriction, "Testcases") || !(definition instanceof FunctionDef)) continue;
            boolean _functionStartBehavior = this.functionStartBehavior((FunctionDef)definition, module);
            boolean bl2 = _not_1 = !_functionStartBehavior;
            if (!_not_1) continue;
            TTCN3StatisticsProvider.getInstance().incrementCountModularization();
            String _name = ((FunctionDef)definition).getName();
            String _plus_1 = "Definition in " + moduleRestriction + " module is not of the permissible definition type(s)! Function " + _name;
            String message_1 = _plus_1 + " is never referenced in a start statement!";
            ICompositeNode node_1 = NodeModelUtils.getNode(definition);
            String _string_3 = LoggingInterface.MessageClass.MODULARIZATION.toString();
            String _string_4 = Integer.valueOf(node_1.getStartLine()).toString();
            String _string_5 = Integer.valueOf(node_1.getEndLine()).toString();
            String _methodName_1 = MiscTools.getMethodName();
            String _plus_2 = "7.x, " + _methodName_1;
            this.warning(message_1, null, _string_3, _string_4, _string_5, _plus_2);
        }
    }

    private void checkModuleContainment(TTCN3Module module, String moduleRestriction1, String moduleRestriction2) {
        List<ModuleDefinition> _allContentsOfType = EcoreUtil2.getAllContentsOfType(module, ModuleDefinition.class);
        for (ModuleDefinition d : _allContentsOfType) {
            boolean _not;
            EObject definition = d.getDef();
            boolean bl = _not = !this.moduleHelper.typePermittedInRestrictedModule(moduleRestriction1, definition.eClass()) && !this.moduleHelper.typePermittedInRestrictedModule(moduleRestriction2, definition.eClass());
            if (!_not) continue;
            TTCN3StatisticsProvider.getInstance().incrementCountModularization();
            String message = "Definition in " + moduleRestriction1 + " and " + moduleRestriction2 + " module is not of the permissible definition type(s)!";
            ICompositeNode node = NodeModelUtils.getNode(definition);
            String _string = LoggingInterface.MessageClass.MODULARIZATION.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "7.x, " + _methodName;
            this.warning(message, null, _string, _string_1, _string_2, _plus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean functionStartBehavior(FunctionDef function, TTCN3Module module) {
        ArrayList<FunctionInstance> list = CollectionLiterals.newArrayList();
        TTCN3GlobalScopeProvider scopeProvider = (TTCN3GlobalScopeProvider)this.globalScopeProvider;
        boolean _equals = Objects.equals(scopeProvider, null);
        if (_equals) {
            return false;
        }
        Multimap<TTCN3Module, TTCN3Module> multimap = TTCN3GlobalScopeProvider.IMPORTED_FROM;
        synchronized (multimap) {
            Collection<TTCN3Module> _get = TTCN3GlobalScopeProvider.IMPORTED_FROM.get(module);
            for (TTCN3Module m4 : _get) {
                List<FunctionInstance> _eAllOfType = EcoreUtil2.eAllOfType(m4, FunctionInstance.class);
                for (FunctionInstance instance : _eAllOfType) {
                    boolean _equals_1;
                    FunctionRef reference = instance.getRef();
                    if (!(reference instanceof FunctionDef) || !(_equals_1 = ((FunctionDef)reference).equals(function))) continue;
                    list.add(instance);
                }
            }
        }
        for (FunctionInstance r : list) {
            StartTCStatement startTC = TTCN3ScopeHelper.findDesiredParent(r, StartTCStatement.class);
            StartTimerStatement startTimer = TTCN3ScopeHelper.findDesiredParent(r, StartTimerStatement.class);
            FunctionInstance nestedParameter = TTCN3ScopeHelper.findDesiredParent(r, FunctionInstance.class);
            boolean timer = false;
            if (!Objects.equals(startTimer, null) && !Objects.equals(TTCN3ScopeHelper.findDesiredParent(startTimer.getRef(), TimerInstance.class), null)) {
                timer = true;
            }
            if (Objects.equals(startTC, null) && (Objects.equals(startTimer, null) || !Objects.equals(nestedParameter, null) || timer)) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkModuleSize(TTCN3Module module) {
        int referenceSize;
        int _offset;
        boolean _not;
        boolean _isCheckModuleSize = this.activeProfile.isCheckModuleSize();
        boolean bl = _not = !_isCheckModuleSize;
        if (_not) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode(module);
        int _endOffset = node.getEndOffset();
        int moduleSize = _endOffset - (_offset = node.getOffset());
        if (moduleSize > (referenceSize = this.activeProfile.getMaximumAllowedModuleSizeInBytes())) {
            TTCN3StatisticsProvider.getInstance().incrementCountModularization();
            String _name = module.getName();
            String _plus = "Module \"" + _name;
            String _plus_1 = _plus + "\" is larger (";
            String _plus_2 = _plus_1 + String.valueOf((Object)moduleSize);
            String _plus_3 = _plus_2 + " bytes) than the maximum allowed module size (";
            String _plus_4 = _plus_3 + String.valueOf((Object)referenceSize);
            String message = _plus_4 + " bytes)!";
            EAttribute _tTCN3Reference_Name = TTCN3Package.eINSTANCE.getTTCN3Reference_Name();
            String _string = LoggingInterface.MessageClass.MODULARIZATION.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_5 = "7.21, " + _methodName;
            this.warning(message, (EStructuralFeature)_tTCN3Reference_Name, _string, _string_1, _string_2, _plus_5);
        }
    }

    @Check
    public void checkTypesAndValuesModuleImportsLibNames(TTCN3Module module) {
        boolean _not;
        boolean _isCheckTypesAndValuesModuleImportsLibNames = this.activeProfile.isCheckTypesAndValuesModuleImportsLibNames();
        boolean bl = _not = !_isCheckTypesAndValuesModuleImportsLibNames;
        if (_not) {
            return;
        }
        Pattern typesAndValuesImportsLibNamesExcludedPattern = Pattern.compile(this.activeProfile.getTypesAndValuesImportsLibNamesExcludedRegExp());
        Matcher typesAndValuesImportsLibNamesExcludedMatcher = typesAndValuesImportsLibNamesExcludedPattern.matcher(module.getName());
        if (!module.getName().contains("TypesAndValues") || typesAndValuesImportsLibNamesExcludedMatcher.matches()) {
            return;
        }
        Pattern typesAndValuesImportsLibNamesPattern = Pattern.compile(this.activeProfile.getTypesAndValuesImportsLibNamesRegExp());
        Matcher typesAndValuesImportsLibNamesMatcher = null;
        boolean libCommonReferenceFound = false;
        List<ImportDef> _allContentsOfType = EcoreUtil2.getAllContentsOfType(module, ImportDef.class);
        for (ImportDef i : _allContentsOfType) {
            typesAndValuesImportsLibNamesMatcher = typesAndValuesImportsLibNamesPattern.matcher(i.getName());
            boolean _matches = typesAndValuesImportsLibNamesMatcher.matches();
            if (!_matches) continue;
            libCommonReferenceFound = true;
        }
        if (!libCommonReferenceFound) {
            TTCN3StatisticsProvider.getInstance().incrementCountModularization();
            String _typesAndValuesImportsLibNamesRegExp = this.activeProfile.getTypesAndValuesImportsLibNamesRegExp();
            String _plus = "Required import from \"" + _typesAndValuesImportsLibNamesRegExp;
            String message = _plus + "\" not found!!";
            ICompositeNode node = NodeModelUtils.getNode(module);
            EAttribute _tTCN3Reference_Name = TTCN3Package.eINSTANCE.getTTCN3Reference_Name();
            String _string = LoggingInterface.MessageClass.MODULARIZATION.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getStartLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_1 = "7.3, " + _methodName;
            this.warning(message, (EStructuralFeature)_tTCN3Reference_Name, _string, _string_1, _string_2, _plus_1);
        }
    }

    @Check
    public void checkTestcasesModuleImportsLibCommon_Sync(TTCN3Module module) {
        boolean _not;
        boolean _isCheckTestcasesModuleImportsLibCommon_Sync = this.activeProfile.isCheckTestcasesModuleImportsLibCommon_Sync();
        boolean bl = _not = !_isCheckTestcasesModuleImportsLibCommon_Sync;
        if (_not) {
            return;
        }
        if (!module.getName().contains("Testcases") || module.getName().contains("LibCommon_Sync")) {
            return;
        }
        boolean libCommonReferenceFound = false;
        List<ImportDef> _allContentsOfType = EcoreUtil2.getAllContentsOfType(module, ImportDef.class);
        for (ImportDef i : _allContentsOfType) {
            boolean _contains = i.getName().contains("LibCommon_Sync");
            if (!_contains) continue;
            libCommonReferenceFound = true;
        }
        if (!libCommonReferenceFound) {
            TTCN3StatisticsProvider.getInstance().incrementCountModularization();
            ICompositeNode node = NodeModelUtils.getNode(module);
            EAttribute _tTCN3Reference_Name = TTCN3Package.eINSTANCE.getTTCN3Reference_Name();
            String _string = LoggingInterface.MessageClass.MODULARIZATION.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getStartLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "7.11, " + _methodName;
            this.warning("Required import from \"LibCommon_Sync\" not found!", (EStructuralFeature)_tTCN3Reference_Name, _string, _string_1, _string_2, _plus);
        }
    }

    @Override
    public void register(EValidatorRegistrar registrar) {
    }
}

