/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.common;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.TTCN3Configuration.T3QConfig;
import de.ugoe.cs.swe.common.ConfigurationProfile;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.ToolConfiguration;
import de.ugoe.cs.swe.common.exceptions.TerminationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class ConfigTools {
    private static ConfigTools instance = new ConfigTools(T3QConfig.class.getName(), QualityCheckProfile.class.getName());
    private ToolConfiguration config = null;
    private String configurationClassName;
    private String configurationProfileClassName;
    private String toolVersion;
    private ConfigurationProfile selectedProfile = null;

    public static ConfigTools getInstance() {
        return instance;
    }

    private ConfigTools(String configurationClassName, String configurationProfileClassName) {
        this.configurationClassName = configurationClassName;
        this.configurationProfileClassName = configurationProfileClassName;
        this.selectedProfile = new QualityCheckProfile();
    }

    public void loadConfig(String configurationFilename) throws TerminationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        System.out.println("Loading configuration ...");
        File configFile = new File(configurationFilename);
        if (configFile.exists()) {
            this.config = this.readConfig(configurationFilename);
            if (this.config == null) {
                System.out.println("ERROR: XML configuration could not be loaded! \n  Please check the configuration for consistency or use an auto-generated configuration file to migrate any custom settings!");
                throw new TerminationException("");
            }
        } else {
            System.out.println("ERROR: Configuration file \"" + configurationFilename + "\" does not exist! Use the appropriate option to generate a new default configuration.");
            throw new TerminationException("");
        }
    }

    public QualityCheckProfile qualityCheckProfile(String configFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, TerminationException {
        File f = new File(configFile);
        if (f.exists()) {
            this.loadConfig(configFile);
            return (QualityCheckProfile)this.selectProfile("defaultProfile");
        }
        this.initializeNewDefaultConfig(configFile);
        this.loadConfig(configFile);
        return (QualityCheckProfile)this.selectProfile("defaultProfile");
    }

    public ToolConfiguration initializeNewDefaultConfig(String configurationFilename) throws TerminationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        System.out.println("  Generating new default configuration in: \"" + configurationFilename + "\" ...");
        ToolConfiguration config = null;
        ConfigurationProfile configurationProfile = null;
        config = (ToolConfiguration)Class.forName(this.configurationClassName).newInstance();
        configurationProfile = (ConfigurationProfile)Class.forName(this.configurationProfileClassName).newInstance();
        configurationProfile.setProfileName("defaultProfile");
        configurationProfile.setProfileVersion(this.getToolVersion());
        config.setDefaultConfigurationProfile("all");
        if (config.getConfigurationProfiles() == null) {
            ArrayList<ConfigurationProfile> configurationProfiles = new ArrayList<ConfigurationProfile>();
            config.setConfigurationProfiles(configurationProfiles);
        }
        config.getConfigurationProfiles().add(configurationProfile);
        this.writeConfig(config, configurationFilename);
        return config;
    }

    private ToolConfiguration readConfig(String filename) throws TerminationException {
        System.out.println("  Reading XML configuration from: " + filename);
        String str = MiscTools.readFile(filename);
        XStream xstream = new XStream();
        this.initXstreamAliases(xstream);
        ToolConfiguration config = null;
        try {
            config = (ToolConfiguration)xstream.fromXML(str);
        }
        catch (ConversionException ce) {
            String line = "";
            line = ce.getMessage().split("line\\snumber[\\t\\s]+?:\\s")[1];
            line = line.substring(0, line.indexOf("\n"));
            System.out.println("  Problem Occured while loading configuration: line: " + line);
        }
        return config;
    }

    private void initXstreamAliases(XStream xstream) throws TerminationException {
        XStream.setupDefaultSecurity(xstream);
        xstream.allowTypesByWildcard(new String[]{"de.ugoe.cs.swe.TTCN3Configuration.**"});
        try {
            xstream.alias(Class.forName(this.configurationClassName).getSimpleName(), Class.forName(this.configurationClassName));
            xstream.alias(Class.forName(this.configurationProfileClassName).getSimpleName(), Class.forName(this.configurationProfileClassName));
        }
        catch (ClassNotFoundException e) {
            System.out.println("  Problem occurred while initiating XStream. Class not found: " + e.getMessage());
            throw new TerminationException("Class not found: " + e.getMessage());
        }
    }

    private void writeConfig(ToolConfiguration config, String filename) throws TerminationException {
        System.out.println("  Writing XML configuration to: " + filename);
        XStream xstream = new XStream();
        this.initXstreamAliases(xstream);
        String xml = xstream.toXML(config);
        MiscTools.writeFile(filename, "");
        try {
            OutputStreamWriter oos = new OutputStreamWriter(new FileOutputStream(filename));
            oos.write(xml);
            oos.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("  ERROR: File could not be found! (\"" + filename + "\")");
            throw new TerminationException(e.getMessage());
        }
        catch (IOException e) {
            System.out.println("  IO ERROR: Could not write to file! (\"" + filename + "\")");
            throw new TerminationException(e.getMessage());
        }
    }

    public ConfigurationProfile selectProfile(String specifiedProfileName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ConfigurationProfile selectedProfile = null;
        ConfigurationProfile allEnabledProfile = (ConfigurationProfile)Class.forName(this.configurationProfileClassName).newInstance();
        allEnabledProfile.setProfileName("all");
        allEnabledProfile.setProfileVersion(this.getToolVersion());
        this.config.getConfigurationProfiles().add(allEnabledProfile);
        if (specifiedProfileName != null) {
            System.out.println("  Selecting profile \"" + specifiedProfileName + "\"...");
            selectedProfile = this.activateProfile(specifiedProfileName);
        }
        if (selectedProfile == null) {
            if (specifiedProfileName != null) {
                System.out.println("  Profile \"" + specifiedProfileName + "\" not found in configuration. Trying default profile \"" + this.config.getDefaultConfigurationProfile() + "\".");
            } else {
                System.out.println("  No Profile specified. Trying default profile \"" + this.config.getDefaultConfigurationProfile() + "\".");
            }
            specifiedProfileName = this.config.getDefaultConfigurationProfile();
            selectedProfile = this.activateProfile(specifiedProfileName);
        }
        if (selectedProfile == null) {
            System.out.println("  Profile \"" + specifiedProfileName + "\" not found in configuration. Auto-selecting \"all\" profile.");
            selectedProfile = allEnabledProfile;
        }
        this.selectedProfile = selectedProfile;
        return selectedProfile;
    }

    public ConfigurationProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    private ConfigurationProfile activateProfile(String specifiedProfile) {
        ConfigurationProfile activatedProfile = null;
        int i = 0;
        while (i < this.config.getConfigurationProfiles().size()) {
            ConfigurationProfile configurationProfile = this.config.getConfigurationProfiles().get(i);
            if (configurationProfile.getProfileName().toLowerCase().equals(specifiedProfile.toLowerCase())) {
                System.out.println("  Activating profile \"" + specifiedProfile + "\"...");
                activatedProfile = configurationProfile;
            }
            ++i;
        }
        return activatedProfile;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }
}

