/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import de.ugoe.cs.swe.T3Q.FileParser;
import de.ugoe.cs.swe.T3Q.HttpFileServer;
import de.ugoe.cs.swe.T3Q.JsonSchemaBridge;
import de.ugoe.cs.swe.T3Q.RuntimeConfiguration;
import de.ugoe.cs.swe.T3Q.TTCN3ResourceProvider;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.T3QOptionsHandler;
import de.ugoe.cs.swe.common.exceptions.TerminationException;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class T3Q {
    private static String versionNumber = "v2.1.0b4";
    private static String supportedTTCN3Version = "4.10.1";
    private static String buildStamp = "---BUILD_STAMP---";
    public static QualityCheckProfile activeProfile = null;
    private RuntimeConfiguration runtime = new RuntimeConfiguration();
    private String configurationFilename;
    private String selectedProfileName = null;
    private static LoggingInterface.LogLevel logLevel = LoggingInterface.LogLevel.INFORMATION;
    private ArrayList<String> inputPaths = new ArrayList();
    private String destinationPath = null;
    private boolean generateNewConfiguration = false;
    private boolean generateLocalDependencies = false;
    private boolean convertJSONSchemas = false;
    private boolean convertASN1toJSONSchema = false;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private boolean analyzeUsage = false;
    private String schemaFile = "asn.json";
    private boolean serveASN1Compiler;

    public void showHelp() {
        System.out.println("\nHelp:");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(new Comparator<Option>(){

            @Override
            public int compare(Option o1, Option o2) {
                if (o1.getId() > o2.getId()) {
                    return 1;
                }
                return -1;
            }
        });
        formatter.setSyntaxPrefix("  Usage: ");
        formatter.printHelp("t3q [options] (filename | path)+", "  Options: (in any order, config is required)", new T3QOptionsHandler().getOptions(), "");
        System.out.println("");
    }

    public void run(String[] args) {
        this.stopwatch.start();
        System.out.println("T3Q " + T3Q.getVersionNumber());
        System.out.println("TTCN-3 version supported: " + supportedTTCN3Version);
        System.out.println("==========================================");
        try {
            if (!this.handleCommandLineArguments(args)) {
                return;
            }
            this.showDebugInfo(args);
            if (this.selectedProfileName != null) {
                this.handleConfig(this.selectedProfileName);
            } else {
                this.handleConfig(null);
            }
        }
        catch (TerminationException terminationException) {
            System.out.println("ERRORING OUT!");
        }
        if (this.isServeASN1Compiler()) {
            this.serveASNCompiler();
            return;
        }
        if (this.isConvertASN1toJSONSchema()) {
            this.convertASN1toJSONSchema();
        }
        if (this.isConvertJSONSchemas()) {
            this.convertJSONSchemas();
        }
        LoggingInterface logger = new LoggingInterface(activeProfile.getLoggingConfiguration());
        logger.setMaximumLogLevel(logLevel);
        TTCN3ResourceProvider resourceProvider = new TTCN3ResourceProvider(this.inputPaths, logger, activeProfile, this.runtime);
        TTCN3GlobalScopeProvider.LIVE = false;
        resourceProvider.loadResources();
        if (!this.isGenerateLocalDependencies() && !this.isAnalyzeUsage()) {
            resourceProvider.analyzeResources();
        } else if (this.isAnalyzeUsage()) {
            resourceProvider.analyzeUsage();
        } else {
            resourceProvider.analyzeDependencies();
        }
        if (activeProfile.isGenerateXMI()) {
            resourceProvider.createXMI();
        }
        resourceProvider.printStatistics();
        this.stopwatch.stop();
        System.out.println("Total processing time: " + MiscTools.msToString(this.stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " minutes.\n");
    }

    private void convertASN1toJSONSchema() {
        ArrayList<String> asn1Paths = new ArrayList<String>();
        for (String path : this.inputPaths) {
            File file = new File(path);
            if (file.isFile() && file.getName().endsWith(".asn")) {
                asn1Paths.add(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            Collection<File> files = FileUtils.listFiles(file, new RegexFileFilter("^.*asn$"), DirectoryFileFilter.DIRECTORY);
            for (File f : files) {
                asn1Paths.add(f.getAbsolutePath());
            }
        }
        JsonSchemaBridge bridge = new JsonSchemaBridge();
        if (!asn1Paths.isEmpty()) {
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            stopwatch.start();
            System.out.println("Converting " + String.valueOf(asn1Paths) + " ASN.1 files to JSON Schema...");
            bridge.convertASN1toJSONSchema(activeProfile.getTitanCompilerPath(), asn1Paths, activeProfile.getJsonSchemaPath() + this.schemaFile);
            System.out.println("Converted " + String.valueOf(asn1Paths) + " ASN.1 files to JSON Schema in " + MiscTools.msToString(stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " minutes.\n");
            stopwatch.stop();
            this.inputPaths.add(activeProfile.getJsonSchemaPath() + this.schemaFile);
        }
    }

    private void convertJSONSchemas() {
        JsonSchemaBridge bridge = new JsonSchemaBridge();
        ArrayList<String> processedSchemas = new ArrayList<String>();
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        ArrayList<Path> outputPaths = new ArrayList<Path>();
        for (String path : this.inputPaths) {
            File file = new File(path);
            if (file.isFile()) {
                try {
                    if (!file.isFile() || !file.getName().endsWith(this.schemaFile)) continue;
                    stopwatch.start();
                    List<Path> paths = bridge.process(file.getAbsolutePath());
                    outputPaths.addAll(paths);
                    System.out.println("Converted JSON Schema " + file.getAbsolutePath() + " to TTCN-3 in " + MiscTools.msToString(stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " minutes.\n");
                    stopwatch.stop();
                    processedSchemas.add(path);
                }
                catch (Exception e) {
                    T3Q.logException(e);
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            Collection<File> files = FileUtils.listFiles(file, new RegexFileFilter("^.*" + this.schemaFile + "$"), DirectoryFileFilter.DIRECTORY);
            for (File f : files) {
                try {
                    stopwatch.start();
                    List<Path> paths = bridge.process(f.getAbsolutePath());
                    outputPaths.addAll(paths);
                    System.out.println("Converted JSON Schema " + file.getAbsolutePath() + " to TTCN-3 in " + MiscTools.msToString(stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " minutes.\n");
                    stopwatch.stop();
                    processedSchemas.add(f.getAbsolutePath());
                }
                catch (Exception e) {
                    T3Q.logException(e);
                }
            }
        }
        for (String s2 : processedSchemas) {
            if (!this.inputPaths.contains(s2)) continue;
            this.inputPaths.remove(s2);
        }
        for (Path p : outputPaths) {
            this.inputPaths.add(p.toString());
        }
    }

    public static void main(String[] args) {
        try {
            T3Q tool = new T3Q();
            tool.run(args);
        }
        catch (Exception e) {
            T3Q.logException(e);
        }
    }

    private static void logException(Exception e) {
        if (T3Q.getLogLevel() == LoggingInterface.LogLevel.DEBUG) {
            e.printStackTrace();
        } else {
            Object stacktrace = "";
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                stacktrace = (String)stacktrace + "\n    " + ste.toString();
                ++n2;
            }
            System.err.println("ERROR: A problem occurred while running T3Q\n  Problem type: " + String.valueOf(e) + "\n  Stacktrace:" + (String)stacktrace + "\n  Run T3Q with --verbosity=DEBUG for a more detailed report");
        }
    }

    private boolean handleCommandLineArguments(String[] args) throws TerminationException {
        CommandLine commandLine = this.parseCommandLineArguments(args);
        if (commandLine == null) {
            return false;
        }
        String[] arguments = this.evaluateCommandLineOptions(commandLine);
        if (commandLine.hasOption("help")) {
            this.showHelp();
            return false;
        }
        if (commandLine.hasOption("config") && arguments.length < 1) {
            System.out.println("ERROR: Missing input location(s)");
            this.showHelp();
            return false;
        }
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.inputPaths.add(arg);
            ++n2;
        }
        return true;
    }

    private void serveASNCompiler() {
        Path workDir = Paths.get("./", new String[0]);
        try {
            Files.createDirectories(workDir, new FileAttribute[0]);
            HttpFileServer.ExternalCommandProcessor cmdProcessor = new HttpFileServer.ExternalCommandProcessor(activeProfile.getTitanCompilerPath(), List.of(), workDir);
            HttpFileServer server = new HttpFileServer(3005, cmdProcessor);
            server.start();
            System.out.println("Server ready at http://localhost:3005/compile_asn. Test with:");
            System.out.println("curl -X POST -F 'file=@test.txt' http://localhost:3005/compile_asn");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CommandLine parseCommandLineArguments(String[] args) {
        DefaultParser parser = new DefaultParser();
        T3QOptionsHandler optionsHandler = new T3QOptionsHandler();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(optionsHandler.getOptions(), args);
        }
        catch (ParseException e) {
            System.out.println("ERROR: " + e.getMessage());
            this.showHelp();
        }
        return commandLine;
    }

    private String[] evaluateCommandLineOptions(CommandLine commandLine) throws TerminationException {
        if (commandLine.hasOption("generate-config")) {
            this.setConfigurationFilename(commandLine.getOptionValue("generate-config"));
            this.setGenerateNewConfiguration(true);
        } else if (commandLine.hasOption("config")) {
            this.setConfigurationFilename(commandLine.getOptionValue("config"));
        } else {
            System.out.println("ERROR: No configuration file selected!");
            this.showHelp();
            throw new TerminationException("");
        }
        if (commandLine.hasOption("profile")) {
            this.setSelectedProfileName(commandLine.getOptionValue("profile"));
        }
        if (commandLine.hasOption("single-core")) {
            this.runtime.setSingleCore(true);
        }
        if (commandLine.hasOption("log-unresolved")) {
            this.runtime.setLogUnresolved(true);
        }
        if (commandLine.hasOption("batch-resolve")) {
            this.runtime.setBatchResolve(true);
        }
        if (commandLine.hasOption("analyze-usage")) {
            this.setAnalyzeUsage(true);
        }
        if (commandLine.hasOption("convert-asn1-to-schema")) {
            this.setConvertASN1toJSONSchema(true);
        }
        if (commandLine.hasOption("convert-schemas")) {
            this.setConvertJSONSchemas(true);
        }
        if (commandLine.hasOption("verbosity")) {
            this.selectLogLevel(commandLine.getOptionValue("verbosity"));
        }
        if (commandLine.hasOption("output-path")) {
            this.setDestinationPath(commandLine.getOptionValue("output-path"));
        }
        if (commandLine.hasOption("local-dependencies")) {
            this.setGenerateLocalDependencies(true);
        }
        if (commandLine.hasOption("serve-asn1-compiler")) {
            this.setServeASN1Compiler(true);
        }
        return commandLine.getArgs();
    }

    private void handleConfig(String specifiedProfile) throws TerminationException {
        ConfigTools configTools = ConfigTools.getInstance();
        configTools.setToolVersion(T3Q.getVersionNumber());
        try {
            if (this.isGenerateNewConfiguration()) {
                configTools.initializeNewDefaultConfig(this.getConfigurationFilename());
                System.exit(0);
            } else {
                configTools.loadConfig(this.getConfigurationFilename());
                activeProfile = (QualityCheckProfile)configTools.selectProfile(specifiedProfile);
                if (this.getDestinationPath() == null) {
                    if (this.isGenerateLocalDependencies()) {
                        this.setDestinationPath(activeProfile.getDependencyOutputPath());
                    } else {
                        this.setDestinationPath(activeProfile.getPathFormattedOutputPath());
                    }
                } else if (this.isGenerateLocalDependencies()) {
                    activeProfile.setDependencyOutputPath(this.getDestinationPath());
                } else {
                    activeProfile.setPathFormattedOutputPath(this.getDestinationPath());
                }
            }
        }
        catch (InstantiationException e) {
            throw new TerminationException("ERROR: Instantiation problems encountered while loading configuration profile. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new TerminationException("ERROR: Instantiation problems encountered while loading configuration profile. " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new TerminationException("ERROR: Instantiation problems encountered while loading configuration profile. " + e.getMessage());
        }
        if (!this.isProfileVersionValid()) {
            System.out.println("\nERROR: Selected profile \"" + activeProfile.getProfileName() + "\" has a mismatching or no version (required: \"" + T3Q.getVersionNumber() + "\").\n  Consider upgrading the profile by transfering the relevant parts to an auto-generated profile or selecting a different profile.\n");
            throw new TerminationException("");
        }
    }

    private boolean isProfileVersionValid() {
        return activeProfile.getProfileVersion() != null && activeProfile.getProfileVersion().equals(T3Q.getVersionNumber());
    }

    private void selectLogLevel(String logLevel) throws TerminationException {
        boolean selected = false;
        Object possibleValues = "";
        LoggingInterface.LogLevel[] logLevelArray = LoggingInterface.LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoggingInterface.LogLevel l = logLevelArray[n2];
            if (l.toString().equals(logLevel)) {
                T3Q.setLogLevel(l);
                selected = true;
                System.out.println("Selected log level \"" + logLevel + "\"");
            }
            if (!l.toString().equals("FIXME") && !l.toString().equals("DEBUG")) {
                possibleValues = (String)possibleValues + l.toString() + ", ";
            }
            FileParser.printParsingErrors = true;
            this.runtime.setLogUnresolved(true);
            ++n2;
        }
        if (!selected) {
            System.out.println("\nERROR: No valid log level provided! Possible values are (in ascending inclusive order): " + ((String)possibleValues).substring(0, ((String)possibleValues).length() - 2) + ".");
            throw new TerminationException("");
        }
    }

    private void showDebugInfo(String[] args) {
        if (T3Q.getLogLevel().equals((Object)LoggingInterface.LogLevel.DEBUG)) {
            System.out.println("==================ARGS:===================");
            int a = 0;
            while (a < args.length) {
                System.out.println("   " + args[a]);
                ++a;
            }
            System.out.println("==================PROPERTIES:=============");
            for (Object key : System.getProperties().keySet()) {
                System.out.println("   " + key.toString() + " : " + System.getProperty(key.toString()));
            }
            System.out.println("==========================================");
        }
    }

    public static void setVersionNumber(String versionNumber) {
        T3Q.versionNumber = versionNumber;
    }

    public static String getVersionNumber() {
        return versionNumber;
    }

    public void setConfigurationFilename(String configurationFilename) {
        this.configurationFilename = configurationFilename;
    }

    public String getConfigurationFilename() {
        return this.configurationFilename;
    }

    public static void setLogLevel(LoggingInterface.LogLevel logLevel) {
        T3Q.logLevel = logLevel;
    }

    public static LoggingInterface.LogLevel getLogLevel() {
        return logLevel;
    }

    public void setSelectedProfileName(String selectedProfileName) {
        this.selectedProfileName = selectedProfileName;
    }

    public String getSelectedProfileName() {
        return this.selectedProfileName;
    }

    public void setGenerateNewConfiguration(boolean generateNewConfiguration) {
        this.generateNewConfiguration = generateNewConfiguration;
    }

    public boolean isGenerateNewConfiguration() {
        return this.generateNewConfiguration;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public static void setBuildStamp(String buildStamp) {
        T3Q.buildStamp = buildStamp;
    }

    public static String getBuildStamp() {
        return buildStamp;
    }

    private static List<String> readFile(String filename) throws FileNotFoundException, IOException {
        ArrayList<String> file = Lists.newArrayList();
        FileInputStream stream = new FileInputStream(filename);
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader buffer = new BufferedReader(reader);
        String line = buffer.readLine();
        while (line != null) {
            file.add(line);
            line = buffer.readLine();
        }
        buffer.close();
        reader.close();
        stream.close();
        return file;
    }

    private static void findTabs(String filename, List<String> file) {
        if (!activeProfile.isCheckNoTabs()) {
            return;
        }
        int i = 0;
        while (i < file.size()) {
            String line = file.get(i);
            int j = 0;
            while (j < line.length()) {
                if (line.charAt(j) == '\t') {
                    String[] position = new String[]{Integer.toString(i + 1), Integer.toString(j)};
                    if (TTCN3GlobalScopeProvider.FOUND_TABS.containsKey(filename)) {
                        TTCN3GlobalScopeProvider.FOUND_TABS.get(filename).add(position);
                    } else {
                        ArrayList<String[]> list = Lists.newArrayList();
                        list.add(position);
                        TTCN3GlobalScopeProvider.FOUND_TABS.put(filename, list);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static int countLines(File data) throws IOException {
        List<String> file = T3Q.readFile(data.getPath());
        T3Q.findTabs(data.getName(), file);
        if (file != null) {
            return file.size();
        }
        return 0;
    }

    public boolean isGenerateLocalDependencies() {
        return this.generateLocalDependencies;
    }

    public void setGenerateLocalDependencies(boolean generateLocalDependencies) {
        this.generateLocalDependencies = generateLocalDependencies;
    }

    public boolean isAnalyzeUsage() {
        return this.analyzeUsage;
    }

    public void setAnalyzeUsage(boolean analyzeUsage) {
        this.analyzeUsage = analyzeUsage;
    }

    public boolean isConvertJSONSchemas() {
        return this.convertJSONSchemas;
    }

    public void setConvertJSONSchemas(boolean convertJSONSchemas) {
        this.convertJSONSchemas = convertJSONSchemas;
    }

    public boolean isConvertASN1toJSONSchema() {
        return this.convertASN1toJSONSchema;
    }

    public void setConvertASN1toJSONSchema(boolean convertASN1toJSONSchema) {
        this.convertASN1toJSONSchema = convertASN1toJSONSchema;
    }

    public boolean isServeASN1Compiler() {
        return this.serveASN1Compiler;
    }

    public void setServeASN1Compiler(boolean serveASN1Compiler) {
        this.serveASN1Compiler = serveASN1Compiler;
    }
}

