/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.ugoe.cs.swe.T3Q.HttpFileClient;
import de.ugoe.cs.swe.T3Q.T3Q;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonSchemaBridge {
    StringBuilder ttcn = new StringBuilder();
    boolean logStructure = false;

    public void convertASN1toJSONSchema(String titanCompilerPath, List<String> asnFilePaths, String targetPath) {
        if (titanCompilerPath.startsWith("http")) {
            this.convertASN1toJSONSchemaRemote(titanCompilerPath, asnFilePaths, targetPath);
        } else {
            this.convertASN1toJSONSchemaLocal(titanCompilerPath, asnFilePaths, targetPath);
        }
    }

    public void convertASN1toJSONSchemaRemote(String titanCompilerPath, List<String> asnFilePaths, String targetPath) {
        HashMap<String, Path> files = new HashMap<String, Path>();
        int i = 1;
        for (String p : asnFilePaths) {
            files.put("file" + i, Paths.get(p, new String[0]));
            ++i;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("backend", "titan");
        fields.put("command", "compiler");
        fields.put("target", "ttcn-3");
        try {
            HttpFileClient.ApiResponse response = HttpFileClient.uploadFiles(titanCompilerPath, files, fields);
            this.log("\nASN.1 files submitted..:");
            this.log("Status: " + response.getStatusCode());
            String body = response.getJsonBody();
            Files.writeString(Path.of(targetPath, new String[0]), (CharSequence)body, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void convertASN1toJSONSchemaLocal(String titanCompilerPath, List<String> asnFilePaths, String targetPath) {
        Process process = null;
        try {
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.add(titanCompilerPath);
                command.add("--ttcn2json");
                command.addAll(asnFilePaths);
                command.add("-");
                command.add(targetPath);
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                if (T3Q.getLogLevel() == LoggingInterface.LogLevel.DEBUG) {
                    this.log("Running Compiler: " + String.join((CharSequence)" ", command));
                }
                processBuilder.redirectErrorStream(true);
                process = processBuilder.start();
                Throwable throwable = null;
                Object var8_11 = null;
                try (InputStream inputStream = process.getInputStream();){
                    byte[] output = inputStream.readAllBytes();
                    if (T3Q.getLogLevel() == LoggingInterface.LogLevel.DEBUG) {
                        this.log("Titan Compiler output: \n" + new String(output).replaceAll("\n", "\nTITAN: "));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    System.err.println("ERROR: Execution problems encountered while converting ASN.1 files to JSON with Titan");
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: Execution problems encountered while converting ASN.1 files to JSON with Titan: " + e.getLocalizedMessage());
                if (process != null) {
                    process.destroy();
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private void append(String s2) {
        this.ttcn.append(s2);
    }

    private void log(String message) {
        if (T3Q.getLogLevel() == LoggingInterface.LogLevel.DEBUG) {
            System.out.println(message);
        }
    }

    private void logStructure(String message) {
        if (this.logStructure) {
            System.out.println(message);
        }
    }

    public List<Path> process(String path) throws Exception {
        JsonElement jsonElement = JsonParser.parseReader(new FileReader(path));
        ArrayList<Path> outputPaths = new ArrayList<Path>();
        this.logStructure("");
        int definitionsCount = 0;
        for (Map.Entry<String, JsonElement> d : jsonElement.getAsJsonObject().get("definitions").getAsJsonObject().entrySet()) {
            this.logStructure(d.getKey());
            this.append("module " + d.getKey() + " {\n");
            for (Map.Entry<String, JsonElement> e : d.getValue().getAsJsonObject().entrySet()) {
                this.logStructure("  " + e.getKey());
                this.processObject(e.getKey(), e.getValue().getAsJsonObject(), "  ", false);
                this.append("\n\n");
                ++definitionsCount;
            }
            this.append("}\n\n");
            Path outputPath = Path.of(path + "." + d.getKey() + ".ttcn", new String[0]);
            Files.writeString(outputPath, (CharSequence)this.ttcn, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            this.logStructure("Converted " + definitionsCount + " definitions in " + d.getKey());
            definitionsCount = 0;
            this.ttcn.delete(0, this.ttcn.length());
            outputPaths.add(outputPath);
        }
        return outputPaths;
    }

    private boolean isOptional(JsonObject o) {
        return o.get("anyOf") != null && o.get("anyOf").getAsJsonArray().get(0).getAsJsonObject().get("type").getAsString().equals("null");
    }

    private void processObject(String name, JsonObject o, String prefix, boolean skipBraces) {
        if (o.get("anyOf") != null) {
            this.processAnyOf(name, o, prefix);
        } else if (o.get("enum") != null) {
            this.processEnum(name, o, prefix);
        } else if (o.get("$ref") != null) {
            this.processRef(name, o, prefix);
        } else {
            String type = o.get("type").getAsString();
            if (type.equals("object")) {
                this.processStructured(name, o, prefix, skipBraces);
            } else if (type.equals("array")) {
                this.processArray(name, o, prefix);
            } else if (type.equals("null")) {
                this.logStructure(prefix + "  OPTIONAL?");
                this.append("anytype ");
            } else if (o.get("type").isJsonPrimitive()) {
                this.processPrimitive(name, o, prefix, type);
            } else {
                this.log(prefix + "  UNSUPPORTED TYPE: " + type);
            }
        }
    }

    private void processPrimitive(String name, JsonObject o, String prefix, String type) {
        JsonElement subType = o.get("subType");
        this.logStructure(prefix + "  PRIMITIVE: " + type);
        if (subType == null) {
            subType = new JsonPrimitive(type);
        }
        this.preamble(name, prefix, subType);
    }

    private void processArray(String name, JsonObject o, String prefix) {
        JsonElement subType = o.get("subType");
        JsonObject itemType = o.get("items").getAsJsonObject();
        this.append(prefix);
        if (name != null) {
            this.append("type ");
        }
        if (subType != null) {
            this.append(subType.getAsString() + " ");
        }
        this.processObject(null, itemType, prefix, false);
        if (name != null) {
            this.append(name + " ");
        }
        this.append("");
    }

    private void processStructured(String name, JsonObject o, String prefix, boolean skipBraces) {
        JsonElement subType = o.get("subType");
        this.logStructure(prefix + "->[object:" + String.valueOf(subType) + "]");
        this.preamble(name, prefix, subType);
        if (!skipBraces) {
            this.append("{\n");
        }
        JsonObject props = o.get("properties").getAsJsonObject();
        int pi = 1;
        for (Map.Entry<String, JsonElement> p : props.entrySet()) {
            this.logStructure(prefix + "  " + p.getKey());
            JsonObject pDescription = p.getValue().getAsJsonObject();
            this.append(prefix + "  ");
            this.processObject(null, pDescription, prefix + "  ", false);
            String opt = "";
            if (this.isOptional(pDescription)) {
                opt = " optional";
            }
            this.append(p.getKey() + opt);
            if (pi < props.entrySet().size()) {
                this.append(",");
                this.append("\n");
            }
            ++pi;
        }
        if (!skipBraces) {
            this.append("\n" + prefix + "} ");
        }
        o.get("required");
    }

    private void processRef(String name, JsonObject o, String prefix) {
        String refName = Arrays.asList(o.get("$ref").getAsString().split("/")).getLast();
        if (refName.startsWith("_")) {
            refName = refName.substring(1);
        }
        this.logStructure(prefix + "->[ref] " + refName + " : " + o.get("$ref").getAsString());
        if (name != null) {
            this.append(prefix);
            this.append("type ");
        }
        this.append(refName + " ");
        if (name != null) {
            this.append(name + " ");
        }
    }

    private void processEnum(String name, JsonObject o, String prefix) {
        this.logStructure(prefix + "->[enum]");
        for (JsonElement en : o.get("enum").getAsJsonArray()) {
            this.logStructure(prefix + "  " + en.getAsString());
        }
        this.preamble(name, prefix, new JsonPrimitive("enumerated"));
        if (name == null) {
            this.append("{\n" + prefix + "  ");
        } else {
            this.append("{\n" + prefix + "  ");
        }
        int ei = 1;
        JsonArray enums = o.get("enum").getAsJsonArray();
        for (JsonElement en : enums) {
            this.append(en.getAsString());
            if (ei < enums.size()) {
                this.append(", ");
            }
            ++ei;
        }
        if (name == null) {
            this.append("\n" + prefix + "} ");
        } else {
            this.append("\n" + prefix + "} ");
        }
    }

    private void processAnyOf(String name, JsonObject o, String prefix) {
        this.logStructure(prefix + "->[union]");
        if (this.isOptional(o)) {
            JsonObject opt = o.get("anyOf").getAsJsonArray().get(1).getAsJsonObject();
            this.processObject(null, opt, prefix + "  ", false);
        } else {
            this.preamble(name, prefix, new JsonPrimitive("union"));
            this.append("{\n");
            int ui = 1;
            JsonArray uItems = o.get("anyOf").getAsJsonArray();
            for (JsonElement u : uItems) {
                JsonObject uo = u.getAsJsonObject();
                this.processObject(null, uo, prefix + "  ", true);
                if (ui < uItems.size()) {
                    this.append(",");
                    this.append("\n");
                }
                ++ui;
            }
            this.append("\n");
            if (name != null) {
                this.append(prefix + "} ");
            } else {
                this.append(prefix + "  } ");
            }
        }
    }

    private void preamble(String name, String prefix, JsonElement subType) {
        if (name != null) {
            this.append(prefix);
            this.append("type ");
        }
        if (subType != null) {
            this.append(subType.getAsString() + " ");
        }
        if (name != null) {
            this.append(name + " ");
        }
    }

    private void dumpJson(String prefix, Map.Entry<String, JsonElement> e) {
        this.logStructure("");
        this.logStructure(prefix + "  " + e.getKey() + ":");
        this.dumpJson(prefix + "  ", e.getValue());
    }

    private void dumpJson(String prefix, JsonElement e) {
        if (e.isJsonArray()) {
            ((JsonArray)e).forEach(a -> this.dumpJson(prefix + "  ", (JsonElement)a));
        } else if (e.isJsonObject()) {
            ((JsonObject)e).entrySet().forEach(a -> this.dumpJson(prefix + "  ", (Map.Entry<String, JsonElement>)a));
        } else if (e.isJsonPrimitive()) {
            this.logStructure("  " + String.valueOf(e));
        }
    }
}

