/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpFileServer {
    private static final String TEMP_DIR_PREFIX = "fileserver_";
    private final HttpServer server;
    private final ExecutorService executor;
    private final FileProcessor processor;

    public HttpFileServer(int port, FileProcessor processor) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.executor = Executors.newFixedThreadPool(10);
        this.processor = processor;
        this.server.setExecutor(this.executor);
        this.server.createContext("/compile_asn", new UploadHandler(processor));
        this.server.createContext("/health", new HealthHandler());
    }

    public void start() {
        this.server.start();
        System.out.println("Server started on port " + this.server.getAddress().getPort());
    }

    public void stop() {
        this.server.stop(0);
        this.executor.shutdown();
    }

    private static void sendError(HttpExchange exchange, int code, String message) throws IOException {
        String json = String.format("{\"error\":\"%s\"}", message);
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        exchange.sendResponseHeaders(code, json.length());
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream os = exchange.getResponseBody();){
            os.write(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void cleanupDirectory(Path dir) {
        try {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {}
            });
        }
        catch (IOException iOException) {}
    }

    public static void main(String[] args) {
        try {
            FileProcessor cfr_ignored_0 = (files, fields) -> {
                Path jsonFile = Files.createTempFile("result_", ".json", new FileAttribute[0]);
                StringBuilder json = new StringBuilder("{");
                json.append("\"filesProcessed\":").append(files.size()).append(",");
                json.append("\"files\":[");
                int i = 0;
                for (Map.Entry entry : files.entrySet()) {
                    if (i++ > 0) {
                        json.append(",");
                    }
                    json.append("{").append("\"field\":\"").append((String)entry.getKey()).append("\",").append("\"filename\":\"").append(((Path)entry.getValue()).getFileName()).append("\",").append("\"size\":").append(Files.size((Path)entry.getValue())).append("}");
                }
                json.append("]}");
                Files.write(jsonFile, json.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                return jsonFile;
            };
            Path workDir = Paths.get("./", new String[0]);
            Files.createDirectories(workDir, new FileAttribute[0]);
            ExternalCommandProcessor cmdProcessor = new ExternalCommandProcessor("./compiler", List.of(), workDir);
            HttpFileServer server = new HttpFileServer(3005, cmdProcessor);
            server.start();
            System.out.println("Server ready. Test with:");
            System.out.println("curl -X POST -F 'file=@test.txt' http://localhost:3005/compile_asn");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ExternalCommandProcessor
    implements FileProcessor {
        private final String command;
        private final Path workDir;
        private List<String> arguments;

        public ExternalCommandProcessor(String command, List<String> arguments, Path workDir) {
            this.command = command;
            this.arguments = arguments;
            this.workDir = workDir;
        }

        @Override
        public Path process(Map<String, Path> files, Map<String, String> fields) throws Exception {
            String output;
            String jsonFile = "asn.json";
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.command);
            cmd.add("--ttcn2json");
            for (Path file : files.values()) {
                cmd.add(file.toString());
            }
            cmd.add("-");
            cmd.add(jsonFile);
            System.out.println("SERVER: Running " + String.valueOf(cmd));
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(this.workDir.toFile());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            Throwable throwable = null;
            Object var9_10 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                output = reader.lines().reduce((a, b) -> a + "\n" + b).orElse("");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.out.println(output.replaceAll("\n", "\nTITAN: "));
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Command failed with exit code " + exitCode + ": " + output);
            }
            File wd = this.workDir.toFile();
            String jsonPath = new File(wd, jsonFile).getAbsolutePath();
            Path result = Paths.get(jsonPath, new String[0]);
            if (!Files.exists(result, new LinkOption[0])) {
                throw new FileNotFoundException("Expected JSON file not found: " + jsonPath);
            }
            return result;
        }
    }

    public static interface FileProcessor {
        public Path process(Map<String, Path> var1, Map<String, String> var2) throws Exception;
    }

    static class HealthHandler
    implements HttpHandler {
        HealthHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String response = "{\"status\":\"ok\"}";
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, response.length());
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    static class MultipartData {
        Map<String, Path> files = new HashMap<String, Path>();
        Map<String, String> fields = new HashMap<String, String>();

        MultipartData() {
        }
    }

    static class MultipartParser {
        private final InputStream input;
        private final String boundary;
        private final Path tempDir;

        public MultipartParser(InputStream input, String boundary, Path tempDir) {
            this.input = input;
            this.boundary = boundary;
            this.tempDir = tempDir;
        }

        public MultipartData parse() throws IOException {
            MultipartData data = new MultipartData();
            BufferedInputStream bis = new BufferedInputStream(this.input);
            System.out.println("DEBUG: Starting parse, boundary=" + this.boundary);
            String firstBoundary = "--" + this.boundary;
            if (!this.findBoundary(bis, firstBoundary.getBytes(StandardCharsets.UTF_8))) {
                System.out.println("DEBUG: Could not find first boundary");
                return data;
            }
            System.out.println("DEBUG: Found first boundary");
            while (true) {
                bis.mark(4);
                int c1 = bis.read();
                int c2 = bis.read();
                System.out.println("DEBUG: After boundary, next chars: '" + (char)c1 + "' '" + (char)c2 + "'");
                if (c1 == 45 && c2 == 45) {
                    System.out.println("DEBUG: Found end boundary");
                    break;
                }
                bis.reset();
                this.skipLine(bis);
                Map<String, String> headers = this.readHeaders(bis);
                System.out.println("DEBUG: Read headers: " + String.valueOf(headers));
                if (headers.isEmpty()) {
                    System.out.println("DEBUG: No headers found, ending parse");
                    break;
                }
                byte[] partData = this.readUntilBoundary(bis);
                System.out.println("DEBUG: Read part data: " + partData.length + " bytes");
                this.processPart(headers, partData, data);
                System.out.println("DEBUG: Files so far: " + data.files.size() + ", Fields: " + data.fields.size());
            }
            System.out.println("DEBUG: Parse complete. Files: " + data.files.size() + ", Fields: " + data.fields.size());
            return data;
        }

        private boolean findBoundary(InputStream is, byte[] boundaryBytes) throws IOException {
            int b;
            ArrayList<Integer> window = new ArrayList<Integer>();
            while ((b = is.read()) != -1) {
                window.add(b);
                if (window.size() > boundaryBytes.length) {
                    window.remove(0);
                }
                if (window.size() != boundaryBytes.length) continue;
                boolean match = true;
                int i = 0;
                while (i < boundaryBytes.length) {
                    if ((Integer)window.get(i) != (boundaryBytes[i] & 0xFF)) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return true;
            }
            return false;
        }

        private byte[] readUntilBoundary(InputStream is) throws IOException {
            int b;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            String boundaryMarker = "\r\n--" + this.boundary;
            byte[] boundaryBytes = boundaryMarker.getBytes(StandardCharsets.UTF_8);
            ArrayList<Integer> window = new ArrayList<Integer>();
            while ((b = is.read()) != -1) {
                window.add(b);
                if (window.size() > boundaryBytes.length) {
                    buffer.write((Integer)window.remove(0));
                }
                if (window.size() != boundaryBytes.length) continue;
                boolean match = true;
                int i = 0;
                while (i < boundaryBytes.length) {
                    if ((Integer)window.get(i) != (boundaryBytes[i] & 0xFF)) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return buffer.toByteArray();
            }
            Iterator iterator = window.iterator();
            while (iterator.hasNext()) {
                int val = (Integer)iterator.next();
                buffer.write(val);
            }
            return buffer.toByteArray();
        }

        private void skipLine(InputStream is) throws IOException {
            int b;
            while ((b = is.read()) != -1) {
                if (b == 10) break;
            }
        }

        private Map<String, String> readHeaders(BufferedInputStream is) throws IOException {
            int b;
            HashMap<String, String> headers = new HashMap<String, String>();
            ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream();
            int prev = 0;
            while ((b = is.read()) != -1) {
                if (b == 10 && prev == 13) {
                    byte[] lineBytes = lineBuffer.toByteArray();
                    if (lineBytes.length <= 1) break;
                    String line = new String(lineBytes, 0, lineBytes.length - 1, StandardCharsets.UTF_8);
                    int colon = line.indexOf(58);
                    if (colon > 0) {
                        String name = line.substring(0, colon).trim();
                        String value = line.substring(colon + 1).trim();
                        headers.put(name.toLowerCase(), value);
                    }
                    lineBuffer.reset();
                } else {
                    lineBuffer.write(b);
                }
                prev = b;
            }
            return headers;
        }

        private void processPart(Map<String, String> headers, byte[] data, MultipartData result) throws IOException {
            String disposition = headers.get("content-disposition");
            if (disposition == null) {
                return;
            }
            String name = this.extractValue(disposition, "name");
            String filename = this.extractValue(disposition, "filename");
            if (filename != null && !filename.isEmpty()) {
                Path filePath = this.tempDir.resolve(filename);
                Files.write(filePath, data, new OpenOption[0]);
                result.files.put(name, filePath);
            } else if (name != null) {
                result.fields.put(name, new String(data, StandardCharsets.UTF_8).trim());
            }
        }

        private String extractValue(String header, String key) {
            int start = header.indexOf(key + "=\"");
            if (start == -1) {
                return null;
            }
            int end = header.indexOf("\"", start += key.length() + 2);
            if (end == -1) {
                return null;
            }
            return header.substring(start, end);
        }
    }

    static class UploadHandler
    implements HttpHandler {
        private final FileProcessor processor;

        public UploadHandler(FileProcessor processor) {
            this.processor = processor;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            System.out.println("SERVER: Received request: " + exchange.getRequestMethod() + " " + String.valueOf(exchange.getRequestURI()));
            if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                HttpFileServer.sendError(exchange, 405, "Method not allowed");
                return;
            }
            Path tempDir = null;
            try {
                System.out.println("SERVER: Creating temp directory");
                tempDir = Files.createTempDirectory(HttpFileServer.TEMP_DIR_PREFIX, new FileAttribute[0]);
                String contentType = exchange.getRequestHeaders().getFirst("Content-Type");
                System.out.println("SERVER: Content-Type: " + contentType);
                if (contentType == null || !contentType.startsWith("multipart/form-data")) {
                    HttpFileServer.sendError(exchange, 400, "Expected multipart/form-data");
                    return;
                }
                String boundary = this.extractBoundary(contentType);
                System.out.println("SERVER: Extracted boundary: " + boundary);
                if (boundary == null) {
                    HttpFileServer.sendError(exchange, 400, "No boundary found in Content-Type");
                    return;
                }
                System.out.println("SERVER: Starting multipart parse");
                MultipartParser parser = new MultipartParser(exchange.getRequestBody(), boundary, tempDir);
                MultipartData data = parser.parse();
                System.out.println("SERVER: Parse complete, files=" + data.files.size() + ", fields=" + data.fields.size());
                if (data.files.isEmpty()) {
                    HttpFileServer.sendError(exchange, 400, "No files uploaded");
                    return;
                }
                System.out.println("SERVER: Processing files");
                Path jsonResult = this.processor.process(data.files, data.fields);
                if (jsonResult == null || !Files.exists(jsonResult, new LinkOption[0])) {
                    HttpFileServer.sendError(exchange, 500, "Processing failed to produce result");
                    return;
                }
                try {
                    System.out.println("SERVER: Sending response");
                    byte[] jsonBytes = Files.readAllBytes(jsonResult);
                    exchange.getResponseHeaders().set("Content-Type", "application/json");
                    exchange.sendResponseHeaders(200, jsonBytes.length);
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (OutputStream os = exchange.getResponseBody();){
                        os.write(jsonBytes);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    System.out.println("SERVER: Response sent successfully");
                    Files.deleteIfExists(jsonResult);
                }
                catch (Exception e) {
                    System.err.println("SERVER: Error occurred");
                    e.printStackTrace();
                    HttpFileServer.sendError(exchange, 500, "Processing error: " + e.getMessage());
                }
            }
            finally {
                if (tempDir != null) {
                    System.out.println("SERVER: Cleaning up temp directory");
                    HttpFileServer.cleanupDirectory(tempDir);
                }
            }
        }

        private String extractBoundary(String contentType) {
            String[] parts;
            String[] stringArray = parts = contentType.split(";");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if ((part = part.trim()).startsWith("boundary=")) {
                    return part.substring(9);
                }
                ++n2;
            }
            return null;
        }
    }
}

