/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import de.ugoe.cs.swe.T3Q.T3Q;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpFileClient {
    private static final String CRLF = "\r\n";
    private static final String BOUNDARY = "----WebKitFormBoundary" + System.currentTimeMillis();

    public static ApiResponse uploadFiles(String url, Map<String, Path> files, Map<String, String> additionalFields) throws IOException {
        HttpFileClient.log("CLIENT: Starting upload to " + url);
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        try {
            HttpFileClient.log("CLIENT: Configuring connection");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setChunkedStreamingMode(8192);
            HttpFileClient.log("CLIENT: Getting output stream");
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream out = conn.getOutputStream();){
                HttpFileClient.log("CLIENT: Got output stream, writing data");
                if (additionalFields != null) {
                    for (Map.Entry<String, Object> entry : additionalFields.entrySet()) {
                        HttpFileClient.log("CLIENT: Writing field: " + entry.getKey());
                        HttpFileClient.writeField(out, entry.getKey(), (String)entry.getValue());
                    }
                }
                for (Map.Entry<String, Object> entry : files.entrySet()) {
                    HttpFileClient.log("CLIENT: Writing file: " + String.valueOf(((Path)entry.getValue()).getFileName()));
                    HttpFileClient.writeFile(out, entry.getKey(), (Path)entry.getValue());
                }
                HttpFileClient.log("CLIENT: Writing end boundary");
                String string = "--" + BOUNDARY + "--\r\n";
                out.write(string.getBytes(StandardCharsets.UTF_8));
                out.flush();
                HttpFileClient.log("CLIENT: Finished writing request body");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            HttpFileClient.log("CLIENT: Getting response code");
            int statusCode = conn.getResponseCode();
            HttpFileClient.log("CLIENT: Response code: " + statusCode);
            InputStream responseStream = statusCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
            String jsonResponse = HttpFileClient.readInputStream(responseStream);
            Map<String, List<String>> map = conn.getHeaderFields();
            ApiResponse apiResponse = new ApiResponse(jsonResponse, statusCode, map);
            return apiResponse;
        }
        finally {
            conn.disconnect();
        }
    }

    private static void writeField(OutputStream out, String name, String value) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("--").append(BOUNDARY).append(CRLF);
        sb.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(CRLF);
        sb.append(CRLF);
        sb.append(value).append(CRLF);
        out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static void writeFile(OutputStream out, String fieldName, Path filePath) throws IOException {
        String fileName = filePath.getFileName().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("--").append(BOUNDARY).append(CRLF);
        sb.append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"; filename=\"").append(fileName).append("\"").append(CRLF);
        sb.append("Content-Type: ").append(HttpFileClient.probeContentType(filePath)).append(CRLF);
        sb.append(CRLF);
        out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        Files.copy(filePath, out);
        out.write(CRLF.getBytes(StandardCharsets.UTF_8));
    }

    public static ApiResponse uploadFile(String url, String fieldName, Path filePath) throws IOException {
        HashMap<String, Path> files = new HashMap<String, Path>();
        files.put(fieldName, filePath);
        return HttpFileClient.uploadFiles(url, files, null);
    }

    private static String probeContentType(Path path) {
        try {
            String type = Files.probeContentType(path);
            return type != null ? type : "application/octet-stream";
        }
        catch (IOException iOException) {
            return "application/octet-stream";
        }
    }

    private static String readInputStream(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            return sb.toString().trim();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Path> files = new HashMap<String, Path>();
            files.put("file1", Paths.get("build.properties", new String[0]));
            files.put("file2", Paths.get("pom.xml", new String[0]));
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("backend", "titan");
            fields.put("command", "compiler");
            fields.put("target", "ttcn-3");
            ApiResponse response2 = HttpFileClient.uploadFiles("http://localhost:3005/compile_asn", files, fields);
            HttpFileClient.log("\nMultiple files uploaded:");
            HttpFileClient.log("Status: " + response2.getStatusCode());
            HttpFileClient.log("Response: " + response2.getJsonBody());
        }
        catch (IOException e) {
            HttpFileClient.log("ERROR: Upload failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        if (T3Q.getLogLevel() == LoggingInterface.LogLevel.DEBUG) {
            System.out.println(message);
        }
    }

    public static class ApiResponse {
        private final String jsonBody;
        private final int statusCode;
        private final Map<String, List<String>> headers;

        public ApiResponse(String jsonBody, int statusCode, Map<String, List<String>> headers) {
            this.jsonBody = jsonBody;
            this.statusCode = statusCode;
            this.headers = headers;
        }

        public String getJsonBody() {
            return this.jsonBody;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getHeader(String name) {
            List<String> values = this.headers.get(name);
            return values != null && !values.isEmpty() ? values.get(0) : null;
        }
    }
}

