/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public abstract class XtextRuleInspector<Result, RuleType extends AbstractRule>
extends XtextSwitch<Result> {
    private final ValidationMessageAcceptor acceptor;
    Collection<AbstractRule> visitedRules;

    public XtextRuleInspector(ValidationMessageAcceptor acceptor) {
        this.acceptor = acceptor;
        this.visitedRules = Sets.newHashSet();
    }

    protected String getIssueCode() {
        return null;
    }

    public void inspect(RuleType rule) {
        if (!this.canInspect(rule)) {
            return;
        }
        Result r = this.doInspect(rule);
        this.handleResult(r, rule);
    }

    protected Result doInspect(RuleType rule) {
        this.visitedRules.add((AbstractRule)rule);
        Object r = this.doSwitch(rule.getAlternatives());
        return (Result)r;
    }

    protected boolean canInspect(RuleType rule) {
        return true;
    }

    protected void handleResult(Result r, RuleType rule) {
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature) {
        this.acceptor.acceptError(message, object, feature, -1, this.getIssueCode(), new String[0]);
    }

    public void acceptWarning(String message, EObject object, EStructuralFeature feature) {
        this.acceptor.acceptWarning(message, object, feature, -1, this.getIssueCode(), new String[0]);
    }

    public boolean addVisited(AbstractRule rule) {
        return this.visitedRules.add(rule);
    }

    public boolean removeVisited(AbstractRule rule) {
        return this.visitedRules.remove(rule);
    }

    public int getNestingLevel() {
        return this.visitedRules.size();
    }

    protected String getTypeRefName(TypeRef typeRef) {
        String simpleName = GrammarUtil.getTypeRefName(typeRef);
        if (typeRef.getMetamodel() != null && !Strings.isEmpty(typeRef.getMetamodel().getAlias())) {
            return typeRef.getMetamodel().getAlias() + "::" + simpleName;
        }
        return simpleName;
    }
}

