/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.util.CancelIndicator;

public class BufferedCancelIndicator
implements CancelIndicator {
    private static final long ONE_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final CancelIndicator delegate;
    private final Ticker clock;
    private final long delayInNanos;
    private long cancelAt;

    public BufferedCancelIndicator(CancelIndicator delegate) {
        this(delegate, Ticker.systemTicker(), ONE_SECOND);
    }

    public BufferedCancelIndicator(CancelIndicator delegate, Ticker clock, long delayInNanos) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.clock = Preconditions.checkNotNull(clock);
        this.delayInNanos = delayInNanos;
    }

    @Override
    public boolean isCanceled() {
        if (this.cancelAt == 0L) {
            if (this.delegate.isCanceled()) {
                this.cancelAt = this.clock.read() + this.delayInNanos;
            }
            return false;
        }
        return this.clock.read() > this.cancelAt;
    }
}

