/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.SerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.BacktrackingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.util.formallang.Nfa;

public class SequencerDiagnosticProvider
implements ISemanticSequencerDiagnosticProvider {
    @Inject
    protected IContextFinder contextFinder;
    @Inject
    protected IGrammarAccess grammarAccess;
    @Inject
    protected IGrammarConstraintProvider grammarConstraints;

    @Override
    @Deprecated
    public ISerializationDiagnostic createBacktrackingFailedDiagnostic(BacktrackingSemanticSequencer.SerializableObject semanticObject, EObject context, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
        ISerializationContext ctx = SerializationContext.fromEObject(context, semanticObject.getEObject());
        SerializationContextMap<IGrammarConstraintProvider.IConstraint> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        return this.createBacktrackingFailedDiagnostic(semanticObject, ctx, constraints.get(ctx));
    }

    @Override
    public ISerializationDiagnostic createBacktrackingFailedDiagnostic(BacktrackingSemanticSequencer.SerializableObject sem, ISerializationContext ctx, IGrammarConstraintProvider.IConstraint constraint) {
        StringBuilder msg;
        EClass type = constraint.getType();
        ArrayList<CallSite> hints = Lists.newArrayList();
        IGrammarConstraintProvider.IFeatureInfo[] iFeatureInfoArray = constraint.getFeatures();
        int n = iFeatureInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            int lowerBound;
            int upperBound;
            IGrammarConstraintProvider.IFeatureInfo feature = iFeatureInfoArray[n2];
            int featureID = type.getFeatureID(feature.getFeature());
            int count = sem.getValueCount(featureID);
            String name = feature.getFeature().getEContainingClass().getName() + "." + feature.getFeature().getName();
            if (!sem.isOptional(featureID) && count > (upperBound = feature.getUpperBound())) {
                if (feature.getFeature().isMany()) {
                    hints.add((CallSite)((Object)(name + " violates the upper bound: It holds " + count + " values, but only " + upperBound + " are allowed.")));
                } else {
                    hints.add((CallSite)((Object)(name + " is not allowed to have a value, but it does.")));
                }
            }
            if (count < (lowerBound = feature.getLowerBound())) {
                if (feature.getFeature().isMany()) {
                    hints.add((CallSite)((Object)(name + " violates the lower bound: It holds " + count + " values, but at least " + lowerBound + " are required.")));
                } else {
                    hints.add((CallSite)((Object)(name + " is required to have a value, but it does not.")));
                }
            }
            ++n2;
        }
        if (!hints.isEmpty()) {
            msg = new StringBuilder();
            msg.append("Could not serialize " + type.getName() + ":\n");
            msg.append(Joiner.on("\n").join(hints));
            return new SerializationDiagnostic("backtracking failed", sem.getEObject(), ctx, this.grammarAccess.getGrammar(), msg.toString());
        }
        msg = new StringBuilder();
        msg.append("Could not serialize " + type.getName() + " via backtracking.\n");
        msg.append("Constraint: " + String.valueOf(constraint) + "\n");
        msg.append(sem.getValuesString());
        return new SerializationDiagnostic("backtracking failed", sem.getEObject(), ctx, this.grammarAccess.getGrammar(), msg.toString());
    }

    @Override
    public ISerializationDiagnostic createFeatureValueMissing(EObject semanticObject, EStructuralFeature feature) {
        String msg = "A value for feature '" + feature.getName() + "' is missing but required.";
        return new SerializationDiagnostic("feature value missing", semanticObject, this.grammarAccess.getGrammar(), msg);
    }

    @Override
    @Deprecated
    public ISerializationDiagnostic createInvalidContextOrTypeDiagnostic(EObject semanticObject, EObject context) {
        ISerializationContext ctx = SerializationContext.fromEObject(context, semanticObject);
        return this.createInvalidContextOrTypeDiagnostic(semanticObject, ctx);
    }

    @Override
    public ISerializationDiagnostic createInvalidContextOrTypeDiagnostic(EObject sem, ISerializationContext context) {
        HashSet<ISerializationContext> contexts = Sets.newHashSet(this.contextFinder.findByContentsAndContainer(sem, null));
        Set<EClass> validTypes = this.getValidTypes(context);
        ArrayList<ISerializationContext> recommendedCtxs = Lists.newArrayList();
        ArrayList<ISerializationContext> otherValidCtxs = Lists.newArrayList();
        for (ISerializationContext ctx : this.getValidContexts(sem.eClass())) {
            if (contexts.contains(ctx)) {
                recommendedCtxs.add(ctx);
                continue;
            }
            otherValidCtxs.add(ctx);
        }
        String semanticType = sem.eClass().getName();
        String validTypeNames = Joiner.on(", ").join(Iterables.transform(validTypes, new NamedElement2Name()));
        StringBuilder msg = new StringBuilder();
        msg.append("The context '" + String.valueOf(context) + "' is not valid for type '" + semanticType + "'\n");
        msg.append("Recommended contexts for type '" + semanticType + "': " + String.valueOf(recommendedCtxs) + "\n");
        if (!otherValidCtxs.isEmpty()) {
            msg.append("Other valid contexts for type '" + semanticType + "': " + String.valueOf(otherValidCtxs));
        }
        msg.append("The context '" + String.valueOf(context) + "' is valid for types: " + validTypeNames + "\n");
        return new SerializationDiagnostic("invalid context or type", sem, this.grammarAccess.getGrammar(), msg.toString());
    }

    protected List<ISerializationContext> getValidContexts(EClass clazz) {
        ArrayList<ISerializationContext> result = Lists.newArrayList();
        SerializationContextMap<IGrammarConstraintProvider.IConstraint> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        for (SerializationContextMap.Entry<IGrammarConstraintProvider.IConstraint> ctx : constraints.values()) {
            for (EClass type : ctx.getTypes()) {
                if (type != clazz) continue;
                result.addAll(ctx.getContexts(type));
            }
        }
        return result;
    }

    protected Set<EClass> getValidTypes(ISerializationContext context) {
        SerializationContextMap<IGrammarConstraintProvider.IConstraint> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        LinkedHashSet<EClass> result = Sets.newLinkedHashSet();
        for (SerializationContextMap.Entry<IGrammarConstraintProvider.IConstraint> ctx : constraints.values()) {
            for (ISerializationContext c : ctx.getContexts()) {
                if (((SerializationContext)c).getActionOrRule() != ((SerializationContext)context).getActionOrRule()) continue;
                result.add(c.getType());
            }
        }
        return result;
    }

    public static class NamedElement2Name
    implements Function<ENamedElement, String> {
        @Override
        public String apply(ENamedElement from) {
            return from == null ? "null" : from.getName();
        }
    }
}

