/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IGrammarPDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.analysis.SerializationContextMap;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaUtil;

@Singleton
public class ContextPDAProvider
implements IContextPDAProvider {
    private static Logger LOG = Logger.getLogger(ContextPDAProvider.class);
    @Inject
    protected SerializerPDA.SerializerPDAElementFactory factory;
    @Inject
    private IGrammarPDAProvider grammarPdaProvider;
    @Inject
    private NfaUtil nfaUtil;
    @Inject
    protected PdaUtil pdaUtil;

    /*
     * Enabled aggressive block sorting
     */
    protected void collectExtracted(ISerState orig, Collection<? extends ISerState> precedents, SerializerPDA.SerializerPDAState copy, Map<Pair<AbstractElement, ISerState.SerStateType>, SerializerPDA.SerializerPDAState> oldToNew, CallStack inTop, SerializerPDA.SerializerPDAState start) {
        block5: for (ISerState iSerState : precedents) {
            CallStack top = inTop;
            AbstractElement element = iSerState.getGrammarElement();
            switch (iSerState.getType()) {
                case START: {
                    if (top.call != null) continue block5;
                    this.connect(start, copy);
                    continue block5;
                }
                case POP: {
                    top = new CallStack(top, (RuleCall)element);
                    if (!top.isLoop()) break;
                    continue block5;
                }
                case PUSH: {
                    if (top.call == null) {
                        this.connect(start, copy);
                        continue block5;
                    }
                    if (top.call != element) continue block5;
                    top = top.parent;
                }
            }
            Pair<AbstractElement, ISerState.SerStateType> key = Tuples.create(element, iSerState.getType());
            SerializerPDA.SerializerPDAState pre2 = oldToNew.get(key);
            if (pre2 == null) {
                pre2 = new SerializerPDA.SerializerPDAState(element, iSerState.getType());
                oldToNew.put(key, pre2);
            }
            if (GrammarUtil.isAssignedAction(iSerState.getGrammarElement())) {
                Set<ISerState> entries = this.collectPushForAction(iSerState);
                this.collectExtracted(iSerState, entries, pre2, oldToNew, top, start);
            } else if (top.visited.add(iSerState)) {
                this.collectExtracted(iSerState, iSerState.getPrecedents(), pre2, oldToNew, top, start);
            }
            this.connect(pre2, copy);
        }
    }

    protected Set<ISerState> collectPushForAction(ISerState action) {
        ParserRule rule = GrammarUtil.containingParserRule(action.getGrammarElement());
        LinkedHashSet<ISerState> result = Sets.newLinkedHashSet();
        this.collectPushForAction(action, rule, result, Sets.newHashSet());
        return result;
    }

    protected void collectPushForAction(ISerState state, ParserRule rule, Set<ISerState> result, Set<ISerState> visited) {
        if (!visited.add(state)) {
            return;
        }
        switch (state.getType()) {
            case START: {
                result.add(state);
                return;
            }
            case PUSH: {
                AbstractElement element = state.getGrammarElement();
                if (!(element instanceof RuleCall) || ((RuleCall)element).getRule() != rule) break;
                result.add(state);
                return;
            }
        }
        List<? extends ISerState> precedents = state.getPrecedents();
        for (ISerState iSerState : precedents) {
            this.collectPushForAction(iSerState, rule, result, visited);
        }
    }

    protected void connect(SerializerPDA.SerializerPDAState precedent, SerializerPDA.SerializerPDAState follower) {
        if (precedent == null || follower == null) {
            return;
        }
        if (follower.getPrecedents().contains(precedent)) {
            return;
        }
        follower.getPrecedents().add(precedent);
        precedent.getFollowers().add(follower);
    }

    protected SerializerPDA extract(ISerState last) {
        SerializerPDA result = this.factory.create(null, null);
        HashMap<Pair<AbstractElement, ISerState.SerStateType>, SerializerPDA.SerializerPDAState> oldToNew = Maps.newHashMap();
        CallStack callStack = new CallStack(null, null);
        this.collectExtracted(last, last.getPrecedents(), result.getStop(), oldToNew, callStack, result.getStart());
        return result;
    }

    protected EObject getContext(AbstractElement ele) {
        if (ele instanceof RuleCall) {
            if (GrammarUtil.isAssignedEObjectRuleCall(ele)) {
                return ((RuleCall)ele).getRule();
            }
        } else if (GrammarUtil.isAssignedAction(ele)) {
            return ele;
        }
        return null;
    }

    protected ParserRule getFilterableRule(ISerState state) {
        RuleCall rc;
        AbstractRule rule;
        if (state.getType() == ISerState.SerStateType.PUSH && (rule = (rc = (RuleCall)state.getGrammarElement()).getRule()) instanceof ParserRule) {
            ParserRule pr = (ParserRule)rule;
            if (pr.isFragment()) {
                return null;
            }
            if (pr.isDefinesHiddenTokens()) {
                return null;
            }
            return pr;
        }
        return null;
    }

    protected Pda<ISerState, RuleCall> filterUnneededUnassignedRuleCalls(Pda<ISerState, RuleCall> pda, Map<ParserRule, Integer> indexedRules) {
        final Set<ParserRule> exclude = this.findRuleCallsToExclude(pda, indexedRules);
        if (exclude.isEmpty()) {
            return pda;
        }
        SerializerPDA filtered = this.pdaUtil.filter(pda, new Predicate<ISerState>(){

            @Override
            public boolean apply(ISerState input) {
                ISerState.SerStateType type = input.getType();
                if (type == ISerState.SerStateType.PUSH || type == ISerState.SerStateType.POP) {
                    AbstractRule rule = ((RuleCall)input.getGrammarElement()).getRule();
                    return !exclude.contains(rule);
                }
                return true;
            }
        }, new SerializerPDA.SerializerPDACloneFactory());
        return filtered;
    }

    protected Set<ParserRule> findRuleCallsToExclude(Pda<ISerState, RuleCall> pda, final Map<ParserRule, Integer> indexedRules) {
        final LinkedHashMap<ParserRule, Integer> result = Maps.newLinkedHashMap();
        for (ISerState s2 : this.nfaUtil.collect(pda)) {
            ParserRule pr = this.getFilterableRule(s2);
            if (pr == null) continue;
            Integer integer = (Integer)result.get(pr);
            result.put(pr, integer == null ? 1 : integer + 1);
        }
        Iterator it = result.values().iterator();
        while (it.hasNext()) {
            if ((Integer)it.next() <= 1) continue;
            it.remove();
        }
        this.nfaUtil.findCycles(pda, new IAcceptor<List<ISerState>>(){

            @Override
            public void accept(List<ISerState> states) {
                ParserRule candidate = null;
                Integer candiateIndex = Integer.MAX_VALUE;
                for (ISerState state : states) {
                    ParserRule rule = ContextPDAProvider.this.getFilterableRule(state);
                    if (rule == null) continue;
                    Integer index = (Integer)indexedRules.get(rule);
                    if (candiateIndex <= index) continue;
                    candidate = rule;
                    candiateIndex = index;
                }
                if (candidate != null) {
                    result.remove(candidate);
                }
            }
        });
        return result.keySet();
    }

    protected Map<ParserRule, Integer> indexRules(Grammar grammar) {
        List<ParserRule> rules = GrammarUtil.allParserRules(grammar);
        HashMap<ParserRule, Integer> map = Maps.newHashMap();
        int i = 0;
        while (i < rules.size()) {
            map.put(rules.get(i), i);
            ++i;
        }
        return map;
    }

    @Override
    public SerializationContextMap<Pda<ISerState, RuleCall>> getContextPDAs(Grammar grammar) {
        SerializationContextMap.Builder<Pda<ISerState, RuleCall>> result = SerializationContextMap.builder();
        SerializationContextMap<Pda<ISerState, RuleCall>> grammarPDAs = this.grammarPdaProvider.getGrammarPDAs(grammar);
        ArrayListMultimap<Action, SerializerPDA> actionPdas = ArrayListMultimap.create();
        LinkedHashMultimap<Action, ISerializationContext> actionContexts = LinkedHashMultimap.create();
        Map<ParserRule, Integer> indexedRules = this.indexRules(grammar);
        for (SerializationContextMap.Entry<Pda<ISerState, RuleCall>> entry : grammarPDAs.values()) {
            List<ISerializationContext> contexts = entry.getContexts();
            Pda<ISerState, RuleCall> pda = entry.getValue();
            ArrayList<ISerState> arrayList = Lists.newArrayList();
            for (ISerState state : this.nfaUtil.collect(pda)) {
                if (!GrammarUtil.isAssignedAction(state.getGrammarElement())) continue;
                arrayList.add(state);
            }
            if (arrayList.isEmpty()) {
                Pda<ISerState, RuleCall> filtered = this.filterUnneededUnassignedRuleCalls(pda, indexedRules);
                result.put(contexts, filtered);
                continue;
            }
            try {
                SerializerPDA rulePda = this.extract((ISerState)pda.getStop());
                Pda<ISerState, RuleCall> filtered = this.filterUnneededUnassignedRuleCalls(rulePda, indexedRules);
                result.put(contexts, filtered);
                for (ISerState state : arrayList) {
                    Action action = (Action)state.getGrammarElement();
                    SerializerPDA actionPda = this.extract(state);
                    actionPdas.put(action, actionPda);
                    actionContexts.putAll(action, contexts);
                }
            }
            catch (Exception x) {
                LOG.error("Error extracting PDA for action in context '" + String.valueOf(contexts) + "': " + x.getMessage(), x);
            }
        }
        for (Map.Entry entry : actionPdas.asMap().entrySet()) {
            SerializerPDA merged = this.merge(new SerializationContext.ActionContext(null, (Action)entry.getKey()), (Collection)entry.getValue());
            LinkedHashSet<Set<Parameter>> parameterPermutations = Sets.newLinkedHashSet();
            for (ISerializationContext iSerializationContext : actionContexts.get((Action)entry.getKey())) {
                parameterPermutations.add(iSerializationContext.getEnabledBooleanParameters());
            }
            for (Set set : parameterPermutations) {
                SerializationContext context = new SerializationContext.ActionContext(null, (Action)entry.getKey());
                if (!set.isEmpty()) {
                    context = new SerializationContext.ParameterValueContext(context, set);
                }
                Pda<ISerState, RuleCall> filtered = this.filterUnneededUnassignedRuleCalls(merged, indexedRules);
                result.put(context, filtered);
            }
        }
        return result.create();
    }

    protected SerializerPDA merge(ISerializationContext context, Collection<SerializerPDA> pdas) {
        if (pdas.isEmpty()) {
            throw new IllegalStateException();
        }
        if (pdas.size() == 1) {
            return pdas.iterator().next();
        }
        SerializerPDA merged = this.factory.create(null, null);
        HashMap<ISerState, SerializerPDA.SerializerPDAState> oldToNew = Maps.newHashMap();
        for (Pda pda : pdas) {
            oldToNew.put((ISerState)pda.getStop(), merged.getStop());
            this.merge((ISerState)pda.getStart(), merged.getStart(), oldToNew, new IdentityHashMap<ISerState, Boolean>());
        }
        return merged;
    }

    protected void merge(ISerState orig, SerializerPDA.SerializerPDAState copy, Map<ISerState, SerializerPDA.SerializerPDAState> oldToNew, IdentityHashMap<ISerState, Boolean> visited) {
        for (ISerState iSerState : orig.getFollowers()) {
            SerializerPDA.SerializerPDAState folCopy = oldToNew.get(iSerState);
            if (folCopy == null) {
                folCopy = new SerializerPDA.SerializerPDAState(iSerState.getGrammarElement(), iSerState.getType());
                oldToNew.put(iSerState, folCopy);
            }
            this.connect(copy, folCopy);
            if (visited.put(iSerState, Boolean.TRUE) != null) continue;
            this.merge(iSerState, folCopy, oldToNew, visited);
        }
    }

    protected static class CallStack {
        private final RuleCall call;
        private final CallStack parent;
        private final Set<ISerState> visited = Sets.newHashSet();

        public CallStack(CallStack parent, RuleCall call) {
            this.parent = parent;
            this.call = call;
        }

        public boolean isLoop() {
            CallStack current = this.parent;
            int counter = 0;
            while (current != null) {
                if (current.call == this.call) {
                    ++counter;
                }
                if (counter >= 2) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }
    }
}

