/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.linking.impl.AbstractLinker;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticProducer;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.internal.Stopwatches;

public abstract class AbstractCleaningLinker
extends AbstractLinker {
    private static final Logger log = Logger.getLogger(AbstractCleaningLinker.class);

    @Override
    public void linkModel(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        long now;
        Stopwatches.StoppedTask task = Stopwatches.forTask("installing proxies (AbstractCleaningLinker.linkModel)");
        task.start();
        boolean debug = log.isDebugEnabled();
        long time = System.currentTimeMillis();
        this.beforeModelLinked(model, diagnosticsConsumer);
        if (debug) {
            now = System.currentTimeMillis();
            log.debug("beforeModelLinked took: " + (now - time) + "ms");
            time = now;
        }
        this.doLinkModel(model, diagnosticsConsumer);
        if (debug) {
            now = System.currentTimeMillis();
            log.debug("doLinkModel took: " + (now - time) + "ms");
            time = now;
        }
        this.afterModelLinked(model, diagnosticsConsumer);
        if (debug) {
            now = System.currentTimeMillis();
            log.debug("afterModelLinked took: " + (now - time) + "ms");
            time = now;
        }
        task.stop();
    }

    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
    }

    protected abstract void doLinkModel(EObject var1, IDiagnosticConsumer var2);

    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        ImportedNamesAdapter adapter;
        Resource resource = model.eResource();
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).clearLazyProxyInformation();
        }
        if ((adapter = ImportedNamesAdapter.find(resource)) != null) {
            adapter.clear();
        }
    }

    protected boolean isClearAllReferencesRequired(Resource resource) {
        return true;
    }

    @Deprecated
    protected void clearAllReferences(EObject model) {
        TreeIterator<EObject> iter = this.getAllLinkableContents(model);
        while (iter.hasNext()) {
            this.clearReferences((EObject)iter.next());
        }
    }

    protected TreeIterator<EObject> getAllLinkableContents(EObject model) {
        return new AbstractTreeIterator<EObject>(model){

            @Override
            public Iterator<EObject> getChildren(Object object) {
                return ((EObject)object).eContents().iterator();
            }
        };
    }

    protected void clearReferences(EObject obj) {
        for (EReference ref : obj.eClass().getEAllReferences()) {
            this.clearReference(obj, ref);
        }
    }

    protected void clearReference(EObject obj, EReference ref) {
        if (!(ref.isContainment() || ref.isContainer() || ref.isDerived() || !ref.isChangeable() || ref.isTransient())) {
            obj.eUnset(ref);
        }
    }

    protected boolean shouldCheckParentNode(INode node) {
        ICompositeNode parent;
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof AbstractElement && (parent = node.getParent()) != null) {
            if (!parent.hasDirectSemanticElement()) {
                if (this.isContainedInFragmentRule(grammarElement)) {
                    return false;
                }
                Assignment assignment = GrammarUtil.containingAssignment(grammarElement);
                if (assignment == null) {
                    return true;
                }
            }
            if (grammarElement instanceof Action && this.isContainedInFragmentRule(grammarElement)) {
                return parent.getGrammarElement() instanceof RuleCall;
            }
        }
        return false;
    }

    private boolean isContainedInFragmentRule(EObject grammarElement) {
        ParserRule rule = (ParserRule)GrammarUtil.containingRule(grammarElement);
        return rule.isFragment();
    }

    protected IDiagnosticProducer createDiagnosticProducer(IDiagnosticConsumer consumer, Resource resource) {
        IDiagnosticProducer result = this.createDiagnosticProducer(consumer);
        if (resource instanceof XtextResource) {
            result = ((XtextResource)resource).wrap(result);
        }
        return result;
    }

    protected IDiagnosticProducer createDiagnosticProducer(IDiagnosticConsumer consumer) {
        return new LinkingDiagnosticProducer(consumer);
    }
}

