/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;

public class TraceAsSmapInstaller
implements ITraceToBytecodeInstaller {
    private static final Logger LOG = Logger.getLogger(TraceAsSmapInstaller.class);
    private static final String DELEGATE_CLASS = "org.eclipse.xtext.smap.TraceAsSmapInstaller";
    Object delegate;

    @Inject
    protected void setInjector(Injector injector) {
        try {
            Class<?> loadClass = this.getClass().getClassLoader().loadClass(DELEGATE_CLASS);
            this.delegate = injector.getInstance(loadClass);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Cannot install debug information into bytecode, because 'org.eclipse.xtext.smap' is missing on the classpath. Please add 'org.eclipse.xtext.smap' to your plugin classpath.");
        }
    }

    @Override
    public byte[] installTrace(byte[] javaClassBytecode) throws IOException {
        if (this.delegate == null) {
            return javaClassBytecode;
        }
        try {
            Method method = this.delegate.getClass().getMethod("installTrace", javaClassBytecode.getClass());
            Object result = method.invoke(this.delegate, new Object[]{javaClassBytecode});
            return (byte[])result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error("Error installing trace information.", e);
            return javaClassBytecode;
        }
    }

    @Override
    public void setTrace(String javaFileName, AbstractTraceRegion trace) {
        if (this.delegate == null) {
            return;
        }
        try {
            Method method = this.delegate.getClass().getMethod("setTrace", String.class, AbstractTraceRegion.class);
            method.invoke(this.delegate, javaFileName, trace);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error("Error setting trace information.", e);
        }
    }
}

